/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.metadata.DefaultStatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MetadataPublicationMailNotifier {
    @Value(value="${metadata.publicationmail.format.html:true}")
    private boolean sendHtmlMail;
    @Autowired
    SettingManager settingManager;
    @Autowired
    GroupRepository groupRepository;

    public void notifyPublication(Locale[] feedbackLocales, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication) {
        StatusValueNotificationLevel notificationLevel;
        String notificationSetting = this.settingManager.getValue("system/metadataprivs/publication/notificationLevel");
        if (StringUtils.isNotEmpty((CharSequence)notificationSetting) && (notificationLevel = StatusValueNotificationLevel.valueOf((String)notificationSetting)) != null) {
            if (notificationLevel.name().startsWith("recordProfile")) {
                Map<Integer, List<MetadataPublicationNotificationInfo>> metadataListToNotifyPublicationPerGroup = metadataListToNotifyPublication.stream().filter(metadata -> metadata.getGroupId() != null).collect(Collectors.groupingBy(MetadataPublicationNotificationInfo::getGroupId));
                metadataListToNotifyPublicationPerGroup.forEach((groupId, metadataNotificationInfoList) -> {
                    Set metadataIds = metadataNotificationInfoList.stream().map(MetadataPublicationNotificationInfo::getMetadataId).collect(Collectors.toSet());
                    List userToNotify = DefaultStatusActions.getUserToNotify((StatusValueNotificationLevel)notificationLevel, metadataIds, null);
                    List<String> toAddress1 = userToNotify.stream().map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                    this.sendMailPublicationNotification(feedbackLocales, toAddress1, (List<MetadataPublicationNotificationInfo>)metadataNotificationInfoList);
                });
            } else {
                List<String> toAddress;
                if (notificationLevel == StatusValueNotificationLevel.recordGroupEmail) {
                    List groupToNotify = DefaultStatusActions.getGroupToNotify((StatusValueNotificationLevel)notificationLevel, Arrays.asList(this.settingManager.getValue("system/metadataprivs/publication/notificationGroups").split("\\|")));
                    toAddress = groupToNotify.stream().map(Group::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                } else {
                    Set metadataIds = metadataListToNotifyPublication.stream().map(MetadataPublicationNotificationInfo::getMetadataId).collect(Collectors.toSet());
                    List userToNotify = DefaultStatusActions.getUserToNotify((StatusValueNotificationLevel)notificationLevel, metadataIds, null);
                    toAddress = userToNotify.stream().map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                }
                this.sendMailPublicationNotification(feedbackLocales, toAddress, metadataListToNotifyPublication);
            }
        }
    }

    private void sendMailPublicationNotification(Locale[] feedbackLocales, List<String> toAddress, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication) {
        if (toAddress.isEmpty()) {
            return;
        }
        LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "metadata_published_subject", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "metadata_published_text", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
        for (Locale feedbackLocale : feedbackLocales) {
            emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)this.settingManager.getSiteName())});
            StringBuilder listOfProcessedMetadataMessage = new StringBuilder();
            metadataListToNotifyPublication.forEach(metadata -> {
                Optional group = this.groupRepository.findById((Object)metadata.getGroupId());
                String recordMessageKey = Boolean.TRUE.equals(metadata.getPublished()) ? (!metadata.isReapproval() ? "metadata_published_record_text" : "metadata_approved_published_record_text") : "metadata_unpublished_record_text";
                LocalizedEmailComponent recordMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.NESTED, recordMessageKey, LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.NAMED_FORMAT);
                recordMessageComponent.enableCompileWithIndexFields(metadata.getMetadataUuid());
                recordMessageComponent.enableReplaceLinks(Boolean.valueOf(true));
                recordMessageComponent.addParameters(feedbackLocale, this.getReplacementParameters((MetadataPublicationNotificationInfo)metadata, group));
                listOfProcessedMetadataMessage.append(recordMessageComponent.parseMessage(feedbackLocale));
            });
            emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter[]{new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)1, (Object)listOfProcessedMetadataMessage.toString())});
        }
        LocalizedEmail localizedEmail = new LocalizedEmail(Boolean.valueOf(this.sendHtmlMail));
        localizedEmail.addComponents(new LocalizedEmailComponent[]{emailSubjectComponent, emailMessageComponent});
        String subject = localizedEmail.getParsedSubject(feedbackLocales);
        String message = localizedEmail.getParsedMessage(feedbackLocales);
        try {
            if (this.sendHtmlMail) {
                MailUtil.sendHtmlMail(toAddress, (String)subject, (String)message, (SettingManager)this.settingManager);
            } else {
                MailUtil.sendMail(toAddress, (String)subject, (String)message, (SettingManager)this.settingManager);
            }
        }
        catch (IllegalArgumentException ex) {
            Log.warning((String)"geonetwork.api", (Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private LocalizedEmailParameter[] getReplacementParameters(MetadataPublicationNotificationInfo metadata, Optional<Group> group) {
        ArrayList<LocalizedEmailParameter> parameters = new ArrayList<LocalizedEmailParameter>();
        parameters.add(new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)"{{publisherUser}}", (Object)metadata.getPublisherUser()));
        parameters.add(new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)"{{submitterUser}}", (Object)metadata.getSubmitterUser()));
        parameters.add(new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)"{{reviewerUser}}", (Object)metadata.getReviewerUser()));
        parameters.add(new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)"{{timeStamp}}", (Object)metadata.getPublicationDateStamp().getDateAndTime()));
        if (group.isPresent()) {
            parameters.add(new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, (Object)"{{group}}", (Object)group.get().getName()));
        }
        return parameters.toArray(new LocalizedEmailParameter[0]);
    }
}

