/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.component.ProfileManager;
import jeeves.config.springutil.ServerBeanPropertyUpdater;
import jeeves.server.JeevesProxyInfo;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.OpenApiConfig;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.site.LogUtils;
import org.fao.geonet.api.site.SiteInformation;
import org.fao.geonet.api.site.model.SettingSet;
import org.fao.geonet.api.site.model.SettingsListResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.users.recaptcha.RecaptchaChecker;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.events.setting.SettingsChanged;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.index.Status;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.index.es.EsServerStatusChecker;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataManager;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.lib.ProxyConfiguration;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.ProxyInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/site"})
@Tag(name="site", description="Catalog operations")
@Controller(value="site")
public class SiteApi
implements ApplicationEventPublisherAware {
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    SettingManager settingManager;
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    NodeInfo node;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    MetadataDraftRepository metadataDraftRepository;
    @Autowired
    EsRestClient esRestClient;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    private SystemInfo info;
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public static void reloadServices(ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settingMan = (SettingManager)gc.getBean(SettingManager.class);
        LogUtils.refreshLogConfiguration();
        try {
            ProxyInfo pi = JeevesProxyInfo.getInstance();
            boolean useProxy = Lib.net.getProxyConfiguration().isEnabled();
            if (useProxy) {
                String proxyHost = Lib.net.getProxyConfiguration().getHost();
                String proxyPort = Lib.net.getProxyConfiguration().getPort();
                String username = Lib.net.getProxyConfiguration().getUsername();
                String password = Lib.net.getProxyConfiguration().getPassword();
                pi.setProxyInfo(proxyHost, Integer.valueOf(proxyPort).intValue(), username, password);
            } else {
                pi.setProxyInfo(null, -1, null, null);
            }
            Lib.net.setupProxy(settingMan);
        }
        catch (Exception e) {
            context.error("Reload services. Error: " + e.getMessage());
            context.error((Throwable)e);
            throw new OperationAbortedEx("Parameters saved but cannot set proxy information: " + e.getMessage());
        }
        DoiManager doiManager = (DoiManager)gc.getBean(DoiManager.class);
        doiManager.loadConfig();
        HarvestManager harvestManager = (HarvestManager)context.getBean(HarvestManager.class);
        harvestManager.rescheduleActiveHarvesters();
    }

    @Operation(summary="Get site (or portal) description", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Site description.")})
    @ResponseBody
    public SettingsListResponse getSiteOrPortalDescription(@Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String nodeDefault;
        Optional source;
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(this.settingManager.getSettings(new String[]{"system/site/name", "system/site/organization", "system/site/siteId", "system/platform/version", "system/platform/subVersion"}));
        if ("srv".equals(this.node.getId())) {
            source = this.sourceRepository.findById((Object)this.settingManager.getSiteId());
            nodeDefault = "true";
        } else {
            source = this.sourceRepository.findById((Object)this.node.getId());
            nodeDefault = "false";
        }
        if (source.isPresent()) {
            List<Setting> settings = response.getSettings();
            String iso3langCode = this.languageUtils.getIso3langCode(request.getLocales());
            settings.add(new Setting().setName("node/default").setValue(nodeDefault));
            settings.add(new Setting().setName("node/id").setValue(((Source)source.get()).getUuid()));
            settings.add(new Setting().setName("node/name").setValue(StringUtils.isEmpty((CharSequence)((Source)source.get()).getLabel(iso3langCode)) ? ((Source)source.get()).getName() : ((Source)source.get()).getLabel(iso3langCode)));
        }
        String microservicesTargetUri = (String)request.getServletContext().getAttribute("MicroServicesProxy.targetUri");
        response.getSettings().add(new Setting().setName("microservices/enabled").setValue(Boolean.toString(StringUtils.isNotBlank((CharSequence)microservicesTargetUri))).setDataType(SettingDataType.BOOLEAN));
        return response;
    }

    @Operation(summary="Get settings", description="Return public settings for anonymous users, internals are allowed for authenticated.")
    @RequestMapping(path={"/settings"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Settings.")})
    @ResponseBody
    public SettingsListResponse getSettingsSet(@Parameter(description="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @Parameter(description="Setting key", required=false) @RequestParam(required=false) String[] key, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            SettingRepository settingRepository = (SettingRepository)appContext.getBean(SettingRepository.class);
            List publicSettings = settingRepository.findAllByInternal(false);
            String mailServer = this.settingManager.getValue("system/feedback/mailServer/host");
            publicSettings.add(new Setting().setName("system/feedback/mailServer/hostIsDefined").setDataType(SettingDataType.BOOLEAN).setValue(StringUtils.isNotEmpty((CharSequence)mailServer) + ""));
            SettingsListResponse response = new SettingsListResponse();
            response.setSettings(publicSettings);
            return response;
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = this.settingManager.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(settings);
        return response;
    }

    @Operation(summary="Get settings with details", description="Provides also setting properties.")
    @RequestMapping(path={"/settings/details"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Settings with details.")})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('Administrator')")
    public List<Setting> getSettingsDetails(@Parameter(description="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @Parameter(description="Setting key", required=false) @RequestParam(required=false) String[] key, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            return this.settingManager.getAll();
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = this.settingManager.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        return settings;
    }

    @Operation(summary="Save settings", description="Save the provided settings.", requestBody=@RequestBody(description="Map of settings to be saved", required=true, content={@Content(mediaType="application/x-www-form-urlencoded", schema=@Schema(implementation=Map.class), examples={@ExampleObject(name="Example setting (application/x-www-form-urlencoded)", value="{\n  \"additionalProp1\": \"string\",\n  \"additionalProp2\": \"string\",\n  \"additionalProp3\": \"string\"\n}"), @ExampleObject(name="Example setting selection manager max records to 1000 (application/x-www-form-urlencoded)", value="{\n  \"system/selectionmanager/maxrecords\": \"1000\"\n}")}), @Content(mediaType="application/json", schema=@Schema(implementation=Map.class), examples={@ExampleObject(name="Example setting (application/json)", value="{\n  \"additionalProp1\": \"string\",\n  \"additionalProp2\": \"string\",\n  \"additionalProp3\": \"string\"\n}"), @ExampleObject(name="Example setting selection manager max records to 1000 (application/json)", value="{\n  \"system/selectionmanager/maxrecords\": \"1000\"\n}")})}))
    @PostMapping(path={"/settings"}, consumes={"application/x-www-form-urlencoded", "application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings saved."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    public void saveSettings(@Parameter(description="Map of settings to be saved", required=true, hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) throws Exception {
        String newBaseUrl;
        Optional siteSourceOpt;
        if ("application/json".equals(request.getContentType()) && allRequestParams.isEmpty()) {
            BufferedReader reader = request.getReader();
            ObjectMapper mapper = new ObjectMapper();
            allRequestParams = (Map)mapper.readValue((Reader)reader, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        String currentUuid = this.settingManager.getSiteId();
        String oldSiteName = this.settingManager.getSiteName();
        String oldBaseUrl = this.settingManager.getBaseURL();
        List oldSettings = this.settingManager.getAll();
        List oldSettingsClone = oldSettings.stream().map(Setting::createDeepCopy).collect(Collectors.toList());
        if (!this.settingManager.setValues(allRequestParams)) {
            throw new OperationAbortedEx("Cannot set all values");
        }
        String newSiteName = this.settingManager.getSiteName();
        if (!oldSiteName.equals(newSiteName) && (siteSourceOpt = this.sourceRepository.findById((Object)currentUuid)).isPresent()) {
            Source siteSource = (Source)siteSourceOpt.get();
            siteSource.setName(newSiteName);
            siteSource.getLabelTranslations().forEach((l, t) -> siteSource.getLabelTranslations().put(l, newSiteName));
            this.sourceRepository.save((Object)siteSource);
        }
        if (!oldBaseUrl.equals(newBaseUrl = this.settingManager.getBaseURL())) {
            OpenApiConfig.setHostRelatedInfo();
        }
        String zoneId = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("system/server/timeZone", true), (CharSequence)SettingManager.DEFAULT_SERVER_TIMEZONE.getId());
        TimeZone.setDefault(TimeZone.getTimeZone(zoneId));
        String newUuid = (String)allRequestParams.get("system/site/siteId");
        if (newUuid != null && !currentUuid.equals(newUuid)) {
            IMetadataManager metadataManager = (IMetadataManager)applicationContext.getBean(IMetadataManager.class);
            Optional sourceOpt = this.sourceRepository.findById((Object)currentUuid);
            if (sourceOpt.isPresent()) {
                Source source = (Source)sourceOpt.get();
                Source newSource = new Source(newUuid, source.getName(), source.getLabelTranslations(), source.getType());
                this.sourceRepository.save((Object)newSource);
                PathSpec servicesPath = root -> root.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.sourceId);
                metadataManager.createBatchUpdateQuery(servicesPath, newUuid, MetadataSpecs.isHarvested((boolean)false));
                this.sourceRepository.delete((Object)source);
            }
        }
        SettingInfo settingInfo = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        ServiceContext context = ApiUtils.createServiceContext(request);
        ServerBeanPropertyUpdater.updateURL((String)(settingInfo.getSiteUrl() + context.getBaseUrl()), (ApplicationContext)applicationContext);
        SiteApi.reloadServices(context);
        this.eventPublisher.publishEvent((ApplicationEvent)new SettingsChanged(this.settingManager.getAll(), oldSettingsClone));
    }

    @Operation(summary="Get site informations", description="")
    @RequestMapping(path={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Site information.")})
    @ResponseBody
    public SiteInformation getInformation(HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return new SiteInformation(context, (GeonetContext)context.getHandlerContext("contextName"));
    }

    @Operation(summary="Is CAS enabled?", description="")
    @RequestMapping(path={"/info/isCasEnabled"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isCasEnabled(HttpServletRequest request) throws Exception {
        ApiUtils.createServiceContext(request);
        return ProfileManager.isCasEnabled();
    }

    @Operation(summary="Update staging profile", description="TODO: Needs doc")
    @RequestMapping(path={"/info/staging/{profile}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Staging profile saved."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    public void updateStagingProfile(@PathVariable SystemInfo.Staging profile) {
        this.info.setStagingProfile(profile.toString());
    }

    @Operation(summary="Is in read-only mode?", description="")
    @RequestMapping(path={"/info/readonly"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isReadOnly() throws Exception {
        return ((NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class)).isReadOnly();
    }

    @Operation(summary="Is indexing?", description="")
    @RequestMapping(path={"/indexing"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isIndexing(HttpServletRequest request) throws Exception {
        ApiUtils.createServiceContext(request);
        return ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).isIndexing();
    }

    @Operation(summary="Index", description="")
    @RequestMapping(path={"/index"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public HttpEntity indexSite(@Parameter(description="Drop and recreate index", required=false) @RequestParam(required=false, defaultValue="true") boolean reset, @Parameter(description="Asynchronous mode (only on all records. ie. no selection bucket)", required=false) @RequestParam(required=false, defaultValue="false") boolean asynchronous, @Parameter(description="Records having only XLinks", required=false) @RequestParam(required=false, defaultValue="false") boolean havingXlinkOnly, @Parameter(description="Index. By default only remove record index.", required=false) @RequestParam(required=false, defaultValue="records") String[] indices, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        DataManager dataManager = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class);
        boolean isIndexing = dataManager.isIndexing();
        if (isIndexing) {
            throw new NotAllowedException("Indexing is already in progress. Wait for the current task to complete.");
        }
        if (reset) {
            searchMan.init(true, Optional.of(Arrays.asList(indices)));
        }
        if (StringUtils.isEmpty((CharSequence)bucket)) {
            BaseMetadataManager metadataManager = (BaseMetadataManager)ApplicationContextHolder.get().getBean(BaseMetadataManager.class);
            metadataManager.synchronizeDbWithIndex(context, Boolean.valueOf(false), Boolean.valueOf(asynchronous));
        } else {
            searchMan.rebuildIndex(context, havingXlinkOnly, false, bucket);
        }
        return new HttpEntity((Object)HttpStatus.CREATED);
    }

    @Operation(summary="Index commit", description="")
    @RequestMapping(path={"/index/commit"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    public void indexCommit(HttpServletRequest request) throws Exception {
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        searchMan.forceIndexChanges();
    }

    @Operation(summary="Index status", description="")
    @RequestMapping(path={"/index/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Status indexStatus(HttpServletRequest request) throws Exception {
        EsServerStatusChecker serverStatusChecker = (EsServerStatusChecker)ApplicationContextHolder.get().getBean(EsServerStatusChecker.class);
        return serverStatusChecker.getStatus();
    }

    @Operation(summary="Index synchronized with database", description="")
    @RequestMapping(path={"/index/synchronized"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> indexAndDbSynchronizationStatus(HttpServletRequest request) throws Exception {
        HashMap<String, Object> infoIndexDbSynch = new HashMap<String, Object>();
        long dbCount = this.metadataRepository.count();
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (isMdWorkflowEnable) {
            dbCount += this.metadataDraftRepository.count();
        }
        infoIndexDbSynch.put("db.count", dbCount);
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        CountResponse countResponse = this.esRestClient.getClient().count(new CountRequest(new String[]{searchMan.getDefaultIndex()}), RequestOptions.DEFAULT);
        infoIndexDbSynch.put("index.count", countResponse.getCount());
        return infoIndexDbSynch;
    }

    @Operation(summary="Force to commit pending documents in index.", description="May be used when indexing task is hanging.")
    @PutMapping(path={"/index/commit"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Changes committed.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Administrator')")
    public void commitIndexChanges() throws Exception {
        ((EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class)).forceIndexChanges();
    }

    @Operation(summary="Get build details", description="To know when and how this version of the application was built.")
    @RequestMapping(path={"/info/build"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Build info.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public SystemInfo getSystemInfo() throws Exception {
        return (SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class);
    }

    @Operation(summary="Get notification levels", description="")
    @RequestMapping(path={"/info/notificationLevels"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of notification levels.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public StatusValueNotificationLevel[] getNotificationLevel() {
        return StatusValueNotificationLevel.values();
    }

    @Operation(summary="Get proxy configuration details", description="Get the proxy configuration.")
    @RequestMapping(path={"/info/proxy"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Proxy configuration.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public ProxyConfiguration getProxyConfiguration() {
        return Lib.net.getProxyConfiguration();
    }

    @Operation(summary="Set catalog logo", description="Logos are stored in the data directory resources/images/harvesting as PNG or GIF images. When a logo is assigned to the catalog, a new image is created in images/logos/<catalogUuid>.png.")
    @RequestMapping(path={"/logo"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Logo set."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    public void setLogo(@Parameter(description="Logo to use for the catalog") @RequestParam(value="file") String file, @Parameter(description="Create favicon too", required=false) @RequestParam(defaultValue="false", required=false) boolean asFavicon, HttpServletRequest request) throws Exception {
        block80: {
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            Path logoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Streams.checkFileName((String)file);
            FilePathChecker.verify((String)file);
            String nodeUuid = this.settingManager.getSiteId();
            Resources.ResourceHolder holder = resources.getImage(serviceContext, file, logoDirectory);
            Path resourcesDir = resources.locateResourcesDir(request.getServletContext(), (ApplicationContext)serviceContext.getApplicationContext());
            if (holder == null || holder.getPath() == null) {
                holder = resources.getImage(serviceContext, "images/harvesting/" + file, resourcesDir);
            }
            try (InputStream inputStream = Files.newInputStream(holder.getPath(), new OpenOption[0]);){
                BufferedImage source = ImageIO.read(inputStream);
                if (asFavicon) {
                    try (Resources.ResourceHolder favicon = resources.getWritableImage(serviceContext, "images/logos/favicon.png", resourcesDir);){
                        ApiUtils.createFavicon(source, favicon.getPath());
                        break block80;
                    }
                }
                try (Resources.ResourceHolder logo = resources.getWritableImage(serviceContext, "images/logos/" + nodeUuid + ".png", resourcesDir);
                     Resources.ResourceHolder defaultLogo = resources.getWritableImage(serviceContext, "images/logo.png", resourcesDir);){
                    if (!file.endsWith(".png")) {
                        try (OutputStream logoOut = Files.newOutputStream(logo.getPath(), new OpenOption[0]);
                             OutputStream defLogoOut = Files.newOutputStream(defaultLogo.getPath(), new OpenOption[0]);){
                            ImageIO.write((RenderedImage)source, "png", logoOut);
                            ImageIO.write((RenderedImage)source, "png", defLogoOut);
                            break block80;
                        }
                    }
                    Files.copy(holder.getPath(), logo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(holder.getPath(), defaultLogo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to move uploaded thumbnail to destination directory. Error: " + e.getMessage());
            }
            finally {
                holder.close();
            }
        }
    }

    @Operation(summary="Get XSL tranformations available", description="XSL transformations may be applied while importing or harvesting records.")
    @RequestMapping(path={"/info/transforms"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="XSLT available.")})
    @ResponseBody
    public List<String> getXslTransformations() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        this.schemaManager.getSchemas().forEach(schema -> {
            try (DirectoryStream<Path> sheets = Files.newDirectoryStream(this.dataDirectory.getSchemaPluginsDir().resolve((String)schema).resolve("convert"));){
                for (Path sheet : sheets) {
                    String id = sheet.toString();
                    if (id == null || !id.contains("convert" + File.separator + "from") || !id.endsWith(".xsl")) continue;
                    String name = com.google.common.io.Files.getNameWithoutExtension((String)sheet.getFileName().toString());
                    list.add("schema:" + schema + ":convert/" + name);
                }
            }
            catch (IOException e) {
                Log.warning((String)"geonetwork", (Object)("Error getting conversion xslt transformations for schemas: " + e.getMessage()));
            }
        });
        try (DirectoryStream<Path> sheets = Files.newDirectoryStream(this.dataDirectory.getWebappDir().resolve("xsl/conversion/import"));){
            for (Path sheet : sheets) {
                String id = sheet.toString();
                if (id == null || !id.endsWith(".xsl")) continue;
                String name = com.google.common.io.Files.getNameWithoutExtension((String)sheet.getFileName().toString());
                list.add(name);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    @Operation(summary="Send an email to catalogue administrator with feedback about the application", description="")
    @PostMapping(value={"/userfeedback"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> sendApplicationUserFeedback(@Parameter(description="Recaptcha validation key.") @RequestParam(required=false, defaultValue="") String recaptcha, @Parameter(description="User name.", required=true) @RequestParam String name, @Parameter(description="User organisation.", required=true) @RequestParam String org, @Parameter(description="User email address.", required=true) @RequestParam String email, @Parameter(description="A comment or question.", required=true) @RequestParam String comments, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        boolean validRecaptcha;
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        boolean feedbackEnabled = this.settingManager.getValueAsBool("system/userFeedback/enable", false);
        if (!feedbackEnabled) {
            throw new FeatureNotEnabledException("Application feedback is not enabled.").withMessageKey("exception.resourceNotEnabled.applicationFeedback").withDescriptionKey("exception.resourceNotEnabled.applicationFeedback.description");
        }
        boolean recaptchaEnabled = this.settingManager.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
        if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(recaptcha, this.settingManager.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
            return new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
        }
        String to = this.settingManager.getValue("system/feedback/email");
        HashSet<String> toAddress = new HashSet<String>();
        toAddress.add(to);
        MailUtil.sendMail(new ArrayList(toAddress), (String)messages.getString("site_user_feedback_title"), (String)String.format(messages.getString("site_user_feedback_text"), name, email, org, comments), (SettingManager)this.settingManager);
        return new ResponseEntity(HttpStatus.CREATED);
    }
}

