/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.cache;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import org.fao.geonet.api.records.formatters.cache.Key;
import org.fao.geonet.api.records.formatters.cache.PersistentStore;
import org.fao.geonet.api.records.formatters.cache.StoreInfoAndDataLoadResult;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.utils.Log;

public class PersistentStoreRunnable
implements Runnable {
    private final BlockingQueue<Pair<Key, StoreInfoAndDataLoadResult>> storeRequests;
    private final PersistentStore store;

    public PersistentStoreRunnable(BlockingQueue<Pair<Key, StoreInfoAndDataLoadResult>> storeRequests, PersistentStore store) {
        this.storeRequests = storeRequests;
        this.store = store;
    }

    @Override
    public final void run() {
        try {
            while (true) {
                Pair<Key, StoreInfoAndDataLoadResult> request = this.storeRequests.take();
                this.processStoreRequest(request);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    void processStoreRequest(Pair<Key, StoreInfoAndDataLoadResult> request) {
        try {
            this.doStore(request);
        }
        catch (SQLException e) {
            StringBuilder exception = new StringBuilder(e.toString());
            exception.append('\n').append(this.strackTrace(e));
            for (Throwable next : e) {
                exception.append("\nNext Exception: '").append(next.getMessage()).append('\n').append(this.strackTrace(next));
            }
            Log.error((String)"geonetwork.formatter", (Object)("Error writing to Formatter PersistenceStore: " + exception));
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.formatter", (String)"Error writing to Formatter PersistenceStore", (Throwable)e);
        }
    }

    private String strackTrace(Throwable e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    @VisibleForTesting
    void doStore(Pair<Key, StoreInfoAndDataLoadResult> request) throws Exception {
        Key key = (Key)request.one();
        StoreInfoAndDataLoadResult result = (StoreInfoAndDataLoadResult)request.two();
        this.store.put(key, result);
        while (result.getKey() != null && result.getToCache() != null) {
            key = result.getKey();
            result = result.getToCache().call();
            this.store.put(key, result);
        }
    }
}

