/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.attachments.StoreUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordCreateEvent;
import org.fao.geonet.events.history.RecordDeletedEvent;
import org.fao.geonet.events.history.RecordImportedEvent;
import org.fao.geonet.events.md.MetadataPreRemove;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.util.UserUtil;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="recordInsertOrDelete")
@PreAuthorize(value="hasAuthority('Editor')")
@ReadWriteController
public class MetadataInsertDeleteApi {
    public static final String LOGGER = "geonetwork.api.metadatainsertdelete";
    public static final String API_PARAM_REPORT_ABOUT_IMPORTED_RECORDS = "Report about imported records.";
    public static final String API_PARAM_RECORD_GROUP = "The group the record is attached to.";
    public static final String API_PARAM_RECORD_UUID_PROCESSING = "Record identifier processing.";
    private static final String API_PARAM_RECORD_TAGS = "Tags to assign to the record.";
    private static final String API_PARAM_RECORD_VALIDATE = "Validate the record first and reject it if not valid.";
    private static final String API_PARAM_RECORD_XSL = "XSL transformation to apply to the record.";
    private static final String API_PARAM_FORCE_SCHEMA = "Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).";
    private static final String API_PARAM_BACKUP_FIRST = "Backup first the record as MEF in the metadata removed folder.";
    private static final String API_PARAM_RECORD_TYPE = "The type of record.";
    @Autowired
    MetadataDraftRepository metadataDraftRepository;
    @Autowired
    EsSearchManager searchManager;
    @Autowired
    private DataManager dataManager;
    @Autowired
    private AccessManager accessMan;
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private GeonetworkDataDirectory dataDirectory;
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private AccessManager accessManager;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataOperations metadataOperations;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    IMetadataValidator metadataValidator;

    @Operation(summary="Delete a record", description="User MUST be able to edit the record to delete it. By default, a backup is made in ZIP format. After that, the record attachments are removed, the document removed from the index and then from the database.")
    @RequestMapping(value={"/{metadataUuid}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Record deleted."), @ApiResponse(responseCode="401", description="This template is referenced"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecord(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Backup first the record as MEF in the metadata removed folder.", required=false) @RequestParam(required=false) Boolean withBackup, HttpServletRequest request) throws Exception {
        boolean doBackup = this.withDeleteBackup(withBackup, request);
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        MetadataPreRemove preRemoveEvent = new MetadataPreRemove(metadata);
        ApplicationContextHolder.get().publishEvent((ApplicationEvent)preRemoveEvent);
        if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE && doBackup) {
            MEFLib.backupRecord((AbstractMetadata)metadata, (ServiceContext)context);
        }
        boolean approved = true;
        if (metadata instanceof MetadataDraft) {
            approved = false;
        }
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        if (this.accessMan.isVisibleToAll(String.valueOf(metadata.getId()))) {
            UserUtil.checkUserProfileLevel((UserSession)userSession, (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/delete/profilePublishedMetadata", (Profile)Profile.Editor, (String)"delete published metadata");
        }
        store.delResources(context, metadata.getUuid(), Boolean.valueOf(approved));
        RecordDeletedEvent recordDeletedEvent = this.triggerDeletionEvent(request, metadata.getId() + "");
        this.metadataManager.deleteMetadata(context, metadata.getId() + "");
        recordDeletedEvent.publish((ApplicationContext)ApplicationContextHolder.get());
        this.dataManager.forceIndexChanges();
    }

    @Operation(summary="Delete one or more records", description="User MUST be able to edit the record to delete it. ")
    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report about deleted records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SimpleMetadataProcessingReport deleteRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Backup first the record as MEF in the metadata removed folder.", required=false) @RequestParam(required=false, defaultValue="true") boolean withBackup, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        for (String uuid : records) {
            Metadata metadata = this.metadataRepository.findOneByUuid(uuid);
            if (metadata == null) {
                report.incrementNullRecords();
                continue;
            }
            if (!this.accessManager.canEdit(context, String.valueOf(metadata.getId())) || this.metadataDraftRepository.findOneByUuid(uuid) != null) {
                report.addNotEditableMetadataId(metadata.getId());
                continue;
            }
            if (this.accessMan.isVisibleToAll(String.valueOf(metadata.getId()))) {
                try {
                    UserUtil.checkUserProfileLevel((UserSession)userSession, (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/delete/profilePublishedMetadata", (Profile)Profile.Editor, (String)"delete published metadata");
                }
                catch (NotAllowedException ex) {
                    report.addMetadataInfos((AbstractMetadata)metadata, ex.getMessage());
                    continue;
                }
            }
            MetadataPreRemove preRemoveEvent = new MetadataPreRemove((AbstractMetadata)metadata);
            ApplicationContextHolder.get().publishEvent((ApplicationEvent)preRemoveEvent);
            if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE && metadata.getDataInfo().getType() != MetadataType.TEMPLATE_OF_SUB_TEMPLATE && withBackup) {
                MEFLib.backupRecord((AbstractMetadata)metadata, (ServiceContext)context);
            }
            store.delResources(context, metadata.getUuid());
            RecordDeletedEvent recordDeletedEvent = this.triggerDeletionEvent(request, String.valueOf(metadata.getId()));
            this.metadataManager.deleteMetadata(context, String.valueOf(metadata.getId()));
            recordDeletedEvent.publish((ApplicationContext)ApplicationContextHolder.get());
            report.incrementProcessedRecords();
            report.addMetadataId(metadata.getId());
        }
        report.close();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Add a record", description="Add one or more record from an XML fragment, URL or file in a folder on the catalog server. When loadingfrom the catalog server folder, it might be faster to use a local filesystem harvester.")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about imported records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insert(@Parameter(description="The type of record.", required=false) @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @Parameter(description="XML fragment.", required=false) @RequestBody(required=false) String xml, @Parameter(description="URL of a file to download and insert.", required=false) @RequestParam(required=false) String[] url, @Parameter(description="Server folder where to look for files.", required=false) @RequestParam(required=false) String serverFolder, @Parameter(description="(Server folder import only) Recursive search in folder.", required=false) @RequestParam(required=false, defaultValue="false") boolean recursiveSearch, @Parameter(description="(XML file only and if workflow is not enabled) Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @Parameter(description="(MEF file only) Assign to current catalog.", required=false) @RequestParam(required=false, defaultValue="false") boolean assignToCatalog, @Parameter(description="Record identifier processing.", required=false) @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @Parameter(description="The group the record is attached to.", required=false) @RequestParam(required=false) String group, @Parameter(description="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @Parameter(description="Validate the record first and reject it if not valid.", required=false) @RequestParam(required=false, defaultValue="false") boolean rejectIfInvalid, @Parameter(description="XSL transformation to apply to the record.", required=false) @RequestParam(required=false, defaultValue="_none_") String transformWith, @Parameter(description="Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).", required=false) @RequestParam(required=false) String schema, @Parameter(description="Is editable by group members with editor profile? If not, only the author and administrator can edit the record.", required=false) @RequestParam(required=false, defaultValue="false") boolean allowEditGroupMembers, @Parameter(description="(experimental) Add extra information to the record.", required=false) @RequestParam(required=false) String extra, HttpServletRequest request) throws Exception {
        Pair<Integer, String> pair;
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        if (url == null && xml == null && serverFolder == null) {
            throw new IllegalArgumentException(messages.getString("api.metadata.import.errorMissingXMLFragmentOrUrl"));
        }
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        UserUtil.checkUserProfileLevel((UserSession)userSession, (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/import/userprofile", (Profile)Profile.Editor, (String)"import metadata");
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (isMdWorkflowEnable) {
            publishToAll = false;
        }
        if (xml != null) {
            Element element = null;
            try {
                element = Xml.loadString((String)xml, (boolean)false);
            }
            catch (JDOMParseException ex) {
                throw new IllegalArgumentException(String.format(messages.getString("api.metadata.import.errorInvalidXMLFragment"), ex.getMessage()));
            }
            Pair<Integer, String> pair2 = this.loadRecord(metadataType, element, uuidProcessing, group, category, rejectIfInvalid, publishToAll, allowEditGroupMembers, transformWith, schema, extra, request);
            report.addMetadataInfos((Integer)pair2.one(), (String)pair2.two(), !publishToAll, false, String.format(messages.getString("api.metadata.import.importedFromXMLWithUuid"), pair2.two()));
            this.triggerImportEvent(request, (String)pair2.two());
            report.incrementProcessedRecords();
        }
        if (url != null) {
            for (Element u : url) {
                Element xmlContent = null;
                Object tempFile = null;
                try {
                    tempFile = ApiUtils.downloadUrlInTemp((String)u);
                    xmlContent = Xml.loadFile((Path)tempFile);
                }
                catch (Exception e) {
                    Log.error((String)LOGGER, (String)String.format("Error importing metadata from '%s'.", (Object[])url), (Throwable)e);
                    report.addError(new Exception(String.format(messages.getString("api.metadata.import.errorFromUrl"), (Object[])url)));
                }
                finally {
                    if (tempFile != null) {
                        FileUtils.deleteQuietly((File)tempFile.toFile());
                    }
                }
                if (xmlContent != null) {
                    pair = this.loadRecord(metadataType, xmlContent, uuidProcessing, group, category, rejectIfInvalid, publishToAll, allowEditGroupMembers, transformWith, schema, extra, request);
                    report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format(messages.getString("api.metadata.import.importedFromUrl"), pair.two()));
                    this.triggerImportEvent(request, (String)pair.two());
                }
                report.incrementProcessedRecords();
            }
        }
        if (serverFolder != null) {
            Path serverFolderPath = IO.toPath((String)serverFolder, (String[])new String[0]);
            final ArrayList files = Lists.newArrayList();
            final MEFLib.MefOrXmlFileFilter predicate = new MEFLib.MefOrXmlFileFilter();
            if (recursiveSearch) {
                Files.walkFileTree(serverFolderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (predicate.accept(file)) {
                            files.add(file);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                DirectoryStream<Path> paths = Files.newDirectoryStream(serverFolderPath, (DirectoryStream.Filter<? super Path>)predicate);
                Object object = null;
                try {
                    for (Path file : paths) {
                        files.add(file);
                    }
                }
                catch (Throwable tempFile) {
                    object = tempFile;
                    throw tempFile;
                }
                finally {
                    if (paths != null) {
                        if (object != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable tempFile) {
                                ((Throwable)object).addSuppressed(tempFile);
                            }
                        } else {
                            paths.close();
                        }
                    }
                }
            }
            if (files.size() == 0) {
                throw new Exception(String.format(messages.getString("api.metadata.import.errorMissingMEF"), serverFolder));
            }
            ServiceContext context = ApiUtils.createServiceContext(request);
            for (Path f : files) {
                if (MEFLib.isValidArchiveExtensionForMEF((String)f.getFileName().toString())) {
                    try {
                        MEFLib.Version version = MEFLib.getMEFVersion((Path)f);
                        List ids = MEFLib.doImport((String)(version == MEFLib.Version.V1 ? "mef" : "mef2"), (MEFLib.UuidAction)uuidProcessing, (String)transformWith, (String)this.settingManager.getSiteId(), (MetadataType)metadataType, (String[])category, (String)group, (boolean)rejectIfInvalid, (boolean)assignToCatalog, (ServiceContext)context, (Path)f);
                        for (String id : ids) {
                            report.addMetadataInfos(Integer.parseInt(id), id, !publishToAll, false, String.format(messages.getString("api.metadata.import.importedFromMEF"), id));
                            this.triggerCreationEvent(request, id);
                            report.incrementProcessedRecords();
                        }
                        continue;
                    }
                    catch (Exception e) {
                        report.addError(e);
                        report.addInfos(String.format(messages.getString("api.metadata.import.errorImportMEF"), f.getFileName().toString()));
                        continue;
                    }
                }
                try {
                    pair = this.loadRecord(metadataType, Xml.loadFile((Path)f), uuidProcessing, group, category, rejectIfInvalid, publishToAll, allowEditGroupMembers, transformWith, schema, extra, request);
                    report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format(messages.getString("api.metadata.import.importedFromServerFolder"), pair.two()));
                    this.triggerCreationEvent(request, (String)pair.two());
                }
                catch (Exception e) {
                    report.addError(e);
                }
                report.incrementProcessedRecords();
            }
        }
        report.close();
        return report;
    }

    @Operation(summary="Create a new record", description="Create a record from a template or by copying an existing record.Return the UUID of the newly created record. Existing links in the source record are preserved, this means that the new record may contains link to the source attachments. They need to be manually updated after creation.")
    @RequestMapping(value={"/duplicate"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Return the internal id of the newly created record."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public String create(@Parameter(description="The type of record.", required=false) @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @Parameter(description="UUID of the source record to copy.", required=true) @RequestParam(required=true) String sourceUuid, @Parameter(description="Assign a custom UUID. If this UUID already exist an error is returned. This is enabled only if metadata create / generate UUID settings is activated.", required=false) @RequestParam(required=false) String targetUuid, @Parameter(description="The group the record is attached to.", required=true) @RequestParam(required=true) String group, @Parameter(description="Is editable by group members with editor profile? If not, only the author and administrator can edit the record.", required=false) @RequestParam(required=false, defaultValue="false") boolean allowEditGroupMembers, @Parameter(description="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @Parameter(description="Copy categories from source?", required=false) @RequestParam(required=false, defaultValue="false") boolean hasCategoryOfSource, @Parameter(description="Is child of the record to copy?", required=false) @RequestParam(required=false, defaultValue="false") boolean isChildOfSource, @Parameter(description="Copy attachments from source?", required=false) @RequestParam(required=false, defaultValue="true") boolean hasAttachmentsOfSource, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        Specification spec;
        List userGroups;
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        AbstractMetadata sourceMetadata = ApiUtils.getRecord(sourceUuid);
        boolean generateUuid = this.settingManager.getValueAsBool("system/metadatacreate/generateUuid");
        String metadataUuid = null;
        if (!generateUuid && !StringUtils.isEmpty((String)targetUuid)) {
            try {
                ApiUtils.getRecord(targetUuid);
                throw new BadParameterEx(String.format(messages.getString("api.metadata.import.errorDuplicatedUUID"), targetUuid), (Object)targetUuid);
            }
            catch (ResourceNotFoundException e) {
                metadataUuid = targetUuid;
            }
        } else {
            metadataUuid = UUID.randomUUID().toString();
        }
        UserSession user = ApiUtils.getUserSession(httpSession);
        if (user.getProfile() != Profile.Administrator && (userGroups = this.userGroupRepository.findAll(spec = Specification.where((Specification)UserGroupSpecs.hasProfile((Profile)Profile.Editor)).and(UserGroupSpecs.hasUserId((int)user.getUserIdAsInt())).and(UserGroupSpecs.hasGroupId((Integer)Integer.valueOf(group))))).isEmpty()) {
            throw new SecurityException(messages.getString("api.metadata.import.errorNotEditorInGroup"));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        String newId = this.dataManager.createMetadata(context, String.valueOf(sourceMetadata.getId()), group, this.settingManager.getSiteId(), context.getUserSession().getUserIdAsInt(), isChildOfSource ? sourceMetadata.getUuid() : null, metadataType.toString(), allowEditGroupMembers, metadataUuid);
        this.triggerCreationEvent(request, newId);
        this.dataManager.activateWorkflowIfConfigured(context, newId, group);
        if (hasAttachmentsOfSource) {
            try {
                StoreUtils.copyDataDir((ServiceContext)context, (int)sourceMetadata.getId(), (int)Integer.parseInt(newId), (boolean)true);
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while copying metadata resources. Error is %s. Metadata is created but without resources from the source record with id '%s':", e.getMessage(), newId));
            }
        }
        if (hasCategoryOfSource) {
            Collection categories = this.dataManager.getCategories(sourceMetadata.getId() + "");
            try {
                Iterator iterator = categories.iterator();
                while (iterator.hasNext()) {
                    MetadataCategory c = (MetadataCategory)iterator.next();
                    this.dataManager.setCategory(context, newId, c.getId() + "");
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while copying source record category to new record. Error is %s. Metadata is created but without the categories from the source record with id '%d':", e.getMessage(), newId));
            }
        }
        if (category != null && category.length > 0) {
            try {
                for (String c : category) {
                    this.dataManager.setCategory(context, newId, c);
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while setting record category to new record. Error is %s. Metadata is created but without the requested categories.", e.getMessage(), newId));
            }
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Add a record from XML or MEF/ZIP file", description="Add record in the catalog by uploading files.")
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about imported records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insertFile(@Parameter(description="The type of record.", required=false) @RequestParam(required=false, defaultValue="METADATA") MetadataType metadataType, @Parameter(description="XML or MEF file to upload", required=false) @RequestParam(value="file", required=false) MultipartFile[] file, @Parameter(description="Record identifier processing.", required=false) @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @Parameter(description="The group the record is attached to.", required=false) @RequestParam(required=false) String group, @Parameter(description="Tags to assign to the record.", required=false) @RequestParam(required=false) String[] category, @Parameter(description="Validate the record first and reject it if not valid.", required=false) @RequestParam(required=false, defaultValue="false") boolean rejectIfInvalid, @Parameter(description="(XML file only) Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @Parameter(description="(MEF file only) Assign to current catalog.", required=false) @RequestParam(required=false, defaultValue="false") boolean assignToCatalog, @Parameter(description="XSL transformation to apply to the record.", required=false) @RequestParam(required=false, defaultValue="_none_") String transformWith, @Parameter(description="Force the schema of the record. If not set, schema autodetection is used (and is the preferred method).", required=false) @RequestParam(required=false) String schema, @Parameter(description="(experimental) Add extra information to the record.", required=false) @RequestParam(required=false) String extra, @Parameter(description="Is editable by group members with editor profile? If not, only the author and administrator can edit the record.", required=false) @RequestParam(required=false, defaultValue="false") boolean allowEditGroupMembers, HttpServletRequest request) throws Exception {
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        if (file == null) {
            throw new IllegalArgumentException(messages.getString("api.metadata.import.errorFileRequired"));
        }
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (isMdWorkflowEnable) {
            publishToAll = false;
        }
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        if (file != null) {
            ServiceContext context = ApiUtils.createServiceContext(request);
            UserUtil.checkUserProfileLevel((UserSession)context.getUserSession(), (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/import/userprofile", (Profile)Profile.Editor, (String)"import metadata");
            for (MultipartFile f : file) {
                if (MEFLib.isValidArchiveExtensionForMEF((String)f.getOriginalFilename())) {
                    Path tempFile = Files.createTempFile("mef-import", ".zip", new FileAttribute[0]);
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)f.getInputStream(), (File)tempFile.toFile());
                        MEFLib.Version version = MEFLib.getMEFVersion((Path)tempFile);
                        List ids = MEFLib.doImport((String)(version == MEFLib.Version.V1 ? "mef" : "mef2"), (MEFLib.UuidAction)uuidProcessing, (String)transformWith, (String)this.settingManager.getSiteId(), (MetadataType)metadataType, (String[])category, (String)group, (boolean)rejectIfInvalid, (boolean)assignToCatalog, (ServiceContext)context, (Path)tempFile);
                        if (ids.isEmpty()) {
                            throw new BadFormatEx(messages.getString("api.metadata.import.errorInvalidMEF"));
                        }
                        boolean finalPublishToAll = publishToAll;
                        ids.forEach(e -> {
                            report.addMetadataInfos(Integer.parseInt(e), (String)e, !finalPublishToAll, false, String.format(messages.getString("api.metadata.import.importedWithId"), e));
                            try {
                                this.triggerCreationEvent(request, (String)e);
                            }
                            catch (Exception e1) {
                                report.addError(e1);
                                report.addInfos(String.format(messages.getString("api.metadata.import.errorEventStore"), f.getOriginalFilename()));
                            }
                            report.incrementProcessedRecords();
                        });
                        continue;
                    }
                    catch (Exception e2) {
                        report.addError(e2);
                        report.addInfos(String.format(messages.getString("api.metadata.import.errorImportMEF"), f.getOriginalFilename()));
                        continue;
                    }
                    finally {
                        IO.deleteFile((Path)tempFile, (boolean)false, (String)"geonetwork.mef");
                    }
                }
                Pair<Integer, String> pair = this.loadRecord(metadataType, Xml.loadStream((InputStream)f.getInputStream()), uuidProcessing, group, category, rejectIfInvalid, publishToAll, allowEditGroupMembers, transformWith, schema, extra, request);
                report.addMetadataInfos((Integer)pair.one(), (String)pair.two(), !publishToAll, false, String.format(messages.getString("api.metadata.import.importedWithUuid"), pair.two()));
                this.triggerImportEvent(request, (String)pair.two());
                report.incrementProcessedRecords();
            }
        }
        report.close();
        return report;
    }

    @Operation(summary="Add a map metadata record from OGC OWS context", description="Add record in the catalog by uploading a map context.")
    @RequestMapping(value={"/importfrommap"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about imported records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public SimpleMetadataProcessingReport insertOgcMapContextFile(@Parameter(description="A map title", required=true) @RequestParam(value="title", required=true) String title, @Parameter(description="A map abstract", required=false) @RequestParam(value="recordAbstract", required=false) String recordAbstract, @Parameter(description="OGC OWS context as string", required=false) @RequestParam(value="xml", required=false) String xml, @Parameter(description="OGC OWS context file name", required=false) @RequestParam(value="filename", required=false) String filename, @Parameter(description="OGC OWS context URL", required=false) @RequestParam(value="url", required=false) String url, @Parameter(description="A map viewer URL to visualize the map", required=false) @RequestParam(value="viewerUrl", required=false) String viewerUrl, @Parameter(description="Map overview as PNG (base64 encoded)", required=false) @RequestParam(value="overview", required=false) String overview, @Parameter(description="Map overview filename", required=false) @RequestParam(value="overviewFilename", required=false) String overviewFilename, @Parameter(description="Topic category", required=false) @RequestParam(value="topic", required=false) String topic, @Parameter(description="Publish record.", required=false) @RequestParam(required=false, defaultValue="false") boolean publishToAll, @Parameter(description="Record identifier processing.", required=false) @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @Parameter(description="The group the record is attached to.", required=false) @RequestParam(required=false) String group, HttpServletRequest request) throws Exception {
        HashMap<String, String> onlineSrcParams;
        if (StringUtils.isEmpty((String)xml) && StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("A context as XML or a remote URL MUST be provided.");
        }
        if (StringUtils.isEmpty((String)xml) && StringUtils.isEmpty((String)filename)) {
            throw new IllegalArgumentException(String.format("A context as XML will be saved as a record attachment. You MUST provide a filename in this case.", new Object[0]));
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        Path styleSheetWmc = this.dataDirectory.getXsltConversion("schema:iso19139:convert/fromOGCWMC-OR-OWSC");
        FilePathChecker.verify((String)filename);
        HashMap<String, String> xslParams = new HashMap<String, String>();
        xslParams.put("viewer_url", viewerUrl);
        xslParams.put("map_url", url);
        xslParams.put("topic", topic);
        xslParams.put("title", title);
        xslParams.put("abstract", recordAbstract);
        xslParams.put("lang", context.getLanguage());
        UserSession us = context.getUserSession();
        if (us != null) {
            xslParams.put("currentuser_name", us.getName() + " " + us.getSurname());
            xslParams.put("currentuser_mail", us.getEmailAddr());
            xslParams.put("currentuser_org", us.getOrganisation());
        }
        Element wmcDoc = Xml.loadString((String)xml, (boolean)false);
        Element transformedMd = Xml.transform((Element)wmcDoc, (Path)styleSheetWmc, xslParams);
        String uuid = UUID.randomUUID().toString();
        String date = new ISODate().toString();
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        ArrayList id = new ArrayList();
        ArrayList<Element> md = new ArrayList<Element>();
        md.add(transformedMd);
        Importer.importRecord((String)uuid, (MEFLib.UuidAction)uuidProcessing, md, (String)"iso19139", (int)0, (String)this.settingManager.getSiteId(), (String)this.settingManager.getSiteName(), null, (ServiceContext)context, id, (String)date, (String)date, (String)group, (MetadataType)MetadataType.METADATA);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        String metadataUuid = this.metadataUtils.getMetadataUuid((String)id.get(0));
        if (StringUtils.isEmpty((String)url)) {
            store.putResource(context, metadataUuid, filename, IOUtils.toInputStream((String)Xml.getString((Element)wmcDoc)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap<String, String>();
            onlineSrcParams.put("protocol", "OGC:OWS-C");
            onlineSrcParams.put("url", this.settingManager.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, filename));
            onlineSrcParams.put("name", filename);
            onlineSrcParams.put("desc", title);
            transformedMd = Xml.transform((Element)transformedMd, (Path)this.schemaManager.getSchemaDir("iso19139").resolve("process").resolve("onlinesrc-add.xsl"), onlineSrcParams);
            this.dataManager.updateMetadata(context, (String)id.get(0), transformedMd, false, true, context.getLanguage(), null, true, IndexingMode.none);
        }
        if (StringUtils.isNotEmpty((String)overview) && StringUtils.isNotEmpty((String)overviewFilename)) {
            store.putResource(context, metadataUuid, overviewFilename, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)overview)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap();
            onlineSrcParams.put("thumbnail_url", this.settingManager.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, overviewFilename));
            transformedMd = Xml.transform((Element)transformedMd, (Path)this.schemaManager.getSchemaDir("iso19139").resolve("process").resolve("thumbnail-add.xsl"), onlineSrcParams);
            this.dataManager.updateMetadata(context, (String)id.get(0), transformedMd, false, true, context.getLanguage(), null, true, IndexingMode.none);
        }
        int iId = Integer.parseInt((String)id.get(0));
        if (publishToAll) {
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.view.getId());
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.download.getId());
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.dynamic.getId());
        }
        if (StringUtils.isNotEmpty((String)group)) {
            int gId = Integer.parseInt(group);
            this.metadataOperations.setOperation(context, iId, gId, ReservedOperation.view.getId());
            this.metadataOperations.setOperation(context, iId, gId, ReservedOperation.download.getId());
            this.metadataOperations.setOperation(context, iId, gId, ReservedOperation.dynamic.getId());
        }
        this.dataManager.indexMetadata(id);
        report.addMetadataInfos(Integer.parseInt((String)id.get(0)), uuid, !publishToAll, false, uuid);
        this.triggerCreationEvent(request, uuid);
        report.incrementProcessedRecords();
        report.close();
        return report;
    }

    private void triggerCreationEvent(HttpServletRequest request, String uuid) throws Exception, JsonProcessingException {
        AbstractMetadata metadata = ApiUtils.getRecord(uuid);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCreateEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)userSession.getPrincipal(), (String)"userObject"), metadata.getData()).publish((ApplicationContext)applicationContext);
    }

    private RecordDeletedEvent triggerDeletionEvent(HttpServletRequest request, String uuid) throws Exception {
        AbstractMetadata metadata = ApiUtils.getRecord(uuid);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
        Element beforeMetadata = dataMan.getMetadata(serviceContext, String.valueOf(metadata.getId()), false, false, false);
        XMLOutputter outp = new XMLOutputter();
        String xmlBefore = outp.outputString(beforeMetadata);
        LinkedHashMap titles = new LinkedHashMap();
        try {
            titles = this.metadataUtils.extractTitles(Integer.toString(metadata.getId()));
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.datamanager", (Object)String.format("Error while extracting title for the metadata %d while creating delete event. Error is %s. It may happen on subtemplates.", metadata.getId(), e.getMessage()));
        }
        return new RecordDeletedEvent(Integer.valueOf(metadata.getId()), metadata.getUuid(), titles, Integer.valueOf(userSession.getUserIdAsInt()), xmlBefore);
    }

    private void triggerImportEvent(HttpServletRequest request, String uuid) throws Exception, JsonProcessingException {
        AbstractMetadata metadata = ApiUtils.getRecord(uuid);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordImportedEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)userSession.getPrincipal(), (String)"user"), metadata.getData()).publish((ApplicationContext)applicationContext);
    }

    private Pair<Integer, String> loadRecord(MetadataType metadataType, Element xmlElement, MEFLib.UuidAction uuidProcessing, String group, String[] category, boolean rejectIfInvalid, boolean publishToAll, boolean allowEditGroupMembers, String transformWith, String schema, String extra, HttpServletRequest request) throws Exception {
        AbstractMetadata md;
        String uuid;
        ServiceContext context = ApiUtils.createServiceContext(request);
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        if (!transformWith.equals("_none_")) {
            FilePathChecker.verify((String)transformWith);
            Path xslFile = this.dataDirectory.getXsltConversion(transformWith);
            if (Files.exists(xslFile, new LinkOption[0])) {
                xmlElement = Xml.transform((Element)xmlElement, (Path)xslFile);
            } else {
                throw new ResourceNotFoundException(String.format(messages.getString("api.metadata.import.errorMissingXsl"), transformWith));
            }
        }
        if (schema == null && (schema = this.dataManager.autodetectSchema(xmlElement)) == null) {
            throw new IllegalArgumentException(messages.getString("api.metadata.import.errorDetectMetadataSchema"));
        }
        if (rejectIfInvalid) {
            try {
                Integer groupId = null;
                if (StringUtils.isNotEmpty((String)group)) {
                    groupId = Integer.parseInt(group);
                }
                DataManager.validateExternalMetadata((String)schema, (Element)xmlElement, (ServiceContext)context, (Integer)groupId);
            }
            catch (XSDValidationErrorEx e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (metadataType == MetadataType.SUB_TEMPLATE || metadataType == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
            uuid = xmlElement.getAttributeValue("uuid");
            if (StringUtils.isEmpty((String)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
        } else {
            uuid = this.dataManager.extractUUID(schema, xmlElement);
            if (uuid.length() == 0) {
                uuid = UUID.randomUUID().toString();
                xmlElement = this.dataManager.setUUID(schema, uuid, xmlElement);
            }
        }
        if (uuidProcessing == MEFLib.UuidAction.NOTHING && (md = this.metadataUtils.findOneByUuid(uuid)) != null) {
            throw new IllegalArgumentException(String.format(messages.getString("api.metadata.import.errorDuplicatedUUIDDetailed"), uuid));
        }
        String date = new ISODate().toString();
        ArrayList id = new ArrayList();
        ArrayList<Element> md2 = new ArrayList<Element>();
        md2.add(xmlElement);
        HashMap sourceTranslations = Maps.newHashMap();
        try {
            Importer.importRecord((String)uuid, (MEFLib.UuidAction)uuidProcessing, md2, (String)schema, (int)0, (String)this.settingManager.getSiteId(), (String)this.settingManager.getSiteName(), (Map)sourceTranslations, (ServiceContext)context, id, (String)date, (String)date, (String)group, (MetadataType)metadataType);
        }
        catch (DataIntegrityViolationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        int iId = Integer.parseInt((String)id.get(0));
        uuid = this.dataManager.getMetadataUuid(iId + "");
        this.dataManager.setTemplate(iId, metadataType, null);
        if (allowEditGroupMembers) {
            this.metadataOperations.copyDefaultPrivForGroup(context, String.valueOf(iId), group, allowEditGroupMembers);
        }
        if (publishToAll) {
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.view.getId());
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.download.getId());
            this.metadataOperations.setOperation(context, iId, ReservedGroup.all.getId(), ReservedOperation.dynamic.getId());
        }
        this.dataManager.activateWorkflowIfConfigured(context, (String)id.get(0), group);
        if (category != null) {
            for (String c : category) {
                this.dataManager.setCategory(context, (String)id.get(0), c);
            }
        }
        if (extra != null) {
            this.metadataRepository.update((Serializable)Integer.valueOf(iId), metadata -> {
                if (extra != null) {
                    metadata.getDataInfo().setExtra(extra);
                }
            });
        }
        if (rejectIfInvalid) {
            AbstractMetadata metadata2 = this.metadataUtils.findOne(iId);
            this.metadataValidator.doValidate(metadata2, context.getLanguage());
        }
        this.dataManager.indexMetadata((String)id.get(0), true);
        return Pair.read((Object)Integer.valueOf((String)id.get(0)), (Object)uuid);
    }

    private boolean withDeleteBackup(Boolean withBackup, HttpServletRequest request) {
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        String mdDeleteBackupOption = this.settingManager.getValue("metadata/delete/backupOptions");
        if (withBackup == null) {
            return !StringUtils.equals((String)mdDeleteBackupOption, (String)"ForceNoBackup");
        }
        if (withBackup.booleanValue()) {
            if (StringUtils.equals((String)mdDeleteBackupOption, (String)"ForceNoBackup")) {
                throw new IllegalArgumentException(String.format(messages.getString("api.metadata.delete.errorForceBackup"), withBackup));
            }
            return true;
        }
        withBackup = false;
        if (withBackup.booleanValue()) {
            if (StringUtils.equals((String)mdDeleteBackupOption, (String)"ForceBackup")) {
                throw new IllegalArgumentException(String.format(messages.getString("api.metadata.delete.errorForceNoBackup"), withBackup));
            }
            return false;
        }
        return true;
    }
}

