/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.soap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.SessionKilled;
import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.QuerySailStack;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.soap.SoapQueryResultListener;

public class SoapServices {
    private static final String VERSION_SAIL = "org.openrdf.sesame.omm.VersionManagement";
    static int lastSessionID = 0;
    private VersionManagement verSail = null;
    private LocalRepository _repository;
    int theID = SoapServices.createSession();
    SessionKilled sk = null;

    static int createSession() {
        return ++lastSessionID;
    }

    private SessionContext getContext() {
        String thisSessionID = "SOAP[" + this.theID + "]";
        SessionContext sc = SessionContext.get(thisSessionID);
        if (sc == null) {
            sc = new SessionContext();
            SessionContext.put(thisSessionID, sc);
            System.out.println("new context created (" + thisSessionID + ")");
            UserInfo ui = SesameServer.getSystemConfig().getUserInfo(2);
            if (ui != null) {
                sc.userID = ui.getID();
                sc.user = ui.getLogin();
                sc.pass = ui.getPassword();
            }
            this.sk = new SessionKilled(thisSessionID);
        }
        SessionContext.setContext(sc);
        return sc;
    }

    private VersionManagement getVersionManagement() {
        VersionManagement verSail = null;
        try {
            SessionContext sc = this.getContext();
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            verSail = (VersionManagement)QuerySailStack.queryInterface(sail, VERSION_SAIL);
        }
        catch (Exception xx) {
            throw new RuntimeException(xx.getMessage());
        }
        return verSail;
    }

    public int uploadData(String data, String baseURL) {
        SessionContext sc = this.getContext();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlAdminMsgWriter report = new XmlAdminMsgWriter(os);
            this._repository.addData(data, baseURL, RDFFormat.RDFXML, true, (AdminListener)report);
        }
        catch (AccessDeniedException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return 0;
    }

    public int addDataFromUrl(String dataUrl, String baseURL) {
        URL url = null;
        try {
            url = new URL(dataUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
        SessionContext sc = this.getContext();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlAdminMsgWriter report = new XmlAdminMsgWriter(os);
            this._repository.addData(url, baseURL, RDFFormat.RDFXML, true, (AdminListener)report);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return 0;
    }

    public boolean clearRepository() {
        SessionContext sc = this.getContext();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlAdminMsgWriter report = new XmlAdminMsgWriter(os);
            this._repository.clear(report);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return true;
    }

    public int removeStatements(String subjURI, String predURI, String objURI, boolean bObjectIsLiteral) {
        SessionContext sc = this.getContext();
        if (subjURI != null && subjURI.trim().equals("")) {
            subjURI = null;
        }
        if (predURI != null && predURI.trim().equals("")) {
            predURI = null;
        }
        if (objURI != null && objURI.trim().equals("")) {
            objURI = null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmlAdminMsgWriter report = new XmlAdminMsgWriter(os);
            URIImpl subj = null;
            try {
                subj = new URIImpl(subjURI);
            }
            catch (IllegalArgumentException e) {
                subj = new BNodeImpl(subjURI);
            }
            URIImpl pred = new URIImpl(predURI);
            LiteralImpl obj = null;
            if (bObjectIsLiteral) {
                obj = new LiteralImpl(objURI);
            } else {
                try {
                    obj = new URIImpl(objURI);
                }
                catch (IllegalArgumentException e) {
                    obj = new BNodeImpl(objURI);
                }
            }
            this._repository.removeStatements((Resource)subj, (URI)pred, (Value)obj, report);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return 0;
    }

    public Vector evalRqlQuery(String query) throws Exception {
        SessionContext sc = this.getContext();
        SoapQueryResultListener qrl = new SoapQueryResultListener();
        this._repository.performTableQuery(QueryLanguage.RQL, query, qrl);
        return qrl.result();
    }

    public Vector evalRdqlQuery(String query) throws Exception {
        SessionContext sc = this.getContext();
        SoapQueryResultListener qrl = new SoapQueryResultListener();
        this._repository.performTableQuery(QueryLanguage.RDQL, query, qrl);
        return qrl.result();
    }

    public String extractRDF(boolean ontology, boolean instances, boolean explicit) {
        SessionContext sc = this.getContext();
        StringWriter out = new StringWriter();
        RdfXmlWriter documentWriter = new RdfXmlWriter((Writer)out);
        try {
            this._repository.extractRDF((RdfDocumentWriter)documentWriter, ontology, instances, explicit, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public String[] listRepositories() {
        SessionContext sc = this.getContext();
        return new String[0];
    }

    public boolean selectRepository(String repos) {
        SessionContext sc = this.getContext();
        try {
            this._repository = (LocalRepository)SesameServer.getLocalService().getRepository(repos);
        }
        catch (UnknownRepositoryException ex) {
            throw new RuntimeException("UnknownRepositoryException" + ex.getMessage());
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException("ConfigurationException", ex);
        }
        return true;
    }

    public String getRepositoryTitle(String repositoryId) {
        RepositoryConfig config = SesameServer.getSystemConfig().getRepositoryConfig(repositoryId);
        if (config == null) {
            return "";
        }
        return config.getTitle();
    }

    public boolean login(String userID, String pass) {
        SessionContext sc = this.getContext();
        try {
            SesameServer.getLocalService().login(userID, pass);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public Vector getStatements(String subj, String pred, String obj, boolean objIsLiteral) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl subjR = null;
                if (subj != null) {
                    subjR = new URIImpl(subj);
                }
                URIImpl predR = null;
                if (pred != null) {
                    predR = new URIImpl(pred);
                }
                Object objV = null;
                if (obj != null) {
                    objV = objIsLiteral ? new LiteralImpl(obj) : new URIImpl(obj);
                }
                StatementIterator iter = rdfSchema.getStatements((Resource)subjR, (URI)predR, (Value)objV);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getExplicitStatements(String subj, String pred, String obj, boolean objIsLiteral) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl subjR = null;
                if (subj != null) {
                    subjR = new URIImpl(subj);
                }
                URIImpl predR = null;
                if (pred != null) {
                    predR = new URIImpl(pred);
                }
                Object objV = null;
                if (obj != null) {
                    objV = objIsLiteral ? new LiteralImpl(obj) : new URIImpl(obj);
                }
                StatementIterator iter = rdfSchema.getExplicitStatements((Resource)subjR, (URI)predR, (Value)objV);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    protected Vector _statementIteratorToVector(StatementIterator iter) {
        Vector<String[]> result = new Vector<String[]>();
        while (iter.hasNext()) {
            Statement st = iter.next();
            String[] theStatementAsStringArray = new String[]{this._valueToString((Value)st.getSubject()), this._valueToString((Value)st.getPredicate()), this._valueToString(st.getObject())};
            result.add(theStatementAsStringArray);
        }
        return result;
    }

    protected String _valueToString(Value value) {
        if (value instanceof Literal) {
            return ((Literal)value).toString();
        }
        if (value instanceof URI) {
            return ((URI)value).getURI();
        }
        if (value instanceof BNode) {
            return ((BNode)value).getID();
        }
        throw new IllegalArgumentException("value should be a Literal, URI or BNode");
    }

    public boolean hasStatement(String subj, String pred, String obj, boolean objIsLiteral) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl subjR = null;
                if (subj != null) {
                    subjR = new URIImpl(subj);
                }
                URIImpl predR = null;
                if (pred != null) {
                    predR = new URIImpl(pred);
                }
                Object objV = null;
                if (obj != null) {
                    objV = objIsLiteral ? new LiteralImpl(obj) : new URIImpl(obj);
                }
                result = rdfSchema.hasStatement((Resource)subjR, (URI)predR, (Value)objV);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean hasExplicitStatement(String subj, String pred, String obj, boolean objIsLiteral) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl subjR = null;
                if (subj != null) {
                    subjR = new URIImpl(subj);
                }
                URIImpl predR = null;
                if (pred != null) {
                    predR = new URIImpl(pred);
                }
                Object objV = null;
                if (obj != null) {
                    objV = objIsLiteral ? new LiteralImpl(obj) : new URIImpl(obj);
                }
                result = rdfSchema.hasExplicitStatement((Resource)subjR, (URI)predR, (Value)objV);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getClasses() {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                StatementIterator iter = rdfSchema.getClasses();
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isClass(String resource) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isClass((Resource)new URIImpl(resource));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getProperties() {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                StatementIterator iter = rdfSchema.getProperties();
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isProperty(String resource) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isProperty((Resource)new URIImpl(resource));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getSubClassOf(String subClass, String superClass) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rSubClass = null;
                URIImpl rSuperClass = null;
                if (subClass != null) {
                    rSubClass = new URIImpl(subClass);
                }
                if (superClass != null) {
                    rSuperClass = new URIImpl(superClass);
                }
                StatementIterator iter = rdfSchema.getSubClassOf((Resource)rSubClass, (Resource)rSuperClass);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getDirectSubClassOf(String subClass, String superClass) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rSubClass = null;
                URIImpl rSuperClass = null;
                if (subClass != null) {
                    rSubClass = new URIImpl(subClass);
                }
                if (superClass != null) {
                    rSuperClass = new URIImpl(superClass);
                }
                StatementIterator iter = rdfSchema.getDirectSubClassOf((Resource)rSubClass, (Resource)rSuperClass);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isSubClassOf(String subClass, String superClass) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isSubClassOf((Resource)new URIImpl(subClass), (Resource)new URIImpl(superClass));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isDirectSubClassOf(String subClass, String superClass) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isDirectSubClassOf((Resource)new URIImpl(subClass), (Resource)new URIImpl(superClass));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getSubPropertyOf(String subProperty, String superProperty) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rSubProperty = null;
                URIImpl rSuperProperty = null;
                if (subProperty != null) {
                    rSubProperty = new URIImpl(subProperty);
                }
                if (superProperty != null) {
                    rSuperProperty = new URIImpl(superProperty);
                }
                StatementIterator iter = rdfSchema.getSubPropertyOf((Resource)rSubProperty, (Resource)rSuperProperty);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getDirectSubPropertyOf(String subProperty, String superProperty) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rSubProperty = null;
                URIImpl rSuperProperty = null;
                if (subProperty != null) {
                    rSubProperty = new URIImpl(subProperty);
                }
                if (superProperty != null) {
                    rSuperProperty = new URIImpl(superProperty);
                }
                StatementIterator iter = rdfSchema.getDirectSubPropertyOf((Resource)rSubProperty, (Resource)rSuperProperty);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isSubPropertyOf(String subProperty, String superProperty) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isSubPropertyOf((Resource)new URIImpl(subProperty), (Resource)new URIImpl(superProperty));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isDirectSubPropertyOf(String subProperty, String superProperty) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isDirectSubPropertyOf((Resource)new URIImpl(subProperty), (Resource)new URIImpl(superProperty));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getType(String anInstance, String aClass) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rInst = null;
                URIImpl rClass = null;
                if (anInstance != null) {
                    rInst = new URIImpl(anInstance);
                }
                if (aClass != null) {
                    rClass = new URIImpl(aClass);
                }
                StatementIterator iter = rdfSchema.getType((Resource)rInst, (Resource)rClass);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getDirectType(String anInstance, String aClass) {
        Vector result = null;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                URIImpl rInst = null;
                URIImpl rClass = null;
                if (anInstance != null) {
                    rInst = new URIImpl(anInstance);
                }
                if (aClass != null) {
                    rClass = new URIImpl(aClass);
                }
                StatementIterator iter = rdfSchema.getDirectType((Resource)rInst, (Resource)rClass);
                result = this._statementIteratorToVector(iter);
                iter.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isType(String anInstance, String aClass) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isType((Resource)new URIImpl(anInstance), (Resource)new URIImpl(aClass));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public boolean isDirectType(String anInstance, String aClass) {
        boolean result = false;
        SessionContext sc = this.getContext();
        try {
            LocalService service = SesameServer.getLocalService();
            service.login(sc.user, sc.pass);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Sail sail = rep.getSail();
            if (sail instanceof RdfSchemaSource) {
                RdfSchemaSource rdfSchema = (RdfSchemaSource)sail;
                result = rdfSchema.isDirectType((Resource)new URIImpl(anInstance), (Resource)new URIImpl(aClass));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public void labelState(String stateUID, String label) {
        try {
            this.verSail = this.getVersionManagement();
            if (this.verSail != null) {
                this.verSail.labelState(Long.parseLong(stateUID), label);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void labelCurrentState(String label) {
        try {
            this.verSail = this.getVersionManagement();
            if (this.verSail != null) {
                this.verSail.labelCurrentState(label);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void revertToState(String stateUID) {
        SessionContext sc = this.getContext();
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                this.verSail.revertToState(Long.parseLong(stateUID));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void workWithState(String stateUID) {
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                this.verSail.workWithState(Long.parseLong(stateUID));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public String branchState(String stateUID) {
        String result = "";
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                result = this.verSail.branchState(Long.parseLong(stateUID));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getVersions() {
        Vector<String> result = null;
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                Iterator iResult = this.verSail.getVersions();
                result = new Vector<String>();
                while (iResult.hasNext()) {
                    result.add(iResult.next().toString());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getUpdateIds() {
        this.verSail = this.getVersionManagement();
        Vector result = new Vector();
        try {
            if (this.verSail != null) {
                Iterator iResult = this.verSail.getUpdateIds();
                while (iResult.hasNext()) {
                    Object o = iResult.next();
                    result.add(o);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public void pauseCounterIncrement() {
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                this.verSail.pauseCounterIncrement();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void continueCounterIncrement() {
        this.verSail = this.getVersionManagement();
        try {
            if (this.verSail != null) {
                this.verSail.continueCounterIncrement();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public boolean isPausedCounterIncrement() {
        this.verSail = this.getVersionManagement();
        boolean result = false;
        try {
            if (this.verSail != null) {
                result = this.verSail.isPausedCounterIncrement();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Vector getVersionIds() {
        this.verSail = this.getVersionManagement();
        Vector result = new Vector();
        try {
            if (this.verSail != null) {
                Iterator iResult = this.verSail.getVersionIds();
                while (iResult.hasNext()) {
                    Object o = iResult.next();
                    result.add(o);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Map getMetaInfo(String subj, String pred, String obj) {
        this.verSail = this.getVersionManagement();
        Map result = null;
        try {
            if (this.verSail != null) {
                result = this.verSail.getMetaInfo(subj, pred, obj);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Map getVersionMetaInfo(String versionId) {
        this.verSail = this.getVersionManagement();
        Map result = null;
        try {
            if (this.verSail != null) {
                result = this.verSail.getVersionMetaInfo(versionId);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Map getUpdateMetaInfo(String updateId) {
        this.verSail = this.getVersionManagement();
        Map result = null;
        try {
            if (this.verSail != null) {
                result = this.verSail.getUpdateMetaInfo(updateId);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }
}

