/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.txn;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.ThreadLocker;

public class ReplicaThreadLocker
extends ThreadLocker {
    private final RepImpl repImpl;

    public ReplicaThreadLocker(RepImpl repImpl) {
        super(repImpl);
        this.repImpl = repImpl;
    }

    public LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) {
        if (lockType.isWriteLock()) {
            throw new ReplicaWriteException(this, this.repImpl.getStateChangeEvent());
        }
        return super.lockInternal(nodeId, lockType, noWait, database);
    }

    public void openCursorHook() throws ReplicaConsistencyException {
        ReadonlyTxn.checkConsistency(this.repImpl, this.repImpl.getDefaultConsistencyPolicy());
    }

    public boolean isReplicationDefined() {
        return true;
    }
}

