/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;

public class SqlJetAlterTableDef {
    private static final String INVALID_ALTER_TABLE_STATEMENT = "Invalid ALTER TABLE statement";
    private final String tableName;
    private final String newTableName;
    private final String tableQuotedName;
    private final String newTableQuotedName;
    private final ISqlJetColumnDef newColumnDef;
    private ParserRuleReturnScope parsedSql;

    public SqlJetAlterTableDef(ParserRuleReturnScope parsedSql) throws SqlJetException {
        this.parsedSql = parsedSql;
        CommonTree ast = (CommonTree)parsedSql.getTree();
        int childCount = ast.getChildCount();
        if (childCount < 5) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
        CommonTree alterNode = (CommonTree)ast.getChild(0);
        CommonTree tableNode = (CommonTree)ast.getChild(1);
        if (!"alter".equalsIgnoreCase(alterNode.getText()) || !"table".equalsIgnoreCase(tableNode.getText())) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
        CommonTree tableNameNode = (CommonTree)ast.getChild(2);
        this.tableName = tableNameNode.getText();
        this.tableQuotedName = SqlParser.quotedId(tableNameNode);
        CommonTree actionNode = (CommonTree)ast.getChild(3);
        String action = actionNode.getText();
        CommonTree child = (CommonTree)ast.getChild(4);
        if ("add".equalsIgnoreCase(action)) {
            CommonTree newColumnNode;
            this.newTableName = null;
            this.newTableQuotedName = null;
            if ("column".equalsIgnoreCase(child.getText())) {
                if (childCount != 6) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
                }
                newColumnNode = (CommonTree)ast.getChild(5);
            } else {
                if (childCount != 5) {
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
                }
                newColumnNode = child;
            }
            this.newColumnDef = new SqlJetColumnDef(newColumnNode);
        } else if ("rename".equalsIgnoreCase(action)) {
            this.newColumnDef = null;
            assert ("to".equalsIgnoreCase(child.getText()));
            if (childCount < 6) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
            }
            CommonTree newTableNode = (CommonTree)ast.getChild(5);
            this.newTableName = newTableNode.getText();
            this.newTableQuotedName = SqlParser.quotedId(newTableNode);
        } else {
            this.newTableName = null;
            this.newTableQuotedName = null;
            this.newColumnDef = null;
            throw new SqlJetException(SqlJetErrorCode.MISUSE, INVALID_ALTER_TABLE_STATEMENT);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getTableQuotedName() {
        return this.tableQuotedName;
    }

    public String getNewTableQuotedName() {
        return this.newTableQuotedName;
    }

    public ISqlJetColumnDef getNewColumnDef() {
        return this.newColumnDef;
    }

    public ParserRuleReturnScope getParsedSql() {
        return this.parsedSql;
    }
}

