/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.stats.Statistics;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseStatisticsOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Extrema
extends BaseStatisticsOperationJAI {
    private static final String EXTREMA = "Extrema";
    private static final String STATS = "Stats";
    private static final long serialVersionUID = 7731039381590398047L;
    public static final Logger LOGGER = Logging.getLogger(Extrema.class);
    public static final String GT_SYNTHETIC_PROPERTY_MINIMUM = "minimum";
    public static final String GT_SYNTHETIC_PROPERTY_MAXIMUM = "maximum";
    public static final String GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS = "minLocations";
    public static final String GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS = "maxLocations";

    public Extrema() throws OperationNotFoundException {
        super(EXTREMA, Extrema.getOperationDescriptor(JAIExt.getOperationName((String)EXTREMA)));
    }

    @Override
    public String getName() {
        return EXTREMA;
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        if (data instanceof RenderedOp) {
            RenderedOp result = (RenderedOp)data;
            HashMap<String, Object> synthProp = new HashMap<String, Object>();
            if (JAIExt.isJAIExtOperation((String)STATS)) {
                Statistics[][] results = (Statistics[][])result.getProperty("JAI-EXT.stats");
                int numBands = result.getNumBands();
                double[] maximums = new double[numBands];
                double[] minimums = new double[numBands];
                for (int i = 0; i < results.length; ++i) {
                    Statistics stat = results[i][0];
                    double[] binsDouble = (double[])stat.getResult();
                    minimums[i] = binsDouble[0];
                    maximums[i] = binsDouble[1];
                }
                synthProp.put(GT_SYNTHETIC_PROPERTY_MINIMUM, minimums);
                synthProp.put(GT_SYNTHETIC_PROPERTY_MAXIMUM, maximums);
            } else {
                double[] maximums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MAXIMUM);
                double[] minimums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MINIMUM);
                Object property = result.getProperty(GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS);
                if (property instanceof List[]) {
                    synthProp.put(GT_SYNTHETIC_PROPERTY_MIN_LOCATIONS, property);
                }
                if ((property = result.getProperty(GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS)) instanceof List[]) {
                    synthProp.put(GT_SYNTHETIC_PROPERTY_MAX_LOCATIONS, property);
                }
                synthProp.put(GT_SYNTHETIC_PROPERTY_MINIMUM, minimums);
                synthProp.put(GT_SYNTHETIC_PROPERTY_MAXIMUM, maximums);
            }
            GridCoverage2D source = sources[0];
            CoverageUtilities.setROIProperty(synthProp, CoverageUtilities.getROIProperty(source));
            CoverageUtilities.setNoDataProperty(synthProp, CoverageUtilities.getNoDataProperty(source));
            return Collections.unmodifiableMap(synthProp);
        }
        return super.getProperties(data, crs, name, toCRS, sources, parameters);
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation((String)STATS)) {
            GridCoverage2D source = (GridCoverage2D)((Object)parameters2.parameter("source0").getValue());
            Extrema.handleROINoDataInternal(parameters, source, STATS, 2, 3);
            parameters.set((Object)new Statistics.StatsType[]{Statistics.StatsType.EXTREMA}, 6);
            int b = source.getRenderedImage().getSampleModel().getNumBands();
            int[] indexes = new int[b];
            for (int i = 0; i < b; ++i) {
                indexes[i] = i;
            }
            parameters.set((Object)indexes, 5);
        }
    }
}

