/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import com.google.common.base.Function;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.XmlRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpResponse;

public class GeonetHttpRequestFactory {
    private int numberOfConcurrentRequests = 20;
    private PoolingHttpClientConnectionManager connectionManager;
    private volatile HttpClientConnectionManager nonShutdownableConnectionManager;

    @PreDestroy
    public synchronized void shutdown() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
    }

    public synchronized void setNumberOfConcurrentRequests(int numberOfConcurrentRequests) {
        this.shutdown();
        this.numberOfConcurrentRequests = numberOfConcurrentRequests;
    }

    public final XmlRequest createXmlRequest() {
        return this.createXmlRequest(null, 80, "http");
    }

    public XmlRequest createXmlRequest(String host, int port, String protocol) {
        return new XmlRequest(host, port, protocol, this);
    }

    public final XmlRequest createXmlRequest(String host) {
        return this.createXmlRequest(host, 80, "http");
    }

    public final XmlRequest createXmlRequest(String host, int port) {
        String protocol = "http";
        if (port == 443) {
            protocol = "https";
        }
        return this.createXmlRequest(host, port, protocol);
    }

    public final XmlRequest createXmlRequest(URL url) {
        int port = url.getPort();
        XmlRequest request = this.createXmlRequest(url.getHost(), port, url.getProtocol());
        request.setAddress(url.getPath());
        request.setQuery(url.getQuery());
        request.setFragment(url.getRef());
        request.setUserInfo(url.getUserInfo());
        request.setCookieStore((CookieStore)new BasicCookieStore());
        return request;
    }

    public ClientHttpResponse execute(HttpUriRequest request) throws IOException {
        Function<HttpClientBuilder, Void> noop = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nullable HttpClientBuilder input) {
                return null;
            }
        };
        return this.execute(request, noop);
    }

    public ClientHttpResponse execute(HttpUriRequest request, final Credentials credentials, final AuthScope authScope) throws IOException {
        Function<HttpClientBuilder, Void> setCredentials = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(authScope, credentials);
                input.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                return null;
            }
        };
        return this.execute(request, setCredentials);
    }

    public ClientHttpResponse execute(HttpUriRequest request, Function<HttpClientBuilder, Void> configurator) throws IOException {
        HttpClientBuilder clientBuilder = this.getDefaultHttpClientBuilder();
        configurator.apply((Object)clientBuilder);
        CloseableHttpClient httpClient = clientBuilder.build();
        return new AdaptingResponse(httpClient, httpClient.execute(request));
    }

    public ClientHttpResponse execute(HttpUriRequest request, Function<HttpClientBuilder, Void> configurator, AbstractHttpRequest r) throws IOException {
        HttpClientBuilder clientBuilder = this.getDefaultHttpClientBuilder();
        configurator.apply((Object)clientBuilder);
        CloseableHttpClient httpClient = clientBuilder.build();
        if (r.isPreemptiveBasicAuth() || r.getHttpClientContext() != null) {
            return new AdaptingResponse(httpClient, httpClient.execute(request, (HttpContext)r.getHttpClientContext()));
        }
        return new AdaptingResponse(httpClient, httpClient.execute(request));
    }

    public ClientHttpResponse execute(HttpUriRequest request, Function<HttpClientBuilder, Void> configurator, HttpClientContext context) throws IOException {
        HttpClientBuilder clientBuilder = this.getDefaultHttpClientBuilder();
        configurator.apply((Object)clientBuilder);
        CloseableHttpClient httpClient = clientBuilder.build();
        return new AdaptingResponse(httpClient, httpClient.execute(request, (HttpContext)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientBuilder getDefaultHttpClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        builder.disableContentCompression();
        builder.useSystemProperties();
        GeonetHttpRequestFactory geonetHttpRequestFactory = this;
        synchronized (geonetHttpRequestFactory) {
            if (this.connectionManager == null) {
                this.connectionManager = new PoolingHttpClientConnectionManager();
                this.connectionManager.setMaxTotal(this.numberOfConcurrentRequests);
                this.nonShutdownableConnectionManager = new HttpClientConnectionManager(){

                    public void closeExpiredConnections() {
                        GeonetHttpRequestFactory.this.connectionManager.closeExpiredConnections();
                    }

                    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
                        return GeonetHttpRequestFactory.this.connectionManager.requestConnection(route, state);
                    }

                    public void releaseConnection(HttpClientConnection managedConn, Object state, long keepalive, TimeUnit tunit) {
                        GeonetHttpRequestFactory.this.connectionManager.releaseConnection(managedConn, state, keepalive, tunit);
                    }

                    public void connect(HttpClientConnection managedConn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
                        GeonetHttpRequestFactory.this.connectionManager.connect(managedConn, route, connectTimeout, context);
                    }

                    public void upgrade(HttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
                        GeonetHttpRequestFactory.this.connectionManager.upgrade(managedConn, route, context);
                    }

                    public void routeComplete(HttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
                        GeonetHttpRequestFactory.this.connectionManager.routeComplete(managedConn, route, context);
                    }

                    public void shutdown() {
                    }

                    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
                        GeonetHttpRequestFactory.this.connectionManager.closeIdleConnections(idleTimeout, tunit);
                    }
                };
            }
            this.connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout((int)TimeUnit.MINUTES.toMillis(3L)).build());
            builder.setConnectionManager(this.nonShutdownableConnectionManager);
        }
        return builder;
    }

    private static class AdaptingResponse
    extends AbstractClientHttpResponse {
        private final CloseableHttpResponse response;
        private final CloseableHttpClient client;

        public AdaptingResponse(CloseableHttpClient client, CloseableHttpResponse response) {
            this.response = response;
            this.client = client;
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusLine().getReasonPhrase();
        }

        public void close() {
            IOUtils.closeQuietly((Closeable)this.response);
            IOUtils.closeQuietly((Closeable)this.client);
        }

        public InputStream getBody() throws IOException {
            return this.response.getEntity().getContent();
        }

        public HttpHeaders getHeaders() {
            Header[] headers;
            HttpHeaders httpHeaders = new HttpHeaders();
            for (Header header : headers = this.response.getAllHeaders()) {
                HeaderElement[] elements;
                for (HeaderElement element : elements = header.getElements()) {
                    httpHeaders.add(header.getName(), element.getValue());
                }
            }
            return httpHeaders;
        }
    }
}

