/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;

public class JeevesJCS
extends GroupCacheAccess {
    private static CompositeCacheManager cacheMgr;
    private static Path configFilename;

    protected JeevesJCS(CompositeCache cacheControl) {
        super(cacheControl);
    }

    public static JeevesJCS getInstance(String region) throws CacheException {
        JeevesJCS.ensureCacheManager();
        return new JeevesJCS(cacheMgr.getCache(region));
    }

    public static JeevesJCS getInstance(String region, ICompositeCacheAttributes icca) throws CacheException {
        JeevesJCS.ensureCacheManager();
        return new JeevesJCS(cacheMgr.getCache(region, icca));
    }

    protected static synchronized void ensureCacheManager() {
        if (cacheMgr == null) {
            if (configFilename == null) {
                cacheMgr = CompositeCacheManager.getInstance();
            } else {
                cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
                JeevesJCS.configure();
            }
        }
    }

    private static void configure() {
        Properties props = new Properties();
        try (BufferedReader is = IO.newBufferedReader(configFilename, Constants.CHARSET);){
            props.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load cache configuration from: " + configFilename, e);
        }
        cacheMgr.configure(props);
    }

    public static void setConfigFilename(Path configFilename) {
        cacheMgr = null;
        JeevesJCS.configFilename = configFilename;
    }
}

