/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.config.springutil.JeevesDelegatingFilterProxy;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.resources.Resources;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.request.ServletWebRequest;

public class ResourceFilter
implements Filter {
    private static final int FIVE_DAYS = 432000;
    private static final int SIX_HOURS = 21600;
    private FilterConfig config;
    private ServletContext servletContext;
    private volatile Pair<byte[], Long> defaultImage;
    private ConcurrentMap<String, Pair<byte[], Long>> faviconMap = Maps.newConcurrentMap();

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.servletContext = config.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        new Instance(request, response).execute();
    }

    public synchronized void destroy() {
        this.servletContext = null;
        this.defaultImage = null;
        this.faviconMap = null;
    }

    public class Instance {
        private final ServletRequest request;
        private final ServletResponse response;
        private final Path resourcesDir;
        private final Path appPath;
        private final String nodeId;
        private final String siteId;
        private final Resources resources;
        private Pair<byte[], Long> favicon;

        public Instance(ServletRequest request, ServletResponse response) throws IOException {
            ConfigurableApplicationContext applicationContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(ResourceFilter.this.servletContext);
            this.appPath = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getWebappDir();
            this.resources = (Resources)applicationContext.getBean(Resources.class);
            this.siteId = ((SettingManager)applicationContext.getBean(SettingManager.class)).getSiteId();
            this.resourcesDir = this.resources.locateResourcesDir(ResourceFilter.this.servletContext, (ApplicationContext)applicationContext);
            if (ResourceFilter.this.defaultImage == null) {
                ResourceFilter.this.defaultImage = this.resources.loadResource(this.resourcesDir, ResourceFilter.this.servletContext, this.appPath, "images/logos/" + this.siteId + ".png", new byte[0], -1L);
            }
            this.nodeId = ((NodeInfo)applicationContext.getBean(NodeInfo.class)).getId();
            if (!ResourceFilter.this.faviconMap.containsKey(this.nodeId)) {
                byte[] defaultImageBytes = (byte[])ResourceFilter.this.defaultImage.one();
                this.addFavIcon(this.nodeId, this.resources.loadResource(this.resourcesDir, ResourceFilter.this.servletContext, this.appPath, "images/logos/" + this.siteId + ".ico", defaultImageBytes, -1L));
            }
            this.favicon = (Pair)ResourceFilter.this.faviconMap.get(this.nodeId);
            this.request = request;
            this.response = response;
        }

        private boolean isGet(ServletRequest request) {
            return ((HttpServletRequest)request).getMethod().equalsIgnoreCase("GET");
        }

        public void execute() throws IOException {
            if (this.isGet(this.request)) {
                String filename = ((HttpServletRequest)this.request).getPathInfo();
                int extIdx = filename.lastIndexOf(46);
                String ext = extIdx > 0 ? filename.substring(extIdx + 1) : "png";
                HttpServletResponse httpServletResponse = (HttpServletResponse)this.response;
                FileTime lastModified = this.resources.getLastModified(this.resourcesDir, ResourceFilter.this.servletContext, this.appPath, filename);
                if (lastModified != null && new ServletWebRequest((HttpServletRequest)this.request, httpServletResponse).checkNotModified(lastModified.toMillis())) {
                    return;
                }
                String contentType = "xml".equals(ext) || "xsd".equals(ext) ? "application/xml" : "image/" + ext;
                httpServletResponse.setContentType(contentType);
                httpServletResponse.addHeader("Cache-Control", "max-age=21600, public");
                if (filename.equals("images/logos/" + this.siteId + ".ico")) {
                    this.favicon = this.resources.loadResource(this.resourcesDir, ResourceFilter.this.servletContext, this.appPath, "images/logos/" + this.siteId + ".ico", (byte[])this.favicon.one(), (Long)this.favicon.two());
                    this.addFavIcon(this.nodeId, this.favicon);
                    httpServletResponse.setContentLength(((byte[])this.favicon.one()).length);
                    httpServletResponse.addHeader("Cache-Control", "max-age=432000, public");
                    this.response.getOutputStream().write((byte[])this.favicon.one());
                } else {
                    Pair<byte[], Long> loadResource;
                    byte[] defaultData = null;
                    if (!contentType.equals("application/xml")) {
                        defaultData = (byte[])ResourceFilter.this.defaultImage.one();
                    }
                    if ((Long)(loadResource = this.resources.loadResource(this.resourcesDir, ResourceFilter.this.servletContext, this.appPath, filename, defaultData, -1L)).two() == -1L) {
                        httpServletResponse.sendError(404);
                    } else {
                        httpServletResponse.setContentLength(((byte[])loadResource.one()).length);
                        this.response.getOutputStream().write((byte[])loadResource.one());
                    }
                }
            }
        }

        private synchronized void addFavIcon(String nodeId, Pair<byte[], Long> favicon) {
            if (ResourceFilter.this.faviconMap.containsKey(nodeId)) {
                ResourceFilter.this.faviconMap.replace(nodeId, favicon);
            } else {
                ResourceFilter.this.faviconMap.putIfAbsent(nodeId, favicon);
            }
        }
    }
}

