/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.entitylistener.GeonetworkEntityListener;
import org.fao.geonet.entitylistener.PersistentEventType;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class TranslatorCache {
    private final Map<String, Optional<Localized>> cache = new HashMap<String, Optional<Localized>>();

    @Nullable
    public synchronized Optional<Localized> get(@Nonnull String key) {
        return this.cache.get(key);
    }

    public synchronized void put(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String key, @Nullable Localized value) {
        if (value != null) {
            String beanName = "ClearTranslatorCache_" + value.getClass().getSimpleName();
            try {
                applicationContext.getBean(beanName);
            }
            catch (NoSuchBeanDefinitionException e) {
                applicationContext.getBeanFactory().registerSingleton(beanName, (Object)new ClearCacheListener(value.getClass()));
            }
        }
        this.cache.put(key, Optional.ofNullable(value));
    }

    private class ClearCacheListener
    implements GeonetworkEntityListener {
        private final Class entityClass;

        private ClearCacheListener(Class entityClass) {
            this.entityClass = entityClass;
        }

        public Class getEntityClass() {
            return this.entityClass;
        }

        public void handleEvent(PersistentEventType type, Object entity) {
            TranslatorCache.this.cache.clear();
        }
    }
}

