/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.region;

import java.lang.ref.WeakReference;
import java.util.Collection;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.kernel.region.CachedRequest;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.Request;
import org.jdom.Element;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class RegionsDAO {
    private boolean cacheAllRegionsInMemory = true;
    private WeakReference<CachedRequest> allRegions = new WeakReference<Object>(null);

    public abstract Collection<String> getRegionCategoryIds(ServiceContext var1) throws Exception;

    public abstract Request createSearchRequest(ServiceContext var1) throws Exception;

    public abstract Geometry getGeom(ServiceContext var1, String var2, boolean var3, CoordinateReferenceSystem var4) throws Exception;

    public final Geometry getGeom(ServiceContext context, String id, boolean simplified, String projectionCode) throws Exception {
        return this.getGeom(context, id, simplified, Region.decodeCRS(projectionCode));
    }

    public Collection<Region> getAllRegions(ServiceContext context) throws Exception {
        return this.allRegions(context).execute();
    }

    public Element getAllRegionsAsXml(ServiceContext context) throws Exception {
        return this.allRegions(context).xmlResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request allRegions(ServiceContext context) throws Exception {
        if (this.cacheAllRegionsInMemory) {
            RegionsDAO regionsDAO = this;
            synchronized (regionsDAO) {
                CachedRequest request = (CachedRequest)this.allRegions.get();
                if (request == null) {
                    request = new CachedRequest(this.createSearchRequest(context));
                    this.allRegions = new WeakReference<CachedRequest>(request);
                }
                return request;
            }
        }
        return this.createSearchRequest(context);
    }

    public void setCacheAllRegionsInMemory(boolean cacheAllRegionsInMemory) {
        this.cacheAllRegionsInMemory = cacheAllRegionsInMemory;
    }

    protected synchronized void clearCaches() {
        this.allRegions.clear();
    }

    public boolean includeInListing() {
        return true;
    }
}

