/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.SelectionRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.util.LocalizedEmail;
import org.fao.geonet.util.LocalizedEmailComponent;
import org.fao.geonet.util.LocalizedEmailParameter;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class WatchListNotifier
extends QuartzJobBean {
    private String lastNotificationDate;
    private String nextLastNotificationDate;
    private String updatedRecordPermalink;
    private String language = "eng";
    private SettingManager settingManager;
    private ApplicationContext appContext;
    private UserSavedSelectionRepository userSavedSelectionRepository;
    private UserRepository userRepository;
    private FeedbackLanguages feedbackLanguages;
    @Value(value="${usersavedselection.watchlist.searchurl}")
    private String permalinkApp = "catalog.search#/search?_uuid={{filter}}";
    @Value(value="${usersavedselection.watchlist.recordurl}")
    private String permalinkRecordApp = "api/records/{{index:uuid}}";

    public String getPermalinkApp() {
        return this.permalinkApp;
    }

    public void setPermalinkApp(String permalinkApp) {
        this.permalinkApp = permalinkApp;
    }

    public String getPermalinkRecordApp() {
        return this.permalinkRecordApp;
    }

    public void setPermalinkRecordApp(String permalinkRecordApp) {
        this.permalinkRecordApp = permalinkRecordApp;
    }

    protected void executeInternal(JobExecutionContext jobContext) throws JobExecutionException {
        this.appContext = ApplicationContextHolder.get();
        this.settingManager = (SettingManager)this.appContext.getBean(SettingManager.class);
        this.feedbackLanguages = (FeedbackLanguages)this.appContext.getBean(FeedbackLanguages.class);
        this.updatedRecordPermalink = this.settingManager.getSiteURL(this.language);
        this.lastNotificationDate = this.settingManager.getValue("system/userFeedback/lastNotificationDate");
        this.nextLastNotificationDate = new ISODate().toString();
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("Last notification date for saved selection was %s.", this.lastNotificationDate));
        }
        this.userSavedSelectionRepository = (UserSavedSelectionRepository)this.appContext.getBean(UserSavedSelectionRepository.class);
        this.userRepository = (UserRepository)this.appContext.getBean(UserRepository.class);
        SelectionRepository selectionRepository = (SelectionRepository)this.appContext.getBean(SelectionRepository.class);
        List selectionList = selectionRepository.findAll();
        for (Selection selection : selectionList) {
            if (!selection.isWatchable()) continue;
            Integer selectionId = selection.getId();
            List allUsers = this.userSavedSelectionRepository.findAllUsers(selectionId);
            if (StringUtils.isNotBlank((String)this.lastNotificationDate)) {
                if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
                    Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("  Notifying %d users about changes since %s in list %d", allUsers.size(), this.lastNotificationDate, selectionId));
                }
                for (Integer userId : allUsers) {
                    this.notify(selectionId, userId);
                }
                continue;
            }
            if (!Log.isDebugEnabled((String)"geonetwork.userwatchlist")) continue;
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("  Notification of %d users saved selection %d will start on next run. Last notification date was null", allUsers.size(), selectionId));
        }
        this.settingManager.setValue("system/userFeedback/lastNotificationDate", this.nextLastNotificationDate);
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("Next notification date for saved selection is now %s.", this.nextLastNotificationDate));
        }
    }

    private void notify(Integer selectionId, Integer userId) {
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(new Locale(this.language));
        List updatedRecords = this.userSavedSelectionRepository.findMetadataUpdatedAfter(selectionId, userId, this.lastNotificationDate, this.nextLastNotificationDate);
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    Notifying user %d about %d changes since %s in list %d", userId, updatedRecords.size(), this.lastNotificationDate, selectionId));
        }
        if (updatedRecords.size() > 0) {
            Optional user = this.userRepository.findById((Object)userId);
            if (user.isPresent() && StringUtils.isNotEmpty((String)((User)user.get()).getEmail())) {
                String url = this.updatedRecordPermalink + this.permalinkApp.replace("{{filter}}", String.join((CharSequence)" or ", updatedRecords));
                LocalizedEmailComponent emailSubjectComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.SUBJECT, "user_watchlist_subject", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                LocalizedEmailComponent emailMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.MESSAGE, "user_watchlist_message", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.POSITIONAL_FORMAT);
                for (Locale feedbackLocale : feedbackLocales) {
                    StringBuffer listOfUpdateMessage = new StringBuffer();
                    for (String record : updatedRecords) {
                        LocalizedEmailComponent recordMessageComponent = new LocalizedEmailComponent(LocalizedEmailComponent.ComponentType.NESTED, "user_watchlist_message_record", LocalizedEmailComponent.KeyType.MESSAGE_KEY, LocalizedEmailComponent.ReplacementType.NAMED_FORMAT);
                        recordMessageComponent.enableCompileWithIndexFields(record);
                        recordMessageComponent.enableReplaceLinks(true);
                        try {
                            listOfUpdateMessage.append(recordMessageComponent.parseMessage(feedbackLocale));
                        }
                        catch (Exception e) {
                            Log.error((String)"geonetwork.userwatchlist", (String)e.getMessage(), (Throwable)e);
                        }
                    }
                    emailSubjectComponent.addParameters(feedbackLocale, new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 1, this.settingManager.getSiteName()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 2, updatedRecords.size()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 3, this.lastNotificationDate));
                    emailMessageComponent.addParameters(feedbackLocale, new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 1, listOfUpdateMessage.toString()), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 2, this.lastNotificationDate), new LocalizedEmailParameter(LocalizedEmailParameter.ParameterType.RAW_VALUE, 3, url));
                }
                LocalizedEmail localizedEmail = new LocalizedEmail(true);
                localizedEmail.addComponents(emailSubjectComponent, emailMessageComponent);
                String mailSubject = localizedEmail.getParsedSubject(feedbackLocales);
                String htmlMessage = localizedEmail.getParsedMessage(feedbackLocales);
                if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
                    Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    Sending message with subject %s to user %d", mailSubject, userId));
                }
                MailUtil.sendHtmlMail(Arrays.asList(((User)user.get()).getEmail()), mailSubject, htmlMessage, this.settingManager);
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    No changes for user %d since %s in his/her list %d", userId, this.lastNotificationDate, selectionId));
        }
    }
}

