/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import jeeves.server.context.ServiceContext;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class GeonetworkOverridingWKTFactory
extends FactoryUsingWKT
implements CoordinateOperationAuthorityFactory {
    private static final String SYSTEM_DEFAULT_USER_PROJ_FILE = "geonetwork.override.crs.proj.file";

    public GeonetworkOverridingWKTFactory() {
        super(null, 100);
    }

    public GeonetworkOverridingWKTFactory(Hints userHints) {
        super(userHints, 100);
    }

    protected URL getDefinitionsURL() {
        File proj_file;
        String overrideProjFile = System.getProperty(SYSTEM_DEFAULT_USER_PROJ_FILE);
        if (overrideProjFile == null) {
            ServiceContext srvContext = ServiceContext.get();
            if (srvContext != null) {
                overrideProjFile = srvContext.getServlet().getServletContext().getRealPath("/WEB-INF/override_epsg.properties");
            }
            if (overrideProjFile == null || !new File(overrideProjFile).exists()) {
                overrideProjFile = "override_epsg.properties";
            }
        }
        if ((proj_file = new File(overrideProjFile)).exists()) {
            try {
                return proj_file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "Had troubles converting file name to URL", e);
            }
        }
        overrideProjFile = "override_epsg.properties";
        return GeonetworkOverridingWKTFactory.class.getResource(overrideProjFile);
    }
}

