/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.schemas;

import java.nio.file.Path;
import java.util.Map;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlFile;
import org.apache.commons.io.FilenameUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class GetSchemaInfo
implements Service {
    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager schemaMan = gc.getBean(SchemaManager.class);
        Element schemas = new Element("schemas");
        for (String schema : schemaMan.getSchemas()) {
            try {
                Map<String, XmlFile> schemaInfo = schemaMan.getSchemaInfo(schema);
                for (Map.Entry<String, XmlFile> entry : schemaInfo.entrySet()) {
                    XmlFile xf = entry.getValue();
                    String fname = entry.getKey();
                    Element response = xf.exec(new Element("junk"), context);
                    response.setName(FilenameUtils.removeExtension((String)fname));
                    response.removeAttribute("noNamespaceSchemaLocation", Geonet.Namespaces.XSI);
                    Element schemaElem = new Element(schema);
                    schemaElem.addContent((Content)response);
                    schemas.addContent((Content)schemaElem);
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork", (String)("Failed to load guiservices for schema " + schema + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return schemas;
    }
}

