/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregator;
import org.fusesource.hawtdispatch.OrderedEventAggregator;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.WorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HawtCustomDispatchSource<Event, MergedEvent>
extends AbstractDispatchObject
implements CustomDispatchSource<Event, MergedEvent> {
    public static final boolean DEBUG = false;
    final AtomicBoolean canceled = new AtomicBoolean();
    private Task cancelHandler;
    private Task eventHandler;
    private final ThreadLocal<MergedEvent> outboundEvent = new ThreadLocal();
    private final ThreadLocal<MergedEvent> firedEvent = new ThreadLocal();
    private final EventAggregator<Event, MergedEvent> aggregator;
    private MergedEvent pendingEvent;
    private final boolean ordered;
    protected final ConcurrentLinkedQueue<MergedEvent> externalQueue = new ConcurrentLinkedQueue();
    protected final AtomicLong size = new AtomicLong();

    public HawtCustomDispatchSource(HawtDispatcher dispatcher, EventAggregator<Event, MergedEvent> aggregator, DispatchQueue queue) {
        this.aggregator = aggregator;
        this.suspended.incrementAndGet();
        this.ordered = aggregator instanceof OrderedEventAggregator;
        this.setTargetQueue(queue);
    }

    @Override
    public MergedEvent getData() {
        return this.firedEvent.get();
    }

    @Override
    public void merge(Event event) {
        this.debug("merge called", new Object[0]);
        WorkerThread thread = WorkerThread.currentWorkerThread();
        if (thread != null) {
            MergedEvent previous = this.outboundEvent.get();
            MergedEvent next = this.aggregator.mergeEvent(previous, event);
            if (next == null) {
                this.debug("merge resulted in cancel", new Object[0]);
                this.outboundEvent.remove();
            } else {
                this.outboundEvent.set(next);
                if (previous == null) {
                    this.debug("first merge, posting deferred fire event", new Object[0]);
                    if (this.ordered) {
                        HawtDispatchQueue current = HawtDispatcher.CURRENT_QUEUE.get();
                        current.getSourceQueue().add(this);
                    } else {
                        thread.getDispatchQueue().getSourceQueue().add(this);
                    }
                } else {
                    this.debug("there was a previous merge, no need to post deferred fire event", new Object[0]);
                }
            }
        } else {
            this.debug("merge not called from a worker thread.. triggering fire event now", new Object[0]);
            this.fireEvent(this.aggregator.mergeEvent(null, event));
        }
    }

    @Override
    public void run() {
        this.debug("deferred fire event executing", new Object[0]);
        this.fireEvent(this.outboundEvent.get());
        this.outboundEvent.remove();
    }

    private void fireEvent(final MergedEvent event) {
        if (event != null) {
            this.targetQueue.execute(new Task(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (HawtCustomDispatchSource.this.isCanceled()) {
                        HawtCustomDispatchSource.this.debug("canceled", new Object[0]);
                        return;
                    }
                    if (HawtCustomDispatchSource.this.isSuspended()) {
                        HawtCustomDispatchSource.this.debug("fired.. but suspended", new Object[0]);
                        HawtCustomDispatchSource hawtCustomDispatchSource = HawtCustomDispatchSource.this;
                        synchronized (hawtCustomDispatchSource) {
                            if (HawtCustomDispatchSource.this.pendingEvent == null) {
                                HawtCustomDispatchSource.this.pendingEvent = event;
                            } else {
                                HawtCustomDispatchSource.this.pendingEvent = HawtCustomDispatchSource.this.aggregator.mergeEvents(HawtCustomDispatchSource.this.pendingEvent, event);
                            }
                        }
                    }
                    Object e = null;
                    HawtCustomDispatchSource hawtCustomDispatchSource = HawtCustomDispatchSource.this;
                    synchronized (hawtCustomDispatchSource) {
                        e = HawtCustomDispatchSource.this.pendingEvent;
                        HawtCustomDispatchSource.this.pendingEvent = null;
                    }
                    if (e != null) {
                        HawtCustomDispatchSource.this.debug("fired.. mergined with previous pending event..", new Object[0]);
                        e = HawtCustomDispatchSource.this.aggregator.mergeEvents(e, event);
                    } else {
                        HawtCustomDispatchSource.this.debug("fired.. no previous pending event..", new Object[0]);
                        e = event;
                    }
                    HawtCustomDispatchSource.this.firedEvent.set(e);
                    try {
                        HawtCustomDispatchSource.this.eventHandler.run();
                    }
                    catch (Throwable e1) {
                        Thread thread = Thread.currentThread();
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, e1);
                    }
                    HawtCustomDispatchSource.this.firedEvent.remove();
                    HawtCustomDispatchSource.this.debug("eventHandler done", new Object[0]);
                }
            });
        }
    }

    @Override
    protected void onStartup() {
        if (this.eventHandler == null) {
            throw new IllegalArgumentException("eventHandler must be set");
        }
        this.onResume();
    }

    @Override
    public void cancel() {
        if (this.canceled.compareAndSet(false, true)) {
            this.targetQueue.execute(new Task(){

                public void run() {
                    if (HawtCustomDispatchSource.this.cancelHandler != null) {
                        HawtCustomDispatchSource.this.cancelHandler.run();
                    }
                }
            });
        }
    }

    @Override
    protected void onResume() {
        this.debug("onResume", new Object[0]);
        this.targetQueue.execute(new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (HawtCustomDispatchSource.this.isCanceled()) {
                    return;
                }
                if (!HawtCustomDispatchSource.this.isSuspended()) {
                    Object e = null;
                    HawtCustomDispatchSource hawtCustomDispatchSource = HawtCustomDispatchSource.this;
                    synchronized (hawtCustomDispatchSource) {
                        e = HawtCustomDispatchSource.this.pendingEvent;
                        HawtCustomDispatchSource.this.pendingEvent = null;
                    }
                    if (e != null) {
                        HawtCustomDispatchSource.this.firedEvent.set(e);
                        HawtCustomDispatchSource.this.eventHandler.run();
                        HawtCustomDispatchSource.this.firedEvent.remove();
                    }
                }
            }
        });
    }

    @Override
    public boolean isCanceled() {
        return this.canceled.get();
    }

    @Override
    @Deprecated
    public void setCancelHandler(Runnable handler) {
        this.setCancelHandler(new TaskWrapper(handler));
    }

    @Override
    @Deprecated
    public void setEventHandler(Runnable handler) {
        this.setEventHandler(new TaskWrapper(handler));
    }

    @Override
    public void setCancelHandler(Task cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    @Override
    public void setEventHandler(Task eventHandler) {
        this.eventHandler = eventHandler;
    }

    protected void debug(String str, Object ... args) {
    }

    protected void debug(Throwable thrown, String str, Object ... args) {
    }
}

