/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceAuthorizationManager
implements MutableResourceAuthorizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceAuthorizationManager.class);
    private final Set<String> authorizedResources = Collections.synchronizedSet(new HashSet());

    @Override
    public boolean isAuthorized(String uri) {
        return this.authorizedResources.contains(WroUtil.removeQueryString(uri));
    }

    @Override
    public void add(String uri) {
        Validate.notNull((Object)uri);
        LOG.debug("authorize: {}", (Object)uri);
        this.authorizedResources.add(WroUtil.removeQueryString(uri));
    }

    public Collection<String> list() {
        return Collections.unmodifiableCollection(this.authorizedResources);
    }

    @Override
    public void clear() {
        LOG.debug("clear.");
        this.authorizedResources.clear();
    }
}

