/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers.google;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.geotools.util.Base64;
import org.mapfish.print.config.Key;

public class GoogleURLSigner {
    private byte[] key;
    private String clientId;

    public GoogleURLSigner(Key key) {
        this.clientId = key.getId();
        String keyString = key.getKey();
        keyString = keyString.replace('-', '+');
        keyString = keyString.replace('_', '/');
        this.key = Base64.decode((String)keyString);
    }

    public String signature(String resource) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, URISyntaxException {
        SecretKeySpec sha1Key = new SecretKeySpec(this.key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sha1Key);
        byte[] sigBytes = mac.doFinal(resource.getBytes());
        String signature = Base64.encodeBytes((byte[])sigBytes);
        signature = signature.replace('+', '-');
        signature = signature.replace('/', '_');
        return signature;
    }

    public String clientId() {
        return this.clientId;
    }
}

