/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.measure.PrefixDefinitions;
import org.geotools.measure.UnitDefinition;
import org.geotools.measure.Units;
import si.uom.NonSI;
import si.uom.SI;
import systems.uom.common.USCustomary;
import tech.units.indriya.AbstractUnit;

public final class UnitDefinitions {
    public static List<UnitDefinition> DIMENSIONLESS = UnitDefinitions.listOf(UnitDefinition.of(AbstractUnit.ONE, Collections.emptyList(), "one", Collections.emptyList()), UnitDefinition.of(tech.units.indriya.unit.Units.PERCENT, Collections.emptyList(), "%", Collections.emptyList()));
    public static List<UnitDefinition> SI_BASE = UnitDefinitions.listOf(UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.AMPERE), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.CANDELA), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.KELVIN), UnitDefinition.of(tech.units.indriya.unit.Units.KILOGRAM, Collections.emptyList(), null, Collections.emptyList()), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.METRE), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.MOLE), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.SECOND));
    public static List<UnitDefinition> CONSTANTS = UnitDefinitions.listOf(UnitDefinition.of(SI.AVOGADRO_CONSTANT, Collections.emptyList(), "NA", Collections.emptyList()), UnitDefinition.of(SI.BOLTZMANN_CONSTANT, Collections.emptyList(), "kB", Collections.emptyList()), UnitDefinition.of(SI.ELEMENTARY_CHARGE, Collections.emptyList(), "e", Collections.emptyList()), UnitDefinition.of(SI.PLANCK_CONSTANT, Collections.emptyList(), "\u210e", Collections.emptyList()));
    public static List<UnitDefinition> SI_DERIVED = UnitDefinitions.listOf(UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.BECQUEREL), UnitDefinition.of(tech.units.indriya.unit.Units.CELSIUS, PrefixDefinitions.STANDARD, "\u2103", Arrays.asList("\u00b0C")), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.COULOMB), UnitDefinition.of(tech.units.indriya.unit.Units.CUBIC_METRE, Collections.emptyList(), "\u33a5", Collections.emptyList()), UnitDefinition.of(tech.units.indriya.unit.Units.DAY, Collections.emptyList(), "day", Arrays.asList("d")), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.FARAD), UnitDefinition.of(tech.units.indriya.unit.Units.GRAM, PrefixDefinitions.GRAM, "g", Collections.emptyList()), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.GRAY), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.HENRY), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.HERTZ), UnitDefinition.of(tech.units.indriya.unit.Units.HOUR, Collections.emptyList(), "h", Collections.emptyList()), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.JOULE), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.KATAL), UnitDefinition.of(tech.units.indriya.unit.Units.KILOMETRE_PER_HOUR, Collections.emptyList(), "km/h", Collections.emptyList()), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.LITRE), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.LUMEN), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.LUX), UnitDefinition.of(tech.units.indriya.unit.Units.MINUTE, Collections.emptyList(), "min", Collections.emptyList()), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.NEWTON), UnitDefinition.of(tech.units.indriya.unit.Units.OHM, PrefixDefinitions.STANDARD, null, Arrays.asList("Ohm")), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.PASCAL), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.RADIAN), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.SIEMENS), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.SIEVERT), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.STERADIAN), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.TESLA), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.VOLT), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.WATT), UnitDefinition.withStandardPrefixes(tech.units.indriya.unit.Units.WEBER), UnitDefinition.of(tech.units.indriya.unit.Units.WEEK, Collections.emptyList(), "week", Collections.emptyList()), UnitDefinition.of(tech.units.indriya.unit.Units.YEAR, Collections.emptyList(), "year", Arrays.asList("days365")));
    public static List<UnitDefinition> NON_SI = UnitDefinitions.listOf(UnitDefinition.of(NonSI.DEGREE_ANGLE, Collections.emptyList(), "deg", Collections.emptyList()), UnitDefinition.of(NonSI.MINUTE_ANGLE, Collections.emptyList(), "'", Collections.emptyList()), UnitDefinition.of(NonSI.SECOND_ANGLE, Collections.emptyList(), "''", Collections.emptyList()), UnitDefinition.of(NonSI.ELECTRON_VOLT, Collections.emptyList(), "eV", Collections.emptyList()), UnitDefinition.of(NonSI.UNIFIED_ATOMIC_MASS, Collections.emptyList(), "u", Collections.emptyList()), UnitDefinition.of(NonSI.DALTON, Collections.emptyList(), "Da", Collections.emptyList()), UnitDefinition.of(NonSI.ASTRONOMICAL_UNIT, Collections.emptyList(), "UA", Collections.emptyList()), UnitDefinition.of(NonSI.HECTARE, Collections.emptyList(), "ha", Collections.emptyList()), UnitDefinition.of(NonSI.ANGSTROM, Collections.emptyList(), "\u00c5", Collections.emptyList()), UnitDefinition.of(NonSI.BOHR_RADIUS, Collections.emptyList(), "a0", Collections.emptyList()), UnitDefinition.of(NonSI.KNOT, Collections.emptyList(), "kn", Collections.emptyList()), UnitDefinition.of(NonSI.STANDARD_GRAVITY, Collections.emptyList(), "g\\u2099", Arrays.asList("gn")), UnitDefinition.of(NonSI.PHOT, Collections.emptyList(), "ph", Collections.emptyList()), UnitDefinition.of(NonSI.OERSTED, Collections.emptyList(), "Oe", Collections.emptyList()), UnitDefinition.of(NonSI.DYNE, Collections.emptyList(), "dyn", Collections.emptyList()), UnitDefinition.of(NonSI.KILOGRAM_FORCE, Collections.emptyList(), "kgf", Collections.emptyList()), UnitDefinition.of(NonSI.BAR, Collections.emptyList(), "b", Collections.emptyList()), UnitDefinition.of(NonSI.RAD, Collections.emptyList(), "rd", Collections.emptyList()), UnitDefinition.of(NonSI.ROENTGEN, Collections.emptyList(), "R", Collections.emptyList()), UnitDefinition.of(NonSI.BEL, Collections.emptyList(), "B", Collections.emptyList()), UnitDefinition.of(NonSI.NEPER, Collections.emptyList(), "Np", Collections.emptyList()), UnitDefinition.of(NonSI.TONNE, Collections.emptyList(), "t", Collections.emptyList()), UnitDefinition.of(MetricPrefix.MEGA((Unit)NonSI.TONNE), Collections.emptyList(), "Mt", Collections.emptyList()));
    public static List<UnitDefinition> US_CUSTOMARY = UnitDefinitions.listOf(UnitDefinition.of(USCustomary.INCH, Collections.emptyList(), "in", Collections.emptyList()), UnitDefinition.of(USCustomary.FOOT, Collections.emptyList(), "ft", Collections.emptyList()), UnitDefinition.of(USCustomary.FOOT_SURVEY, Collections.emptyList(), "ft_survey_us", Collections.emptyList()), UnitDefinition.of(USCustomary.YARD, Collections.emptyList(), "yd", Collections.emptyList()), UnitDefinition.of(USCustomary.MILE, Collections.emptyList(), "mi", Collections.emptyList()), UnitDefinition.of(USCustomary.NAUTICAL_MILE, Collections.emptyList(), "nmi", Collections.emptyList()), UnitDefinition.of(USCustomary.LIGHT_YEAR, Collections.emptyList(), "ly", Collections.emptyList()), UnitDefinition.of(USCustomary.OUNCE, Collections.emptyList(), "oz", Collections.emptyList()), UnitDefinition.of(USCustomary.POUND, Collections.emptyList(), "lb", Collections.emptyList()), UnitDefinition.of(USCustomary.TON, Collections.emptyList(), "ton_us", Collections.emptyList()), UnitDefinition.of(USCustomary.FAHRENHEIT, Collections.emptyList(), "\u00b0F", Collections.emptyList()), UnitDefinition.of(USCustomary.REVOLUTION, Collections.emptyList(), "rev", Collections.emptyList()), UnitDefinition.of(USCustomary.MILE_PER_HOUR, Collections.emptyList(), "mph", Collections.emptyList()), UnitDefinition.of(USCustomary.KNOT, Collections.emptyList(), "kn", Collections.emptyList()), UnitDefinition.of(USCustomary.SQUARE_FOOT, Collections.emptyList(), "sft", Collections.emptyList()), UnitDefinition.of(USCustomary.ARE, Collections.emptyList(), "a", Collections.emptyList()), UnitDefinition.of(USCustomary.ACRE, Collections.emptyList(), "ac", Collections.emptyList()), UnitDefinition.of(USCustomary.HECTARE, Collections.emptyList(), "ha", Collections.emptyList()), UnitDefinition.of(USCustomary.ELECTRON_VOLT, Collections.emptyList(), "eV", Collections.emptyList()), UnitDefinition.of(USCustomary.HORSEPOWER, Collections.emptyList(), "HP", Collections.emptyList()), UnitDefinition.of(USCustomary.LITER, Collections.emptyList(), "L", Collections.emptyList()), UnitDefinition.of(USCustomary.CUBIC_INCH, Collections.emptyList(), "in\u00b3", Collections.emptyList()), UnitDefinition.of(USCustomary.CUBIC_FOOT, Collections.emptyList(), "ft\u00b3", Collections.emptyList()), UnitDefinition.of(USCustomary.ACRE_FOOT, Collections.emptyList(), "ac ft", Collections.emptyList()), UnitDefinition.of(USCustomary.GALLON_DRY, Collections.emptyList(), "gal_dry_us", Collections.emptyList()), UnitDefinition.of(USCustomary.GALLON_LIQUID, Collections.emptyList(), "gal", Collections.emptyList()), UnitDefinition.of(USCustomary.FLUID_OUNCE, Collections.emptyList(), "fl oz", Collections.emptyList()), UnitDefinition.of(USCustomary.GILL_LIQUID, Collections.emptyList(), "liq.gi", Collections.emptyList()), UnitDefinition.of(USCustomary.MINIM, Collections.emptyList(), "min_us", Collections.emptyList()), UnitDefinition.of(USCustomary.FLUID_DRAM, Collections.emptyList(), "fl dr", Collections.emptyList()), UnitDefinition.of(USCustomary.CUP, Collections.emptyList(), "cup", Collections.emptyList()), UnitDefinition.of(USCustomary.TEASPOON, Collections.emptyList(), "tsp", Collections.emptyList()), UnitDefinition.of(USCustomary.TABLESPOON, Collections.emptyList(), "Tbsp", Collections.emptyList()), UnitDefinition.of(USCustomary.BARREL, Collections.emptyList(), "bbl", Collections.emptyList()), UnitDefinition.of(USCustomary.PINT, Collections.emptyList(), "pt", Collections.emptyList()));
    public static List<UnitDefinition> GEOTOOLS = UnitDefinitions.listOf(UnitDefinition.of(Units.DEGREE_MINUTE_SECOND, Collections.emptyList(), "DMS", Arrays.asList("degree minute second")), UnitDefinition.of(Units.SEXAGESIMAL_DMS, Collections.emptyList(), "D.MS", Arrays.asList("sexagesimal DMS", "DDD.MMSSsss", "sexagesimal degree DDD.MMSSsss")), UnitDefinition.of(Units.PPM, Collections.emptyList(), "ppm", Collections.emptyList()), UnitDefinition.of(NonSI.DEGREE_ANGLE, Collections.emptyList(), "\u00b0", Arrays.asList("deg")), UnitDefinition.of(Units.PIXEL, Collections.emptyList(), "pixel", Collections.emptyList()), UnitDefinition.of(USCustomary.GRADE, Collections.emptyList(), "grad", Arrays.asList("grade")), UnitDefinition.of(USCustomary.FOOT, Collections.emptyList(), "ft", Collections.emptyList()));
    public static List<UnitDefinition> EPSG = UnitDefinitions.listOf(UnitDefinition.of(Units.DEGREE_MINUTE_SECOND, Collections.emptyList(), "DMS", Arrays.asList("degree minute second")), UnitDefinition.of(Units.SEXAGESIMAL_DMS, Collections.emptyList(), "D.MS", Arrays.asList("sexagesimal DMS", "DDD.MMSSsss", "sexagesimal degree DDD.MMSSsss")), UnitDefinition.of(Units.PPM, Collections.emptyList(), "ppm", Collections.emptyList()), UnitDefinition.of(NonSI.DEGREE_ANGLE, Collections.emptyList(), "degree", Collections.emptyList()), UnitDefinition.of(Units.PIXEL, Collections.emptyList(), "pixel", Collections.emptyList()), UnitDefinition.of(USCustomary.GRADE, Collections.emptyList(), "grad", Arrays.asList("grade")), UnitDefinition.of(USCustomary.FOOT, Collections.emptyList(), "ft", Collections.emptyList()));
    public static List<UnitDefinition> ESRI = UnitDefinitions.listOf(UnitDefinition.of(Units.DEGREE_MINUTE_SECOND, Collections.emptyList(), "DMS", Arrays.asList("degree minute second")), UnitDefinition.of(Units.SEXAGESIMAL_DMS, Collections.emptyList(), "D.MS", Arrays.asList("sexagesimal DMS", "DDD.MMSSsss", "sexagesimal degree DDD.MMSSsss")), UnitDefinition.of(Units.PPM, Collections.emptyList(), "ppm", Collections.emptyList()), UnitDefinition.of(NonSI.DEGREE_ANGLE, Collections.emptyList(), "Degree", Collections.emptyList()), UnitDefinition.of(Units.PIXEL, Collections.emptyList(), "pixel", Collections.emptyList()), UnitDefinition.of(USCustomary.GRADE, Collections.emptyList(), "grad", Arrays.asList("grade")), UnitDefinition.of(USCustomary.FOOT, Collections.emptyList(), "ft", Arrays.asList("Foot")), UnitDefinition.of(Units.FOOT_GOLD_COAST, Collections.emptyList(), null, Collections.emptyList()), UnitDefinition.of(USCustomary.FOOT_SURVEY, Collections.emptyList(), "Foot_US", Collections.emptyList()), UnitDefinition.of(Units.METRE, Collections.emptyList(), "Meter", Collections.emptyList()));
    public static List<UnitDefinition> WKT = UnitDefinitions.listOf(UnitDefinition.of(Units.DEGREE_MINUTE_SECOND, Collections.emptyList(), "DMS", Arrays.asList("degree minute second")), UnitDefinition.of(Units.SEXAGESIMAL_DMS, Collections.emptyList(), "D.MS", Arrays.asList("sexagesimal DMS", "DDD.MMSSsss", "sexagesimal degree DDD.MMSSsss")), UnitDefinition.of(Units.PPM, Collections.emptyList(), "ppm", Collections.emptyList()), UnitDefinition.of(Units.PIXEL, Collections.emptyList(), "pixel", Collections.emptyList()), UnitDefinition.of(USCustomary.GRADE, Collections.emptyList(), "grad", Arrays.asList("grade")), UnitDefinition.of(Units.FOOT_GOLD_COAST, Collections.emptyList(), null, Collections.emptyList()), UnitDefinition.of(USCustomary.FOOT_SURVEY, Collections.emptyList(), "Foot_US", Collections.emptyList()), UnitDefinition.of(NonSI.DEGREE_ANGLE, Collections.emptyList(), "degree", Collections.emptyList()), UnitDefinition.of(USCustomary.FOOT, Collections.emptyList(), "ft", Collections.emptyList()), UnitDefinition.of(Units.METRE, Collections.emptyList(), "Meter", Collections.emptyList()));

    private UnitDefinitions() {
    }

    @SafeVarargs
    private static <T> List<T> listOf(T ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}

