/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jts;

import java.util.ArrayList;
import org.jaitools.numeric.CompareOp;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class Utils {
    private static GeometryFactory geomFactory;

    private Utils() {
    }

    public static GeometryFactory getGeometryFactory() {
        if (geomFactory == null) {
            geomFactory = new GeometryFactory();
        }
        return geomFactory;
    }

    public static GeometryFactory setPrecision(double scale) {
        geomFactory = new GeometryFactory(new PrecisionModel(scale));
        return geomFactory;
    }

    public static LineString removeCollinearVertices(LineString ls) {
        if (ls == null) {
            throw new NullPointerException("The provided linestring is null");
        }
        int N = ls.getNumPoints();
        boolean isLinearRing = ls instanceof LinearRing;
        ArrayList<Coordinate> retain = new ArrayList<Coordinate>();
        retain.add(ls.getCoordinateN(0));
        int i0 = 0;
        int i1 = 1;
        Coordinate firstCoord = ls.getCoordinateN(i0);
        for (int i2 = 2; i2 < N; ++i2) {
            Coordinate midCoord = ls.getCoordinateN(i1);
            Coordinate lastCoord = ls.getCoordinateN(i2);
            double dx1 = midCoord.x - firstCoord.x;
            double dy1 = midCoord.y - firstCoord.y;
            double dx2 = lastCoord.x - midCoord.x;
            double dy2 = lastCoord.y - midCoord.y;
            boolean redundant = false;
            if (CompareOp.isZero(dx1)) {
                if (CompareOp.isZero(dx2) && Math.signum(dy1) == Math.signum(dy2)) {
                    redundant = true;
                }
            } else if (!CompareOp.isZero(dx2) && CompareOp.aequal(dy1 / dx1, dy2 / dx2) && Math.signum(dx1) == Math.signum(dx2)) {
                redundant = true;
            }
            if (!redundant) {
                retain.add(midCoord);
                i0 = i1;
                firstCoord = ls.getCoordinateN(i0);
            }
            ++i1;
        }
        retain.add(ls.getCoordinateN(N - 1));
        int size = retain.size();
        if (size == N) {
            retain.clear();
            return ls;
        }
        return isLinearRing ? ls.getFactory().createLinearRing(retain.toArray(new Coordinate[size])) : ls.getFactory().createLineString(retain.toArray(new Coordinate[size]));
    }

    public static Polygon removeCollinearVertices(Polygon polygon) {
        if (polygon == null) {
            throw new NullPointerException("The provided Polygon is null");
        }
        GeometryFactory gf = polygon.getFactory();
        LinearRing exterior = polygon.getExteriorRing();
        LineString shell = Utils.removeCollinearVertices((LineString)exterior);
        if (shell == null || shell.isEmpty()) {
            return null;
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        int size = polygon.getNumInteriorRing();
        for (int i = 0; i < size; ++i) {
            LinearRing hole = polygon.getInteriorRingN(i);
            if ((hole = Utils.removeCollinearVertices((LineString)hole)) == null || hole.isEmpty()) continue;
            holes.add(hole);
        }
        return gf.createPolygon((LinearRing)shell, holes.toArray(new LinearRing[holes.size()]));
    }

    public static Geometry removeCollinearVertices(Geometry g) {
        if (g == null) {
            throw new NullPointerException("The provided Geometry is null");
        }
        if (g instanceof LineString) {
            return Utils.removeCollinearVertices((LineString)g);
        }
        if (g instanceof Polygon) {
            return Utils.removeCollinearVertices((Polygon)g);
        }
        throw new IllegalArgumentException("This method can work on LineString and Polygon.");
    }
}

