/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapSupplier;
import com.google.debugging.sourcemap.SourceMapping;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

public final class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String contents) throws SourceMapParseException {
        return SourceMapConsumerFactory.parse(contents, null);
    }

    public static SourceMapping parse(String contents, SourceMapSupplier supplier) throws SourceMapParseException {
        if (contents.startsWith("/** Begin line maps. **/")) {
            throw new SourceMapParseException("This appears to be a V1 SourceMap, which is not supported.");
        }
        if (contents.startsWith("{")) {
            try {
                JsonObject sourceMapRoot = (JsonObject)new Gson().fromJson(contents, JsonObject.class);
                int version = sourceMapRoot.get("version").getAsInt();
                switch (version) {
                    case 3: {
                        SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
                        consumer.parse(sourceMapRoot, supplier);
                        return consumer;
                    }
                }
                throw new SourceMapParseException("Unknown source map version:" + version);
            }
            catch (JsonParseException ex) {
                throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)ex));
            }
        }
        throw new SourceMapParseException("unable to detect source map format");
    }
}

