/*
 * Decompiled with CFR 0.152.
 */
package opendap.util.geturl.gui;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import opendap.dap.StatusUI;

public class StatusWindow
extends Frame
implements StatusUI {
    private Label urlLabel;
    private int bytesRead = 0;
    private long startTime;
    private long lastUpdateTime;
    private boolean cancelPushed = false;
    private Label bytesReadLabel;
    private Label transferRateLabel;
    private Button cancelButton;
    NumberFormat nf = NumberFormat.getInstance();

    public StatusWindow(String url) {
        super("Status Window");
        this.setSize(450, 150);
        Label retrievingTag = new Label("Retrieving:");
        this.urlLabel = new Label(url);
        Label bytesReadTag = new Label("Bytes Read:");
        this.bytesReadLabel = new Label("                   ");
        Label transferRateTag = new Label("Transfer Rate:");
        this.transferRateLabel = new Label("                   ");
        this.cancelButton = new Button("Cancel Download");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbl.setConstraints(retrievingTag, gbc);
        this.add(retrievingTag);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.urlLabel, gbc);
        this.add(this.urlLabel);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbl.setConstraints(bytesReadTag, gbc);
        this.add(bytesReadTag);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.bytesReadLabel, gbc);
        this.add(this.bytesReadLabel);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbl.setConstraints(transferRateTag, gbc);
        this.add(transferRateTag);
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.transferRateLabel, gbc);
        this.add(this.transferRateLabel);
        gbc.anchor = 10;
        gbl.setConstraints(this.cancelButton, gbc);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatusWindow.this.programCancel();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                StatusWindow.this.programCancel();
                StatusWindow.this.dispose();
            }
        });
        this.startTime = this.lastUpdateTime = System.currentTimeMillis();
        this.show();
    }

    public void incrementByteCount(int bytes) {
        this.bytesRead += bytes;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 200L) {
            if (this.bytesRead > 0x100000) {
                float MBread = (float)this.bytesRead / 1048576.0f;
                this.bytesReadLabel.setText(this.nf.format(MBread) + " MB");
            } else if (this.bytesRead > 1024) {
                float Kread = (float)this.bytesRead / 1024.0f;
                this.bytesReadLabel.setText(this.nf.format(Kread) + " K");
            } else {
                this.bytesReadLabel.setText(this.nf.format(this.bytesRead));
            }
            this.bytesReadLabel.repaint();
            float bytesPerSecond = (float)this.bytesRead / (float)(currentTime - this.startTime) * 1000.0f;
            if (bytesPerSecond > 1048576.0f) {
                float MBperSecond = bytesPerSecond / 1048576.0f;
                this.transferRateLabel.setText(this.nf.format(MBperSecond) + " MB/sec");
            } else if (bytesPerSecond > 1024.0f) {
                float KperSecond = bytesPerSecond / 1024.0f;
                this.transferRateLabel.setText(this.nf.format(KperSecond) + " K/sec");
            } else {
                this.transferRateLabel.setText(this.nf.format(bytesPerSecond) + "bytes/sec");
            }
            this.transferRateLabel.repaint();
            this.lastUpdateTime = currentTime;
        }
    }

    public synchronized boolean userCancelled() {
        if (this.cancelPushed) {
            this.dispose();
        }
        return this.cancelPushed;
    }

    public void finished() {
        this.dispose();
    }

    public synchronized void programCancel() {
        this.cancelPushed = true;
    }
}

