/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.treeview;

import java.awt.Cursor;
import java.util.Hashtable;
import org.dlib.gui.treeview.TreeViewDndHandler;
import org.dlib.gui.treeview.TreeViewNode;

public class DndRuleManager
implements TreeViewDndHandler {
    private Hashtable htRules = new Hashtable(20, 0.7f);
    private boolean bForceSameParent = false;
    private Cursor noDropCursor;

    public DndRuleManager(Cursor cursor) {
        this.noDropCursor = cursor;
    }

    public void forceSameParent(boolean bl) {
        this.bForceSameParent = bl;
    }

    public void addRule(Class clazz, Class clazz2, int n) {
        Hashtable<Class, Integer> hashtable;
        if (this.htRules.containsKey(clazz)) {
            hashtable = (Hashtable<Class, Integer>)this.htRules.get(clazz);
        } else {
            hashtable = new Hashtable<Class, Integer>(10, 0.7f);
            this.htRules.put(clazz, hashtable);
        }
        hashtable.put(clazz2, new Integer(n));
    }

    public int acceptDrop(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
        if (treeViewNode2 == null) {
            return 0;
        }
        if (!this.htRules.containsKey(treeViewNode.getClass())) {
            return 0;
        }
        Hashtable hashtable = (Hashtable)this.htRules.get(treeViewNode.getClass());
        if (!hashtable.containsKey(treeViewNode2.getClass())) {
            return 0;
        }
        if (this.bForceSameParent && treeViewNode.getParent() != treeViewNode2.getParent()) {
            return 0;
        }
        return (Integer)hashtable.get(treeViewNode2.getClass());
    }

    public void handleDrop(TreeViewNode treeViewNode, TreeViewNode treeViewNode2) {
        Hashtable hashtable = (Hashtable)this.htRules.get(treeViewNode.getClass());
        int n = (Integer)hashtable.get(treeViewNode2.getClass());
        TreeViewNode treeViewNode3 = (TreeViewNode)treeViewNode.getParent();
        TreeViewNode treeViewNode4 = (TreeViewNode)treeViewNode2.getParent();
        if (n == 2) {
            treeViewNode3.removeChild(treeViewNode);
            int n2 = treeViewNode4.getIndex(treeViewNode2);
            treeViewNode4.insertChild(treeViewNode, n2, false);
        } else if (n == 1) {
            treeViewNode3.removeChild(treeViewNode);
            treeViewNode2.addChild(treeViewNode, false);
            if (!treeViewNode2.isExpanded()) {
                treeViewNode2.expand(true);
            }
        } else {
            throw new IllegalArgumentException("Unknown rule --> " + n);
        }
        this.nodeDropped(treeViewNode);
        treeViewNode.select();
    }

    public void nodeDropped(TreeViewNode treeViewNode) {
    }

    public Cursor getNoDropCursor() {
        return this.noDropCursor;
    }
}

