/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.flextable;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.dlib.gui.CustomLook;
import org.dlib.gui.flextable.DefaultFlexTableModel;
import org.dlib.gui.flextable.FlexTableClickListener;
import org.dlib.gui.flextable.FlexTableColumn;
import org.dlib.gui.flextable.FlexTableModel;
import org.dlib.gui.flextable.FlexTableSelEvent;
import org.dlib.gui.flextable.FlexTableSelListener;

public class FlexTable
extends JScrollPane
implements TableModel,
ListSelectionListener,
MouseListener {
    private JTable jTable;
    private boolean bEditable;
    private EventListenerList listList = new EventListenerList();
    private FlexTableModel flexModel = new DefaultFlexTableModel();
    private DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
    static /* synthetic */ Class class$org$dlib$gui$flextable$FlexTableSelListener;
    static /* synthetic */ Class class$org$dlib$gui$flextable$FlexTableClickListener;
    static /* synthetic */ Class class$java$lang$String;

    public FlexTable() {
        this(false);
    }

    public FlexTable(boolean bl) {
        this.bEditable = bl;
        this.jTable = new JTable(this, this.columnModel){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        };
        this.jTable.setSelectionMode(0);
        this.jTable.setSurrendersFocusOnKeystroke(true);
        this.jTable.addMouseListener(this);
        this.jTable.setTableHeader(new JTableHeader(this.columnModel){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        });
        this.setViewportView(this.jTable);
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        InputMap inputMap = new InputMap();
        inputMap.setParent(this.jTable.getInputMap());
        this.jTable.setInputMap(0, inputMap);
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(this.jTable.getActionMap());
        this.jTable.setActionMap(actionMap);
    }

    public void addKeyBinding(KeyStroke keyStroke, Action action) {
        this.jTable.getInputMap().put(keyStroke, action);
        this.jTable.getActionMap().put(action, action);
    }

    public FlexTableModel getFlexModel() {
        return this.flexModel;
    }

    public void setFlexModel(FlexTableModel flexTableModel) {
        this.flexModel = flexTableModel;
        while (this.columnModel.getColumnCount() != 0) {
            this.columnModel.removeColumn(this.columnModel.getColumn(0));
        }
        for (int i = 0; i < this.flexModel.getColumnCount(); ++i) {
            FlexTableColumn flexTableColumn = this.flexModel.getColumnAt(i);
            if (!flexTableColumn.isVisible()) continue;
            flexTableColumn.setModelIndex(i);
            this.columnModel.addColumn(flexTableColumn);
        }
        this.clearSelection();
        this.updateTable();
    }

    public void updateFlexModel() {
        this.setFlexModel(this.flexModel);
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
    }

    public void updateTable() {
        this.jTable.revalidate();
        this.jTable.repaint();
    }

    public void addSelectionListener(FlexTableSelListener flexTableSelListener) {
        this.listList.add(class$org$dlib$gui$flextable$FlexTableSelListener == null ? (class$org$dlib$gui$flextable$FlexTableSelListener = FlexTable.class$("org.dlib.gui.flextable.FlexTableSelListener")) : class$org$dlib$gui$flextable$FlexTableSelListener, flexTableSelListener);
    }

    public void removeSelectionListener(FlexTableSelListener flexTableSelListener) {
        this.listList.remove(class$org$dlib$gui$flextable$FlexTableSelListener == null ? (class$org$dlib$gui$flextable$FlexTableSelListener = FlexTable.class$("org.dlib.gui.flextable.FlexTableSelListener")) : class$org$dlib$gui$flextable$FlexTableSelListener, flexTableSelListener);
    }

    public void addClickListener(FlexTableClickListener flexTableClickListener) {
        this.listList.add(class$org$dlib$gui$flextable$FlexTableClickListener == null ? (class$org$dlib$gui$flextable$FlexTableClickListener = FlexTable.class$("org.dlib.gui.flextable.FlexTableClickListener")) : class$org$dlib$gui$flextable$FlexTableClickListener, flexTableClickListener);
    }

    public void removeClickListener(FlexTableClickListener flexTableClickListener) {
        this.listList.remove(class$org$dlib$gui$flextable$FlexTableClickListener == null ? (class$org$dlib$gui$flextable$FlexTableClickListener = FlexTable.class$("org.dlib.gui.flextable.FlexTableClickListener")) : class$org$dlib$gui$flextable$FlexTableClickListener, flexTableClickListener);
    }

    public void clearSelection() {
        this.jTable.clearSelection();
    }

    public void selectRow(int n) {
        if (this.getRowCount() == 0) {
            return;
        }
        this.jTable.setRowSelectionInterval(n, n);
        this.jTable.scrollRectToVisible(this.jTable.getCellRect(n, 0, true));
    }

    public void selectLastRow() {
        this.selectRow(this.getRowCount() - 1);
    }

    public int getSelectedRow() {
        return this.jTable.getSelectedRow();
    }

    public void setAutoResizeMode(int n) {
        this.jTable.setAutoResizeMode(n);
    }

    public void setShowGrid(boolean bl) {
        this.jTable.setShowGrid(bl);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    public Class getColumnClass(int n) {
        for (int i = 0; i < this.flexModel.getRowCount(); ++i) {
            Object object = this.flexModel.getValueAt(i, n);
            if (object == null) continue;
            return object.getClass();
        }
        return class$java$lang$String == null ? (class$java$lang$String = FlexTable.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.bEditable) {
            return false;
        }
        return ((FlexTableColumn)this.columnModel.getColumn(n2)).isEditable();
    }

    public int getColumnCount() {
        return this.flexModel.getColumnCount();
    }

    public int getRowCount() {
        return this.flexModel.getRowCount();
    }

    public String getColumnName(int n) {
        return (String)this.columnModel.getColumn(n).getHeaderValue();
    }

    public Object getValueAt(int n, int n2) {
        return this.flexModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.flexModel.setValueAt(object, n, n2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.fireSelectionChanged(-1);
        } else {
            this.fireSelectionChanged(listSelectionModel.getMinSelectionIndex());
        }
    }

    private void fireSelectionChanged(int n) {
        Object[] objectArray = this.listList.getListenerList();
        FlexTableSelEvent flexTableSelEvent = new FlexTableSelEvent(this, n);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$dlib$gui$flextable$FlexTableSelListener == null ? FlexTable.class$("org.dlib.gui.flextable.FlexTableSelListener") : class$org$dlib$gui$flextable$FlexTableSelListener)) continue;
            ((FlexTableSelListener)objectArray[i + 1]).rowSelected(flexTableSelEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Point point = mouseEvent.getPoint();
            int n = this.jTable.columnAtPoint(point);
            int n2 = this.jTable.rowAtPoint(point);
            this.fireClickChanged(n, n2);
        }
    }

    private void fireClickChanged(int n, int n2) {
        Object[] objectArray = this.listList.getListenerList();
        FlexTableSelEvent flexTableSelEvent = new FlexTableSelEvent(this, n2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$dlib$gui$flextable$FlexTableClickListener == null ? FlexTable.class$("org.dlib.gui.flextable.FlexTableClickListener") : class$org$dlib$gui$flextable$FlexTableClickListener)) continue;
            ((FlexTableClickListener)objectArray[i + 1]).rowClicked(flexTableSelEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

