/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.output;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.output.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.URIUtils;
import com.github.sommeri.sourcemap.FilePosition;
import com.github.sommeri.sourcemap.SourceMapFormat;
import com.github.sommeri.sourcemap.SourceMapGenerator;
import com.github.sommeri.sourcemap.SourceMapGeneratorFactory;
import java.io.IOException;
import java.util.Collection;

public class SourceMapBuilder {
    private final ExtendedStringBuilder cssBuilder;
    private final SourceMapGenerator generator;
    private final LessCompiler.SourceMapConfiguration configuration;
    private final Collection<LessSource> additionalSourceFiles;
    private LessSource cssDestination;

    public SourceMapBuilder(ExtendedStringBuilder cssBuilder, LessSource cssDestination, Collection<LessSource> additionalSourceFiles, LessCompiler.SourceMapConfiguration configuration) {
        this.cssBuilder = cssBuilder;
        this.cssDestination = cssDestination;
        this.configuration = configuration;
        this.additionalSourceFiles = additionalSourceFiles;
        this.generator = SourceMapGeneratorFactory.getInstance(SourceMapFormat.V3);
    }

    public SourceMapBuilder append(String str, HiddenTokenAwareTree sourceToken) {
        FilePosition outputStartPosition = this.beforeSymbolPosition();
        this.cssBuilder.append(str);
        FilePosition outputEndPosition = this.afterSymbolPosition();
        this.createMapping(str, sourceToken, outputStartPosition, outputEndPosition);
        return this;
    }

    public void appendIgnoreNull(String str, HiddenTokenAwareTree sourceToken) {
        FilePosition outputStartPosition = this.beforeSymbolPosition();
        this.cssBuilder.append(str);
        FilePosition outputEndPosition = this.afterSymbolPosition();
        this.createMapping(str, sourceToken, outputStartPosition, outputEndPosition);
    }

    private void createMapping(String mappedSymbol, HiddenTokenAwareTree sourceToken, FilePosition outputStartPosition, FilePosition outputEndPosition) {
        FilePosition sourceStartPosition = this.toFilePosition(sourceToken);
        String sourceName = this.toSourceName(sourceToken);
        String sourceContent = this.toSourceContent(sourceToken, sourceName);
        this.generator.addMapping(sourceName, sourceContent, mappedSymbol, sourceStartPosition, outputStartPosition, outputEndPosition);
    }

    private FilePosition beforeSymbolPosition() {
        this.cssBuilder.handleIndentation();
        FilePosition outputStartPosition = this.afterSymbolPosition();
        return outputStartPosition;
    }

    private FilePosition afterSymbolPosition() {
        return this.currentPosition();
    }

    private FilePosition currentPosition() {
        return new FilePosition(this.cssBuilder.getLine(), this.cssBuilder.getColumn());
    }

    public void append(SourceMapBuilder other) {
        FilePosition offset = this.afterSymbolPosition();
        this.cssBuilder.appendAsIs(other.cssBuilder.toString());
        SourceMapGenerator otherGenerator = other.generator;
        this.generator.offsetAndAppend(otherGenerator, offset);
    }

    private FilePosition toFilePosition(HiddenTokenAwareTree underlyingStructure) {
        FilePosition result = new FilePosition(underlyingStructure.getLine() - 1, underlyingStructure.getCharPositionInLine());
        return result;
    }

    private String toSourceName(HiddenTokenAwareTree underlyingStructure) {
        LessSource source = underlyingStructure.getSource();
        return this.toSourceName(source);
    }

    private String toSourceName(LessSource source) {
        if (this.configuration.isRelativizePaths()) {
            return URIUtils.relativizeSourceURIs(this.cssDestination, source);
        }
        return source.getURI() == null ? null : source.getURI().toString();
    }

    private String toSourceContent(HiddenTokenAwareTree underlyingStructure, String sourceName) {
        LessSource source = underlyingStructure.getSource();
        return this.toSourceContent(underlyingStructure, sourceName, source);
    }

    private String toSourceContent(HiddenTokenAwareTree underlyingStructure, String sourceName, LessSource source) {
        if (this.configuration.isIncludeSourcesContent() || sourceName == null) {
            try {
                return source.getContent();
            }
            catch (LessSource.FileNotFound e) {
                throw new BugHappened("How did we compiled something we did not read?", underlyingStructure);
            }
            catch (LessSource.CannotReadFile e) {
                throw new BugHappened("How did we compiled something we did not read?", underlyingStructure);
            }
        }
        return null;
    }

    public String toSourceMap() {
        for (LessSource source : this.additionalSourceFiles) {
            String sourceName = this.toSourceName(source);
            String sourceContent = this.toSourceContent(null, sourceName, source);
            this.generator.addSourceFile(sourceName, sourceContent);
        }
        String name = "";
        if (this.cssDestination != null && this.cssDestination.getName() != null) {
            name = this.cssDestination.getName();
        }
        try {
            StringBuilder sb = new StringBuilder();
            this.generator.appendTo(sb, name);
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible to happen exception.", e);
        }
    }

    protected ExtendedStringBuilder getCssBuilder() {
        return this.cssBuilder;
    }

    public void ensureSeparator() {
        this.cssBuilder.ensureSeparator();
    }
}

