/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.SyntaxOnlyElement;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class UnknownAtRule
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private String name;
    private List<Expression> names = new ArrayList<Expression>();
    private GeneralBody body;
    private SyntaxOnlyElement semicolon;

    public UnknownAtRule(HiddenTokenAwareTree token, String name) {
        super(token);
        this.name = name;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    public SyntaxOnlyElement getSemicolon() {
        return this.semicolon;
    }

    public void setSemicolon(SyntaxOnlyElement semicolon) {
        this.semicolon = semicolon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Expression> getNames() {
        return this.names;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(this.names);
        ArraysUtils.addIfNonNull(childs, this.body, this.semicolon);
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.UNKNOWN_AT_RULE;
    }

    @Override
    public UnknownAtRule clone() {
        UnknownAtRule result = (UnknownAtRule)super.clone();
        result.names = ArraysUtils.deeplyClonedList(this.names);
        result.body = this.body == null ? null : this.body.clone();
        result.semicolon = this.semicolon == null ? null : this.semicolon.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public void addNames(List<Expression> names) {
        this.names.addAll(names);
    }
}

