/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader2;

import java.io.InputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.index.bplustree.BPlusTreeRewriter;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.store.bulkloader2.RecordsFromInput;

public class ProcIndexBuild {
    public static void exec(String locationStr, String indexName, String dataFile) {
        int dftValueLength;
        int dftKeyLength;
        String primaryOrder;
        Location location = Location.create(locationStr);
        InputStream input = IO.openFile((String)dataFile);
        int keyLength = 8 * indexName.length();
        boolean valueLength = false;
        String primary = indexName;
        int tupleLength = indexName.length();
        if (tupleLength == 3) {
            primaryOrder = "SPO";
            dftKeyLength = 24;
            dftValueLength = 0;
        } else if (tupleLength == 4) {
            primaryOrder = "GSPO";
            dftKeyLength = 32;
            dftValueLength = 0;
        } else {
            throw new AtlasException("Index name: " + indexName);
        }
        ColumnMap colMap = new ColumnMap(primaryOrder, indexName);
        int readCacheSize = 10;
        int writeCacheSize = 100;
        int blockSize = 8192;
        RecordFactory recordFactory = new RecordFactory(dftKeyLength, dftValueLength);
        int order = BPlusTreeParams.calcOrder(blockSize, recordFactory);
        BPlusTreeParams bptParams = new BPlusTreeParams(order, recordFactory);
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        FileSet destination = new FileSet(location, indexName);
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", blockSizeNodes, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", blockSizeRecords, readCacheSize, writeCacheSize);
        int rowBlock = 1000;
        RecordsFromInput iter = new RecordsFromInput(input, tupleLength, colMap, rowBlock);
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(iter, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
        bpt2.close();
    }
}

