/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;

public class CopyDSG {
    public static void copy(DatasetGraph dsgSrc, DatasetGraph dsgDst) {
        Txn.executeRead((Transactional)dsgSrc, () -> Txn.executeWrite((Transactional)dsgDst, () -> {
            Iterator iter = dsgSrc.find();
            iter.forEachRemaining(arg_0 -> ((DatasetGraph)dsgDst).add(arg_0));
            CopyDSG.copyPrefixes(dsgSrc, dsgDst);
        }));
    }

    public static void copyPrefixes(DatasetGraph dsgSrc, DatasetGraph dsgDst) {
        List graphNames = Iter.toList((Iterator)dsgSrc.listGraphNodes());
        CopyDSG.copyPrefixes(dsgSrc.getDefaultGraph(), dsgDst.getDefaultGraph());
        graphNames.forEach(gn -> CopyDSG.copyPrefixes(dsgSrc.getGraph(gn), dsgDst.getGraph(gn)));
    }

    public static void copyPrefixes(Graph srcGraph, Graph dstGraph) {
        dstGraph.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
    }
}

