/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.ContentPath;

public class MapperBuilderContext {
    public static final MapperBuilderContext ROOT = new MapperBuilderContext(null);
    private final String path;

    public static MapperBuilderContext forPath(ContentPath path) {
        String p = path.pathAsText("");
        if (p.endsWith(".")) {
            p = p.substring(0, p.length() - 1);
        }
        return new MapperBuilderContext(p);
    }

    private MapperBuilderContext(String path) {
        this.path = path;
    }

    public MapperBuilderContext createChildContext(String name) {
        return new MapperBuilderContext(this.buildFullName(name));
    }

    public final String buildFullName(String name) {
        if (Strings.isEmpty(this.path)) {
            return name;
        }
        return this.path + "." + name;
    }
}

