/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.logging.Level;
import java.util.logging.Logger;

class GlobalCBVLSN {
    private final RepImpl repImpl;
    private final Logger logger;
    private final long streamTimeoutMs;
    private volatile VLSN groupCBVLSN = VLSN.NULL_VLSN;
    private int activeSyncups = 0;

    GlobalCBVLSN(RepNode repNode) {
        this.repImpl = repNode.getRepImpl();
        this.streamTimeoutMs = this.repImpl.getConfigManager().getDuration(RepParams.REP_STREAM_TIMEOUT);
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    VLSN getCBVLSN() {
        return this.groupCBVLSN;
    }

    synchronized void syncupStarted() {
        ++this.activeSyncups;
        LoggerUtils.finest(this.logger, this.repImpl, "activeSyncups = " + this.activeSyncups);
    }

    synchronized void syncupEnded() {
        --this.activeSyncups;
        LoggerUtils.finest(this.logger, this.repImpl, "activeSyncups = " + this.activeSyncups);
    }

    long getCleanerBarrierFile() throws DatabaseException {
        if (this.groupCBVLSN.isNull()) {
            return 0L;
        }
        return this.repImpl.getVLSNIndex().getLTEFileNumber(this.groupCBVLSN);
    }

    void recalculate(RepGroupImpl groupInfo) {
        VLSN maxCBVLSN = VLSN.NULL_VLSN;
        long latestBarrierTime = 0L;
        for (RepNodeImpl node : groupInfo.getElectableNodes()) {
            RepGroupImpl.BarrierState nodeBarrier = node.getBarrierState();
            VLSN cbvlsn = nodeBarrier.getLastCBVLSN();
            long nodeBarrierTime = nodeBarrier.getBarrierTime();
            if (maxCBVLSN.compareTo(cbvlsn) > 0) continue;
            latestBarrierTime = cbvlsn.equals(maxCBVLSN) ? Math.min(nodeBarrierTime, latestBarrierTime) : nodeBarrierTime;
            maxCBVLSN = cbvlsn;
        }
        if (latestBarrierTime == 0L) {
            return;
        }
        if (maxCBVLSN.isNull()) {
            return;
        }
        VLSN newGroupCBVLSN = maxCBVLSN;
        for (RepNodeImpl node : groupInfo.getElectableNodes()) {
            RepGroupImpl.BarrierState nodeBarrier = node.getBarrierState();
            VLSN nodeCBVLSN = nodeBarrier.getLastCBVLSN();
            if (latestBarrierTime - nodeBarrier.getBarrierTime() > this.streamTimeoutMs || newGroupCBVLSN.compareTo(nodeCBVLSN) <= 0) continue;
            newGroupCBVLSN = nodeCBVLSN;
        }
        this.updateGroupCBVLSN(groupInfo, newGroupCBVLSN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupCBVLSN(RepGroupImpl groupInfo, VLSN newGroupCBVLSN) {
        boolean changed = false;
        int numGatingSyncups = 0;
        String cbvlsnLoweredMessage = null;
        VLSN oldCBVLSN = VLSN.NULL_VLSN;
        GlobalCBVLSN globalCBVLSN = this;
        synchronized (globalCBVLSN) {
            if (newGroupCBVLSN.compareTo(this.groupCBVLSN) > 0) {
                if (this.activeSyncups == 0) {
                    VLSNRange currentRange = this.repImpl.getVLSNIndex().getRange();
                    if (!currentRange.contains(newGroupCBVLSN) && this.logger.isLoggable(Level.FINE)) {
                        cbvlsnLoweredMessage = "GroupCBVLSN: " + newGroupCBVLSN + " is outside VLSN range: " + currentRange + " Current group:" + groupInfo;
                    } else {
                        oldCBVLSN = this.groupCBVLSN;
                        this.groupCBVLSN = newGroupCBVLSN;
                        changed = true;
                    }
                } else {
                    numGatingSyncups = this.activeSyncups;
                }
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            if (cbvlsnLoweredMessage != null) {
                LoggerUtils.fine(this.logger, this.repImpl, cbvlsnLoweredMessage);
            }
            if (changed) {
                LoggerUtils.fine(this.logger, this.repImpl, "Global CBVLSN changed from " + oldCBVLSN + " to " + newGroupCBVLSN);
            }
            if (numGatingSyncups > 0) {
                LoggerUtils.fine(this.logger, this.repImpl, "Global CBVLSN update gated by " + numGatingSyncups + " syncups");
            }
        }
    }
}

