/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatCollection;
import bak.pcj.adapter.CollectionToFloatCollectionAdapter;
import bak.pcj.adapter.SetToFloatSetAdapter;
import bak.pcj.map.AbstractFloatKeyFloatMap;
import bak.pcj.map.FloatKeyFloatMap;
import bak.pcj.map.FloatKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToFloatKeyFloatMapAdapter
extends AbstractFloatKeyFloatMap
implements FloatKeyFloatMap {
    protected Map map;
    protected Float lastValue;

    public MapToFloatKeyFloatMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToFloatKeyFloatMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(float key) {
        this.lastValue = (Float)this.map.get(new Float(key));
        return this.lastValue != null;
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(new Float(value));
    }

    public FloatKeyFloatMapIterator entries() {
        return new FloatKeyFloatMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToFloatKeyFloatMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public float getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getKey()).floatValue();
            }

            public float getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getValue()).floatValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public float get(float key) {
        Float value = (Float)this.map.get(new Float(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public FloatSet keySet() {
        return new SetToFloatSetAdapter(this.map.keySet());
    }

    public float lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.floatValue();
    }

    public float put(float key, float value) {
        Float oldValue = this.map.put(new Float(key), new Float(value));
        return oldValue == null ? MapDefaults.defaultFloat() : oldValue.floatValue();
    }

    public float remove(float key) {
        Float value = (Float)this.map.remove(new Float(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public int size() {
        return this.map.size();
    }

    public FloatCollection values() {
        return new CollectionToFloatCollectionAdapter(this.map.values());
    }

    public float tget(float key) {
        Float value = (Float)this.map.get(new Float(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.floatValue();
    }

    public boolean validate() {
        return Adapter.isFloatKeyFloatAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

