/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.adapter.SetToFloatSetAdapter;
import bak.pcj.map.AbstractFloatKeyBooleanMap;
import bak.pcj.map.FloatKeyBooleanMap;
import bak.pcj.map.FloatKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToFloatKeyBooleanMapAdapter
extends AbstractFloatKeyBooleanMap
implements FloatKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToFloatKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToFloatKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(float key) {
        this.lastValue = (Boolean)this.map.get(new Float(key));
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public FloatKeyBooleanMapIterator entries() {
        return new FloatKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToFloatKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public float getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getKey()).floatValue();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(float key) {
        Boolean value = (Boolean)this.map.get(new Float(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public FloatSet keySet() {
        return new SetToFloatSetAdapter(this.map.keySet());
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(float key, boolean value) {
        Boolean oldValue = this.map.put(new Float(key), new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(float key) {
        Boolean value = (Boolean)this.map.remove(new Float(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(float key) {
        Boolean value = (Boolean)this.map.get(new Float(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isFloatKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

