/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.SetToCharSetAdapter;
import bak.pcj.map.AbstractCharKeyMap;
import bak.pcj.map.CharKeyMap;
import bak.pcj.map.CharKeyMapIterator;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapToCharKeyMapAdapter
extends AbstractCharKeyMap
implements CharKeyMap {
    protected Map map;

    public MapToCharKeyMapAdapter(Map map) {
        this(map, false);
    }

    public MapToCharKeyMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(char key) {
        return this.map.get(new Character(key)) != null;
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public CharKeyMapIterator entries() {
        return new CharKeyMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToCharKeyMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public char getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getKey()).charValue();
            }

            public Object getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public Object get(char key) {
        return this.map.get(new Character(key));
    }

    public CharSet keySet() {
        return new SetToCharSetAdapter(this.map.keySet());
    }

    public Object put(char key, Object value) {
        return this.map.put(new Character(key), value);
    }

    public Object remove(char key) {
        return this.map.remove(new Character(key));
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean validate() {
        return Adapter.isCharKeyAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

