/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortCollection;
import bak.pcj.adapter.CollectionToShortCollectionAdapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyShortMap;
import bak.pcj.map.ByteKeyShortMap;
import bak.pcj.map.ByteKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyShortMapAdapter
extends AbstractByteKeyShortMap
implements ByteKeyShortMap {
    protected Map map;
    protected Short lastValue;

    public MapToByteKeyShortMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToByteKeyShortMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        this.lastValue = (Short)this.map.get(new Byte(key));
        return this.lastValue != null;
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(new Short(value));
    }

    public ByteKeyShortMapIterator entries() {
        return new ByteKeyShortMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyShortMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public short getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public short get(byte key) {
        Short value = (Short)this.map.get(new Byte(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public short lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public short put(byte key, short value) {
        Short oldValue = this.map.put(new Byte(key), new Short(value));
        return oldValue == null ? MapDefaults.defaultShort() : oldValue;
    }

    public short remove(byte key) {
        Short value = (Short)this.map.remove(new Byte(key));
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ShortCollection values() {
        return new CollectionToShortCollectionAdapter(this.map.values());
    }

    public short tget(byte key) {
        Short value = (Short)this.map.get(new Byte(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isByteKeyShortAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

