/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.translations.libretranslate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.translations.libretranslate.LibreTranslateClientException;
import org.fao.geonet.translations.libretranslate.LibreTranslateErrorResponse;
import org.fao.geonet.translations.libretranslate.LibreTranslateResponse;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.json.JSONObject;
import org.springframework.http.client.ClientHttpResponse;

public class LibreTranslateClient {
    private static final String LOGGER_NAME = "geonetwork.translate";
    private final String serviceUrl;
    private final String apiKey;
    private final GeonetHttpRequestFactory requestFactory;

    public LibreTranslateClient(String serviceUrl, String apiKey) {
        this.serviceUrl = serviceUrl;
        this.apiKey = apiKey;
        this.requestFactory = (GeonetHttpRequestFactory)ApplicationContextHolder.get().getBean(GeonetHttpRequestFactory.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LibreTranslateResponse translate(String text, String fromLanguage, String toLanguage) throws LibreTranslateClientException {
        HttpPost postMethod = new HttpPost(this.serviceUrl);
        postMethod.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
        postMethod.addHeader((Header)new BasicHeader("Accept", "application/json"));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("q", (Object)text);
        jsonObject.put("source", (Object)fromLanguage);
        jsonObject.put("target", (Object)toLanguage);
        jsonObject.put("format", (Object)"text");
        jsonObject.put("api_key", (Object)this.apiKey);
        StringEntity entity = new StringEntity(jsonObject.toString(), StandardCharsets.UTF_8.name());
        postMethod.setEntity((HttpEntity)entity);
        try (ClientHttpResponse httpResponse = this.executeRequest((HttpUriRequest)postMethod);){
            int status = httpResponse.getRawStatusCode();
            Log.debug((String)LOGGER_NAME, (Object)("   -- Request status code: " + status));
            String responseBody = IOUtils.toString((InputStream)httpResponse.getBody(), (Charset)StandardCharsets.UTF_8);
            ObjectMapper mapper = new ObjectMapper();
            if (status != 200) {
                LibreTranslateErrorResponse errorMessage = (LibreTranslateErrorResponse)mapper.readValue(responseBody, LibreTranslateErrorResponse.class);
                String message = String.format("Failed to create translate text '%s' from '%s' to '%s'. Status is %d. Error is %s. Response body: %s", text, fromLanguage, toLanguage, status, httpResponse.getStatusText(), errorMessage.getError());
                Log.info((String)LOGGER_NAME, (Object)message);
                throw new LibreTranslateClientException(message);
            }
            LibreTranslateResponse libreTranslateResponse = (LibreTranslateResponse)mapper.readValue(responseBody, LibreTranslateResponse.class);
            return libreTranslateResponse;
        }
        catch (LibreTranslateClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Log.error((String)LOGGER_NAME, (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
            throw new LibreTranslateClientException(ex.getMessage(), ex);
        }
    }

    protected ClientHttpResponse executeRequest(HttpUriRequest method) throws IOException {
        final String requestHost = method.getURI().getHost();
        Function<HttpClientBuilder, Void> requestConfiguration = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                Lib.net.setupProxy((SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class), input, requestHost);
                input.useSystemProperties();
                return null;
            }
        };
        return this.requestFactory.execute(method, (Function)requestConfiguration);
    }
}

