/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.Name;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.ldap.ppolicy.PasswordPolicyData;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.util.Assert;

public class LdapUserDetailsImpl
implements LdapUserDetails,
PasswordPolicyData {
    private static final long serialVersionUID = 570L;
    private String dn;
    private String password;
    private String username;
    private Collection<GrantedAuthority> authorities = AuthorityUtils.NO_AUTHORITIES;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;
    private int timeBeforeExpiration = Integer.MAX_VALUE;
    private int graceLoginsRemaining = Integer.MAX_VALUE;

    protected LdapUserDetailsImpl() {
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public String getDn() {
        return this.dn;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    @Override
    public int getTimeBeforeExpiration() {
        return this.timeBeforeExpiration;
    }

    @Override
    public int getGraceLoginsRemaining() {
        return this.graceLoginsRemaining;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LdapUserDetailsImpl) {
            return this.dn.equals(((LdapUserDetailsImpl)obj).dn);
        }
        return false;
    }

    public int hashCode() {
        return this.dn.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append("Dn=").append(this.dn).append("; ");
        sb.append("Username=").append(this.username).append("; ");
        sb.append("Password=[PROTECTED]; ");
        sb.append("Enabled=").append(this.enabled).append("; ");
        sb.append("AccountNonExpired=").append(this.accountNonExpired).append("; ");
        sb.append("CredentialsNonExpired=").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked=").append(this.accountNonLocked).append("; ");
        sb.append("Granted Authorities=").append(this.getAuthorities());
        sb.append("]");
        return sb.toString();
    }

    public static class Essence {
        protected LdapUserDetailsImpl instance = this.createTarget();
        private List<GrantedAuthority> mutableAuthorities = new ArrayList<GrantedAuthority>();

        public Essence() {
        }

        public Essence(DirContextOperations ctx) {
            this.setDn(ctx.getDn());
        }

        public Essence(LdapUserDetails copyMe) {
            this.setDn(copyMe.getDn());
            this.setUsername(copyMe.getUsername());
            this.setPassword(copyMe.getPassword());
            this.setEnabled(copyMe.isEnabled());
            this.setAccountNonExpired(copyMe.isAccountNonExpired());
            this.setCredentialsNonExpired(copyMe.isCredentialsNonExpired());
            this.setAccountNonLocked(copyMe.isAccountNonLocked());
            this.setAuthorities(copyMe.getAuthorities());
        }

        protected LdapUserDetailsImpl createTarget() {
            return new LdapUserDetailsImpl();
        }

        public void addAuthority(GrantedAuthority a) {
            if (!this.hasAuthority(a)) {
                this.mutableAuthorities.add(a);
            }
        }

        private boolean hasAuthority(GrantedAuthority a) {
            for (GrantedAuthority authority : this.mutableAuthorities) {
                if (!authority.equals(a)) continue;
                return true;
            }
            return false;
        }

        public LdapUserDetails createUserDetails() {
            Assert.notNull((Object)this.instance, (String)"Essence can only be used to create a single instance");
            Assert.notNull((Object)this.instance.username, (String)"username must not be null");
            Assert.notNull((Object)this.instance.getDn(), (String)"Distinguished name must not be null");
            this.instance.authorities = Collections.unmodifiableList(this.mutableAuthorities);
            LdapUserDetailsImpl newInstance = this.instance;
            this.instance = null;
            return newInstance;
        }

        public Collection<GrantedAuthority> getGrantedAuthorities() {
            return this.mutableAuthorities;
        }

        public void setAccountNonExpired(boolean accountNonExpired) {
            this.instance.accountNonExpired = accountNonExpired;
        }

        public void setAccountNonLocked(boolean accountNonLocked) {
            this.instance.accountNonLocked = accountNonLocked;
        }

        public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
            this.mutableAuthorities = new ArrayList<GrantedAuthority>();
            this.mutableAuthorities.addAll(authorities);
        }

        public void setCredentialsNonExpired(boolean credentialsNonExpired) {
            this.instance.credentialsNonExpired = credentialsNonExpired;
        }

        public void setDn(String dn) {
            this.instance.dn = dn;
        }

        public void setDn(Name dn) {
            this.instance.dn = dn.toString();
        }

        public void setEnabled(boolean enabled) {
            this.instance.enabled = enabled;
        }

        public void setPassword(String password) {
            this.instance.password = password;
        }

        public void setUsername(String username) {
            this.instance.username = username;
        }

        public void setTimeBeforeExpiration(int timeBeforeExpiration) {
            this.instance.timeBeforeExpiration = timeBeforeExpiration;
        }

        public void setGraceLoginsRemaining(int graceLoginsRemaining) {
            this.instance.graceLoginsRemaining = graceLoginsRemaining;
        }
    }
}

