/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.SemanticType;

public class StyleGenerator {
    private static final Logger LOGGER = Logging.getLogger(StyleGenerator.class);
    public static final int ELSEMODE_IGNORE = 0;
    public static final int ELSEMODE_INCLUDEASMIN = 1;
    public static final int ELSEMODE_INCLUDEASMAX = 2;
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private static StyleBuilder sb = new StyleBuilder(sf, ff);

    protected StyleGenerator() {
    }

    private static Color getColor(int elseMode, Color[] colors, int index) {
        if (elseMode == 0) {
            return colors[index];
        }
        if (elseMode == 1) {
            return colors[index + 1];
        }
        if (elseMode == 2) {
            return colors[index];
        }
        return null;
    }

    private static Color getElseColor(int elseMode, Color[] colors) {
        if (elseMode == 1) {
            return colors[0];
        }
        if (elseMode == 2) {
            return colors[colors.length - 1];
        }
        return null;
    }

    public static FeatureTypeStyle createFeatureTypeStyle(Classifier classifier, Expression expression, Color[] colors, String typeId, GeometryDescriptor geometryAttrType, int elseMode, double opacity, Stroke defaultStroke) throws IllegalFilterException {
        if (defaultStroke == null) {
            defaultStroke = sb.createStroke();
        }
        FeatureTypeStyle fts = sf.createFeatureTypeStyle();
        if (classifier instanceof RangedClassifier) {
            RangedClassifier ranged = (RangedClassifier)classifier;
            Object localMin = null;
            Object localMax = null;
            for (int i = 0; i < ranged.getSize(); ++i) {
                localMin = ranged.getMin(i);
                localMax = ranged.getMax(i);
                Rule rule = StyleGenerator.createRuleRanged(ranged, expression, localMin, localMax, geometryAttrType, i, elseMode, colors, opacity, defaultStroke);
                fts.rules().add(rule);
            }
        } else if (classifier instanceof ExplicitClassifier) {
            ExplicitClassifier explicit = (ExplicitClassifier)classifier;
            for (int i = 0; i < explicit.getSize(); ++i) {
                Set value = explicit.getValues(i);
                Rule rule = StyleGenerator.createRuleExplicit(explicit, expression, value, geometryAttrType, i, elseMode, colors, opacity, defaultStroke);
                fts.rules().add(rule);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Error: no handler for this Classifier type");
        }
        if (elseMode != 0) {
            Symbolizer symb = StyleGenerator.createSymbolizer(geometryAttrType, StyleGenerator.getElseColor(elseMode, colors), opacity, defaultStroke);
            Rule elseRule = sb.createRule(symb);
            elseRule.setElseFilter(true);
            elseRule.getDescription().setTitle("Else");
            elseRule.setName("else");
            fts.rules().add(elseRule);
        }
        Set semanticTypes = fts.semanticTypeIdentifiers();
        semanticTypes.add(SemanticType.valueOf((String)"generic:geometry"));
        semanticTypes.add(SemanticType.valueOf((String)("colorbrewer:" + typeId)));
        return fts;
    }

    private static Symbolizer createSymbolizer(GeometryDescriptor geometryAttrType, Color color, double opacity, Stroke defaultStroke) {
        Symbolizer symb;
        if (defaultStroke == null) {
            defaultStroke = sb.createStroke(color, 1.0, opacity);
        }
        if (geometryAttrType.getType().getBinding() == MultiPolygon.class || geometryAttrType.getType().getBinding() == Polygon.class) {
            Fill fill = sb.createFill(color, opacity);
            symb = sb.createPolygonSymbolizer(defaultStroke, fill);
        } else if (geometryAttrType.getType().getBinding() == LineString.class) {
            symb = sb.createLineSymbolizer(color);
        } else if (geometryAttrType.getType().getBinding() == MultiPoint.class || geometryAttrType.getType().getBinding() == Point.class) {
            Fill fill = sb.createFill(color, opacity);
            Mark square = sb.createMark("square", fill, defaultStroke);
            Graphic graphic = sb.createGraphic(null, square, null);
            symb = sb.createPointSymbolizer(graphic);
        } else {
            symb = sb.createLineSymbolizer(color);
        }
        return symb;
    }

    private static Object chopInteger(Object value) {
        if (value instanceof Number && value.toString().endsWith(".0")) {
            return ((Number)value).intValue();
        }
        return value;
    }

    private static String getRuleName(int count) {
        String strVal = String.valueOf(count);
        if (strVal.length() == 1) {
            return "rule0" + strVal;
        }
        return "rule" + strVal;
    }

    private static Rule createRuleRanged(RangedClassifier classifier, Expression expression, Object localMin, Object localMax, GeometryDescriptor geometryAttrType, int i, int elseMode, Color[] colors, double opacity, Stroke defaultStroke) throws IllegalFilterException {
        localMin = StyleGenerator.chopInteger(localMin);
        localMax = StyleGenerator.chopInteger(localMax);
        String title = classifier.getTitle(i);
        PropertyIsEqualTo filter = null;
        if (localMin == localMax) {
            filter = ff.equals(expression, (Expression)ff.literal(localMax));
        } else {
            PropertyIsGreaterThanOrEqualTo lowBoundFilter = null;
            Object hiBoundFilter = null;
            if (localMin != null) {
                lowBoundFilter = ff.greaterOrEqual(expression, (Expression)ff.literal(localMin));
            }
            if (localMax != null) {
                hiBoundFilter = i == classifier.getSize() - 1 ? ff.lessOrEqual(expression, (Expression)ff.literal(localMax)) : ff.less(expression, (Expression)ff.literal(localMax));
            }
            if (localMin != null && localMax != null) {
                filter = ff.and((Filter)lowBoundFilter, hiBoundFilter);
            } else if (localMin == null && localMax != null) {
                filter = hiBoundFilter;
            } else if (localMin != null && localMax == null) {
                filter = lowBoundFilter;
            }
        }
        Symbolizer symb = StyleGenerator.createSymbolizer(geometryAttrType, StyleGenerator.getColor(elseMode, colors, i), opacity, defaultStroke);
        Rule rule = sb.createRule(symb);
        rule.setFilter((Filter)filter);
        rule.getDescription().setTitle(title);
        rule.setName(StyleGenerator.getRuleName(i + 1));
        return rule;
    }

    private static Rule createRuleExplicit(ExplicitClassifier explicit, Expression expression, Set value, GeometryDescriptor geometryAttrType, int i, int elseMode, Color[] colors, double opacity, Stroke defaultStroke) {
        Object[] items = value.toArray();
        Arrays.sort(items);
        String title = "";
        ArrayList<PropertyIsNull> filters = new ArrayList<PropertyIsNull>();
        for (int item = 0; item < items.length; ++item) {
            Object filter = items[item] == null ? ff.isNull(expression) : ff.equals(expression, (Expression)ff.literal(items[item]));
            title = items[item] == null ? title + "NULL" : title + items[item].toString();
            if (item + 1 != items.length) {
                title = title + ", ";
            }
            filters.add((PropertyIsNull)filter);
        }
        Symbolizer symb = StyleGenerator.createSymbolizer(geometryAttrType, StyleGenerator.getColor(elseMode, colors, i), opacity, defaultStroke);
        Rule rule = sb.createRule(symb);
        if (filters.size() == 1) {
            rule.setFilter((Filter)filters.get(0));
        } else if (filters.size() > 1) {
            rule.setFilter((Filter)ff.or(filters));
        }
        rule.getDescription().setTitle(title);
        rule.setName(StyleGenerator.getRuleName(i + 1));
        return rule;
    }

    public static void modifyFTS(FeatureTypeStyle fts, int ruleIndex, String styleExpression) throws IllegalFilterException {
        Rule thisRule = fts.rules().get(ruleIndex);
        Filter filter = thisRule.getFilter();
        if (filter instanceof And) {
            String[] newValue = styleExpression.split("\\.\\.");
            if (newValue.length != 2) {
                throw new IllegalArgumentException("StyleExpression has incorrect syntax; min..max expected.");
            }
            List children = ((BinaryLogicOperator)filter).getChildren();
            if (children.size() > 2) {
                throw new IllegalArgumentException("This method currently only supports logical filters with exactly 2 children.");
            }
            PropertyIsGreaterThanOrEqualTo filter1 = (PropertyIsGreaterThanOrEqualTo)children.get(0);
            BinaryComparisonOperator filter2 = (BinaryComparisonOperator)children.get(1);
            if (!filter1.getExpression2().equals(filter2.getExpression1())) {
                throw new IllegalArgumentException("Subfilters or subExpressions in incorrect order");
            }
            if (!filter1.getExpression1().toString().equals(newValue[0])) {
                filter1 = ff.greaterOrEqual(filter1.getExpression1(), (Expression)ff.literal((Object)newValue[0]));
            }
            if (!filter2.getExpression2().toString().equals(newValue[1])) {
                if (filter2 instanceof PropertyIsLessThan) {
                    filter2 = ff.less(filter1.getExpression1(), (Expression)ff.literal((Object)newValue[1]));
                } else if (filter2 instanceof PropertyIsLessThanOrEqualTo) {
                    filter2 = ff.lessOrEqual(filter1.getExpression1(), (Expression)ff.literal((Object)newValue[1]));
                } else {
                    throw new IllegalArgumentException("Filter 2 in the comparison is not less or less or equal??");
                }
            }
            thisRule.setFilter(filter);
        } else if (filter instanceof Or || filter instanceof PropertyIsEqualTo) {
            Expression attrExpression = filter instanceof Or ? ((BinaryComparisonOperator)((Or)filter).getChildren().get(0)).getExpression1() : ((PropertyIsEqualTo)filter).getExpression1();
            thisRule.setFilter(StyleGenerator.toExplicitFilter(styleExpression, attrExpression));
        } else {
            throw new IllegalArgumentException("Unrecognized filter type.");
        }
    }

    public static String toStyleExpression(Filter filter) {
        if (filter instanceof And) {
            return StyleGenerator.toRangedStyleExpression(filter);
        }
        return StyleGenerator.toExplicitStyleExpression(filter);
    }

    public static String[] toStyleExpression(Filter[] filter) {
        String[] styleExpression = new String[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            styleExpression[i] = StyleGenerator.toStyleExpression(filter[i]);
        }
        return styleExpression;
    }

    public static Filter[] toFilter(String[] styleExpression, SimpleFeatureType[] featureType, String[] attributeTypeName) throws IllegalFilterException {
        int i;
        Filter[] filter = new Filter[styleExpression.length];
        boolean[] isRangedExpr = new boolean[styleExpression.length];
        ArrayList<String> min = new ArrayList<String>();
        String[] max = new String[styleExpression.length];
        for (i = 0; i < styleExpression.length; ++i) {
            if (StyleGenerator.isRanged(styleExpression[i])) {
                isRangedExpr[i] = true;
                String[] exprPart = styleExpression[i].split("\\.\\.");
                min.add(exprPart[0]);
                max[i] = exprPart[1];
                continue;
            }
            isRangedExpr[i] = false;
        }
        for (i = 0; i < styleExpression.length; ++i) {
            if (isRangedExpr[i]) {
                boolean upperBoundClosed = true;
                if (min.contains(max[i])) {
                    upperBoundClosed = false;
                }
                filter[i] = StyleGenerator.toRangedFilter(styleExpression[i], featureType[i], attributeTypeName[i], upperBoundClosed);
                continue;
            }
            filter[i] = StyleGenerator.toExplicitFilter(styleExpression[i], featureType[i], attributeTypeName[i]);
        }
        return filter;
    }

    public static Filter toRangedFilter(String styleExpression, SimpleFeatureType featureType, String attributeTypeName, boolean upperBoundClosed) throws IllegalFilterException {
        PropertyName attrib = ff.property(attributeTypeName);
        String[] strs = styleExpression.split("\\.\\.");
        if (strs.length != 2) {
            throw new IllegalArgumentException("A ranged filter could not be created from the styleExpression given.");
        }
        Literal localMin = ff.literal((Object)strs[0]);
        Literal localMax = ff.literal((Object)strs[1]);
        PropertyIsLessThanOrEqualTo lowerBound = ff.lessOrEqual((Expression)localMin, (Expression)localMax);
        Object upperBound = upperBoundClosed ? ff.lessOrEqual((Expression)attrib, (Expression)localMax) : ff.less((Expression)attrib, (Expression)localMax);
        return ff.and((Filter)lowerBound, (Filter)upperBound);
    }

    private static String toRangedStyleExpression(Filter filter) {
        if (filter instanceof BinaryLogicOperator) {
            Expression max2;
            Expression min2;
            Expression max1;
            Expression min1;
            BinaryLogicOperator lFilter = (BinaryLogicOperator)filter;
            if (!(filter instanceof And)) {
                throw new IllegalArgumentException("Only logic filters constructed using the LOGIC_AND filterType are currently supported by this method.");
            }
            List children = lFilter.getChildren();
            Filter filter1 = (Filter)children.get(0);
            Filter filter2 = (Filter)children.get(1);
            if (children.size() > 2) {
                throw new IllegalArgumentException("This method currently only supports logical filters with exactly 2 children.");
            }
            if (!(filter1 instanceof BinaryComparisonOperator) || !(filter2 instanceof BinaryComparisonOperator)) {
                throw new IllegalArgumentException("Only compare filters as logical filter children are currently supported by this method.");
            }
            if (filter1 instanceof PropertyIsLessThanOrEqualTo || filter1 instanceof PropertyIsLessThan) {
                min1 = ((BinaryComparisonOperator)filter1).getExpression1();
                max1 = ((BinaryComparisonOperator)filter1).getExpression2();
            } else if (filter1 instanceof PropertyIsGreaterThanOrEqualTo || filter1 instanceof PropertyIsGreaterThan) {
                min1 = ((BinaryComparisonOperator)filter1).getExpression2();
                max1 = ((BinaryComparisonOperator)filter1).getExpression1();
            } else {
                throw new IllegalArgumentException("Unsupported FilterType");
            }
            if (filter2 instanceof PropertyIsLessThanOrEqualTo || filter2 instanceof PropertyIsLessThan) {
                min2 = ((BinaryComparisonOperator)filter2).getExpression1();
                max2 = ((BinaryComparisonOperator)filter2).getExpression2();
            } else if (filter2 instanceof PropertyIsGreaterThanOrEqualTo || filter2 instanceof PropertyIsGreaterThan) {
                min2 = ((BinaryComparisonOperator)filter2).getExpression2();
                max2 = ((BinaryComparisonOperator)filter2).getExpression1();
            } else {
                throw new IllegalArgumentException("Unsupported FilterType");
            }
            if (max1.equals(min2)) {
                return min1.toString() + ".." + max2.toString();
            }
            if (max2.equals(min1)) {
                return min2.toString() + ".." + max1.toString();
            }
            throw new IllegalArgumentException("Couldn't find the expected arrangement of Expressions");
        }
        throw new UnsupportedOperationException("Don't know how to handle this filter");
    }

    public static boolean isRanged(String styleExpression) {
        return styleExpression.matches(".+\\.{2}.+");
    }

    public static Filter toExplicitFilter(String styleExpression, SimpleFeatureType featureType, String attributeTypeName) throws IllegalFilterException {
        String expr = styleExpression.replaceAll(",\\s+", ",");
        String[] attribValue = expr.split(",");
        PropertyName attribExpr = ff.property(attributeTypeName);
        PropertyIsEqualTo cFilter = ff.equals((Expression)attribExpr, (Expression)ff.literal((Object)attribValue[0]));
        if (attribValue.length == 1) {
            return cFilter;
        }
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        filters.add(cFilter);
        for (int i = 1; i < attribValue.length; ++i) {
            cFilter = ff.equals((Expression)attribExpr, (Expression)ff.literal((Object)attribValue[i]));
            filters.add(cFilter);
        }
        return ff.or(filters);
    }

    public static Filter toExplicitFilter(String styleExpression, Expression attribExpr) throws IllegalFilterException {
        String expr = styleExpression.replaceAll(",\\s+", ",");
        String[] attribValue = expr.split(",");
        PropertyIsEqualTo cFilter = ff.equals(attribExpr, (Expression)ff.literal((Object)attribValue[0]));
        if (attribValue.length == 1) {
            return cFilter;
        }
        ArrayList<PropertyIsEqualTo> filters = new ArrayList<PropertyIsEqualTo>();
        filters.add(cFilter);
        for (int i = 1; i < attribValue.length; ++i) {
            cFilter = ff.equals(attribExpr, (Expression)ff.literal((Object)attribValue[i]));
            filters.add(cFilter);
        }
        return ff.or(filters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String toExplicitStyleExpression(Filter filter) {
        String styleExpression = "";
        if (filter instanceof PropertyIsEqualTo) {
            PropertyIsEqualTo compareFilter = (PropertyIsEqualTo)filter;
            Expression leftExpression = compareFilter.getExpression1();
            Expression rightExpression = compareFilter.getExpression2();
            if (leftExpression instanceof PropertyName && rightExpression instanceof Literal) {
                return rightExpression.toString();
            }
            if (!(leftExpression instanceof Literal)) throw new IllegalArgumentException("Could not extract an Explicit Style Expression from the CompareFilter");
            if (!(rightExpression instanceof PropertyName)) throw new IllegalArgumentException("Could not extract an Explicit Style Expression from the CompareFilter");
            return leftExpression.toString();
        }
        if (!(filter instanceof Or)) return styleExpression;
        Or parentFilter = (Or)filter;
        Iterator iterator = parentFilter.getChildren().iterator();
        while (iterator.hasNext()) {
            styleExpression = styleExpression + StyleGenerator.toExplicitStyleExpression((Filter)iterator.next());
            if (!iterator.hasNext()) continue;
            styleExpression = styleExpression + ", ";
        }
        return styleExpression;
    }
}

