/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.Parser;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class NTriplesParser
implements Parser {
    private StatementHandler _statementHandler;
    private ParseErrorListener _errListener;
    private ParseLocationListener _locListener;
    private Reader _reader;
    private int _lineNo;
    private ValueFactory _valFactory;
    private Map _bNodeIdMap;
    private Resource _subject;
    private URI _predicate;
    private Value _object;
    private int _datatypeHandling;
    boolean _preserveBNodeIds = false;

    public NTriplesParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public NTriplesParser(ValueFactory valueFactory) {
        this._valFactory = valueFactory;
        this._bNodeIdMap = new HashMap();
        this._datatypeHandling = 20;
    }

    public synchronized void setStatementHandler(StatementHandler sh) {
        this._statementHandler = sh;
    }

    public synchronized void setParseErrorListener(ParseErrorListener el) {
        this._errListener = el;
    }

    public synchronized void setParseLocationListener(ParseLocationListener el) {
        this._locListener = el;
    }

    public void setNamespaceListener(NamespaceListener nl) {
    }

    public synchronized void setVerifyData(boolean verifyData) {
    }

    public void setPreserveBNodeIds(boolean preserveBNodeIds) {
        this._preserveBNodeIds = preserveBNodeIds;
    }

    public synchronized void setStopAtFirstError(boolean stopAtFirstError) {
    }

    public void setDatatypeHandling(int datatypeHandling) {
        this._datatypeHandling = datatypeHandling;
    }

    public synchronized void parse(InputStream in, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader(in, "US-ASCII"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(Reader reader, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        this._reader = reader;
        this._lineNo = 1;
        if (this._locListener != null) {
            this._locListener.parseLocationUpdate(this._lineNo, 1);
        }
        try {
            int c = this._reader.read();
            c = this._skipWhitespace(c);
            while (c != -1) {
                c = c == 35 ? this._skipLine(c) : (c == 13 || c == 10 ? this._skipLine(c) : this._parseTriple(c));
                c = this._skipWhitespace(c);
            }
        }
        finally {
            this._bNodeIdMap.clear();
        }
    }

    private int _skipWhitespace(int c) throws IOException {
        while (c == 32 || c == 9) {
            c = this._reader.read();
        }
        return c;
    }

    private int _skipLine(int c) throws IOException {
        while (c != -1 && c != 13 && c != 10) {
            c = this._reader.read();
        }
        if (c == 10) {
            c = this._reader.read();
            ++this._lineNo;
            if (this._locListener != null) {
                this._locListener.parseLocationUpdate(this._lineNo, 1);
            }
        } else if (c == 13) {
            c = this._reader.read();
            if (c == 10) {
                c = this._reader.read();
            }
            ++this._lineNo;
            if (this._locListener != null) {
                this._locListener.parseLocationUpdate(this._lineNo, 1);
            }
        }
        return c;
    }

    private int _parseTriple(int c) throws IOException, ParseException, StatementHandlerException {
        c = this._parseSubject(c);
        c = this._skipWhitespace(c);
        c = this._parsePredicate(c);
        c = this._skipWhitespace(c);
        c = this._parseObject(c);
        if ((c = this._skipWhitespace(c)) == -1) {
            this._throwEOFException();
        } else if (c != 46) {
            this._throwParseException("Expected '.', found: " + (char)c);
        }
        c = this._skipLine(c);
        this._statementHandler.handleStatement(this._subject, this._predicate, this._object);
        this._subject = null;
        this._predicate = null;
        this._object = null;
        return c;
    }

    private int _parseSubject(int c) throws IOException, ParseException {
        StringBuffer buf = new StringBuffer(100);
        if (c == 60) {
            c = this._parseUriRef(c, buf);
            this._subject = this._createURI(buf.toString());
        } else if (c == 95) {
            c = this._parseNodeID(c, buf);
            this._subject = this._createBNode(buf.toString());
        } else if (c == -1) {
            this._throwEOFException();
        } else {
            this._throwParseException("Expected '<' or '_', found: " + (char)c);
        }
        return c;
    }

    private int _parsePredicate(int c) throws IOException, ParseException {
        StringBuffer buf = new StringBuffer(100);
        if (c == 60) {
            c = this._parseUriRef(c, buf);
            this._predicate = this._createURI(buf.toString());
        } else if (c == -1) {
            this._throwEOFException();
        } else {
            this._throwParseException("Expected '<', found: " + (char)c);
        }
        return c;
    }

    private int _parseObject(int c) throws IOException, ParseException {
        StringBuffer buf = new StringBuffer(100);
        if (c == 60) {
            c = this._parseUriRef(c, buf);
            this._object = this._createURI(buf.toString());
        } else if (c == 95) {
            c = this._parseNodeID(c, buf);
            this._object = this._createBNode(buf.toString());
        } else if (c == 34) {
            StringBuffer lang = new StringBuffer(8);
            StringBuffer datatype = new StringBuffer(40);
            c = this._parseLiteral(c, buf, lang, datatype);
            this._object = this._createLiteral(buf.toString(), lang.toString(), datatype.toString());
        } else if (c == -1) {
            this._throwEOFException();
        } else {
            this._throwParseException("Expected '<', '_' or '\"', found: " + (char)c);
        }
        return c;
    }

    private int _parseUriRef(int c, StringBuffer uriRef) throws IOException, ParseException {
        c = this._reader.read();
        while (c != 62) {
            if (c == -1) {
                this._throwEOFException();
            }
            uriRef.append((char)c);
            c = this._reader.read();
        }
        c = this._reader.read();
        return c;
    }

    private int _parseNodeID(int c, StringBuffer name) throws IOException, ParseException {
        c = this._reader.read();
        if (c == -1) {
            this._throwEOFException();
        } else if (c != 58) {
            this._throwParseException("Expected ':', found: " + (char)c);
        }
        c = this._reader.read();
        if (c == -1) {
            this._throwEOFException();
        } else if (!NTriplesUtil.isLetter(c)) {
            this._throwParseException("Expected a letter, found: " + (char)c);
        }
        name.append((char)c);
        c = this._reader.read();
        while (c != -1 && NTriplesUtil.isLetterOrNumber(c)) {
            name.append((char)c);
            c = this._reader.read();
        }
        return c;
    }

    private int _parseLiteral(int c, StringBuffer value, StringBuffer lang, StringBuffer datatype) throws IOException, ParseException {
        c = this._reader.read();
        while (c != 34) {
            if (c == -1) {
                this._throwEOFException();
            }
            value.append((char)c);
            if (c == 92) {
                c = this._reader.read();
                if (c == -1) {
                    this._throwEOFException();
                }
                value.append((char)c);
            }
            c = this._reader.read();
        }
        c = this._reader.read();
        if (c == 64) {
            c = this._reader.read();
            while (c != -1 && c != 46 && c != 94 && c != 32 && c != 9) {
                lang.append((char)c);
                c = this._reader.read();
            }
        } else if (c == 94) {
            c = this._reader.read();
            if (c == -1) {
                this._throwEOFException();
            } else if (c != 94) {
                this._throwParseException("Expected '^', found: " + (char)c);
            }
            c = this._reader.read();
            if (c == -1) {
                this._throwEOFException();
            } else if (c != 60) {
                this._throwParseException("Expected '<', found: " + (char)c);
            }
            c = this._parseUriRef(c, datatype);
        }
        return c;
    }

    private URI _createURI(String uri) throws ParseException {
        try {
            uri = NTriplesUtil.unescapeString(uri);
        }
        catch (IllegalArgumentException e) {
            this._throwParseException(e.getMessage());
        }
        try {
            return this._valFactory.createURI(uri);
        }
        catch (Exception e) {
            this._throwParseException(e);
            return null;
        }
    }

    private BNode _createBNode(String nodeID) throws ParseException {
        BNode result = (BNode)this._bNodeIdMap.get(nodeID);
        if (result == null) {
            try {
                result = this._preserveBNodeIds ? this._valFactory.createBNode(nodeID) : this._valFactory.createBNode();
            }
            catch (Exception e) {
                this._throwParseException(e);
            }
            this._bNodeIdMap.put(nodeID, result);
        }
        return result;
    }

    private Literal _createLiteral(String label, String lang, String datatype) throws ParseException {
        try {
            label = NTriplesUtil.unescapeString(label);
        }
        catch (IllegalArgumentException e) {
            this._throwParseException(e.getMessage());
        }
        if (lang.length() == 0) {
            lang = null;
        }
        if (datatype.length() == 0) {
            datatype = null;
        }
        URI dtURI = null;
        if (datatype != null) {
            dtURI = this._createURI(datatype);
            if (this._datatypeHandling == 20) {
                if (!XmlDatatypeUtil.isValidValue((String)label, (String)datatype)) {
                    this._throwParseException("'" + label + "' is not a valid value for datatype " + datatype);
                }
            } else if (this._datatypeHandling == 30) {
                try {
                    label = XmlDatatypeUtil.normalize((String)label, (String)datatype);
                }
                catch (IllegalArgumentException e) {
                    this._throwParseException("'" + label + "' is not a valid value for datatype " + datatype + ": " + e.getMessage());
                }
            }
        }
        try {
            if (dtURI != null) {
                return this._valFactory.createLiteral(label, dtURI);
            }
            if (lang != null) {
                return this._valFactory.createLiteral(label, lang);
            }
            return this._valFactory.createLiteral(label);
        }
        catch (Exception e) {
            this._throwParseException(e);
            return null;
        }
    }

    private void _throwParseException(String msg) throws ParseException {
        if (this._errListener != null) {
            this._errListener.fatalError(msg, this._lineNo, -1);
        }
        throw new ParseException(msg, this._lineNo, -1);
    }

    private void _throwParseException(Exception e) throws ParseException {
        if (e instanceof ParseException) {
            throw (ParseException)e;
        }
        if (this._errListener != null) {
            this._errListener.fatalError(e.getMessage(), this._lineNo, -1);
        }
        throw new ParseException(e, this._lineNo, -1);
    }

    private void _throwEOFException() throws ParseException {
        this._throwParseException("Unexpected end of file");
    }
}

