/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.oidclogout;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionInformation;
import org.fao.geonet.kernel.security.openidconnect.oidclogout.OidcSessionRegistry;
import org.fao.geonet.utils.Log;
import org.springframework.security.oauth2.jwt.Jwt;

public final class InMemoryOidcSessionRegistry
implements OidcSessionRegistry {
    private final Map<String, OidcSessionInformation> sessions = new ConcurrentHashMap<String, OidcSessionInformation>();

    @Override
    public void saveSessionInformation(OidcSessionInformation info) {
        this.sessions.put(info.getSessionId(), info);
    }

    @Override
    public OidcSessionInformation removeSessionInformation(String clientSessionId) {
        OidcSessionInformation information = this.sessions.remove(clientSessionId);
        if (information != null) {
            Log.debug((String)"geonetwork.security", (Object)"Removed client session");
        }
        return information;
    }

    @Override
    public Iterable<OidcSessionInformation> removeSessionInformation(Jwt token) {
        List audience = token.getClaimAsStringList("aud");
        String issuer = token.getIssuer().toString();
        String subject = token.getSubject();
        String providerSessionId = token.getClaimAsString("sid");
        Predicate<OidcSessionInformation> matcher = providerSessionId != null ? InMemoryOidcSessionRegistry.sessionIdMatcher(audience, issuer, providerSessionId) : InMemoryOidcSessionRegistry.subjectMatcher(audience, issuer, subject);
        String message = "Looking up sessions by issuer [%s] and %s [%s]";
        if (providerSessionId != null) {
            Log.debug((String)"geonetwork.security", (Object)String.format(message, issuer, "sid", providerSessionId));
        } else {
            Log.debug((String)"geonetwork.security", (Object)String.format(message, issuer, "sub", subject));
        }
        int size = this.sessions.size();
        Log.debug((String)"geonetwork.security", (Object)String.format("There are currently %d session(s) in the mapping", size));
        Log.debug((String)"geonetwork.security", (Object)this.sessions.values().toString());
        HashSet<OidcSessionInformation> infos = new HashSet<OidcSessionInformation>();
        this.sessions.values().removeIf(info -> {
            boolean result = matcher.test((OidcSessionInformation)((Object)info));
            if (result) {
                infos.add((OidcSessionInformation)((Object)info));
            }
            return result;
        });
        if (infos.isEmpty()) {
            Log.debug((String)"geonetwork.security", (Object)"Failed to remove any sessions since none matched");
        } else {
            Log.debug((String)"geonetwork.security", (Object)String.format("Found and removed %d session(s) from mapping of %d session(s)", infos.size(), size));
        }
        return infos;
    }

    private static Predicate<OidcSessionInformation> sessionIdMatcher(List<String> audience, String issuer, String sessionId) {
        return session -> {
            List thatAudience = session.getPrincipal().getAudience();
            String thatIssuer = session.getPrincipal().getIssuer().toString();
            String thatSessionId = session.getPrincipal().getClaimAsString("sid");
            if (thatAudience == null) {
                return false;
            }
            return !Collections.disjoint(audience, thatAudience) && issuer.equals(thatIssuer) && sessionId.equals(thatSessionId);
        };
    }

    private static Predicate<OidcSessionInformation> subjectMatcher(List<String> audience, String issuer, String subject) {
        return session -> {
            List thatAudience = session.getPrincipal().getAudience();
            String thatIssuer = session.getPrincipal().getIssuer().toString();
            String thatSubject = session.getPrincipal().getSubject();
            if (thatAudience == null) {
                return false;
            }
            return !Collections.disjoint(audience, thatAudience) && issuer.equals(thatIssuer) && subject.equals(thatSubject);
        };
    }
}

