/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.jxpath.ri.parser.Token;
import org.apache.commons.jxpath.ri.parser.XPathParser;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.AddElemValue;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SchemaSuggestions;
import org.fao.geonet.kernel.schema.ISOPlugin;
import org.fao.geonet.kernel.schema.MetadataAttribute;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.MetadataType;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.utils.Xml;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLib {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.editor");
    private static final Logger LOGGER_ADD_ELEMENT = LoggerFactory.getLogger((String)"geonetwork.editoraddelement");
    private static final Logger LOGGER_FILL_ELEMENT = LoggerFactory.getLogger((String)"geonetwork.editorfillelement");
    private static final Logger LOGGER_EXPAND_ELEMENT = LoggerFactory.getLogger((String)"geonetwork.editorexpandelement");
    public static final String XML_FRAGMENT_SEPARATOR = "&&&";
    public static final String COLON_SEPARATOR = "COLON";
    public static final String MSG_ELEMENT_NOT_FOUND_AT_REF = "Element not found at ref = ";
    private static final Joiner SLASH_STRING_JOINER = Joiner.on((char)'/');
    private SchemaManager scm;
    private static final Map<String, Integer> htVersions = new ConcurrentHashMap<String, Integer>();

    public EditLib(SchemaManager scm) {
        this.scm = scm;
    }

    public static String addGmlNamespaceToFragment(String fragment) {
        if (fragment.contains("<gml:") && !fragment.contains("xmlns:gml=\"")) {
            LOGGER.debug("  Add missing GML namespace.");
            fragment = fragment.replaceFirst("<gml:([^ >]+)", "<gml:$1 xmlns:gml=\"http://www.opengis.net/gml\"");
        }
        return fragment;
    }

    public static void tagForDisplay(Element elem) {
        elem.setAttribute("addedObj", "true", Edit.NAMESPACE);
    }

    public static void removeDisplayTag(Element elem) {
        elem.removeAttribute("addedObj", Edit.NAMESPACE);
    }

    public String getVersionForEditing(String schema, String id, Element md) throws Exception {
        String version = this.getVersion(id, true);
        this.addEditingInfo(schema, md, 1, 0);
        return version;
    }

    public void enumerateTree(Element md) throws Exception {
        this.enumerateTree(md, 1, 0);
    }

    public void enumerateTreeStartingAt(Element md, int id, int parent) throws Exception {
        this.enumerateTree(md, id, parent);
    }

    public String getVersion(String id) {
        return this.getVersion(id, false);
    }

    public String getNewVersion(String id) {
        return this.getVersion(id, true);
    }

    public void fillElement(String schema, Element parent, Element md) throws Exception {
        this.fillElement(this.scm.getSchema(schema), this.scm.getSchemaSuggestions(schema), parent, md);
    }

    public void removeEditingInfo(Element md) {
        for (Attribute attr : new ArrayList(md.getAttributes())) {
            if (!Edit.NAMESPACE.getPrefix().equals(attr.getNamespacePrefix())) continue;
            attr.detach();
        }
        for (Element child : new ArrayList(md.getChildren())) {
            if (!Edit.NAMESPACE.getPrefix().equals(child.getNamespacePrefix())) {
                this.removeEditingInfo(child);
                continue;
            }
            child.detach();
        }
    }

    public Element findElement(Element md, String ref) {
        Element elem = md.getChild("element", Edit.NAMESPACE);
        if (elem != null && ref.equals(elem.getAttributeValue("ref"))) {
            return md;
        }
        List list = md.getChildren();
        for (Element child : list) {
            if (Edit.NAMESPACE.getPrefix().equals(child.getNamespacePrefix()) || (child = this.findElement(child, ref)) == null) continue;
            return child;
        }
        return null;
    }

    public Element addElement(MetadataSchema mdSchema, Element el, String qname) throws Exception {
        LOGGER_ADD_ELEMENT.debug("#### in addElement()");
        LOGGER_ADD_ELEMENT.debug("#### - parent = {}", (Object)el.getName());
        String name = this.getUnqualifiedName(qname);
        String ns = this.getNamespace(qname, el, mdSchema);
        String prefix = this.getPrefix(qname);
        LOGGER_ADD_ELEMENT.debug("#### - child name = {}", (Object)name);
        LOGGER_ADD_ELEMENT.debug("#### - child namespace = {}", (Object)ns);
        LOGGER_ADD_ELEMENT.debug("#### - child prefix = {}", (Object)prefix);
        LOGGER_ADD_ELEMENT.debug("#### - parents first child = {}", (Object)el.getChildren().stream().findFirst().toString());
        Element child = new Element(name, prefix, ns);
        this.addChildToParent(mdSchema, el, child, qname, false);
        SchemaSuggestions mdSugg = this.scm.getSchemaSuggestions(mdSchema.getName());
        this.fillElement(mdSchema, mdSugg, el, child);
        return child;
    }

    public void addFragment(String schema, Element targetElement, String qname, String fragment, boolean removeExisting) throws Exception {
        Element childToAdd;
        MetadataSchema mdSchema = this.scm.getSchema(schema);
        try {
            childToAdd = Xml.loadString((String)fragment, (boolean)false);
        }
        catch (JDOMException e) {
            LOGGER_ADD_ELEMENT.error("EditLib : Error parsing XML fragment {}.", (Object)fragment);
            throw new IllegalStateException("EditLib : Error when loading XML fragment, " + e.getMessage());
        }
        this.addChildToParent(mdSchema, targetElement, childToAdd, qname, removeExisting);
    }

    private void addChildToParent(MetadataSchema mdSchema, Element targetElement, Element childToAdd, String qname, boolean removeExisting) throws Exception {
        LOGGER_ADD_ELEMENT.debug("#### - child qname = {}", (Object)qname);
        String parentName = this.getParentNameFromChild(targetElement);
        LOGGER_ADD_ELEMENT.debug("#### - parent name for type retrieval = {}", (Object)parentName);
        String typeName = mdSchema.getElementType(targetElement.getQualifiedName(), parentName);
        LOGGER_ADD_ELEMENT.debug("#### - type name = {}", (Object)typeName);
        MetadataType type = mdSchema.getTypeInfo(typeName);
        LOGGER_ADD_ELEMENT.debug("#### - metadata type = {}", (Object)type);
        ArrayList<Element> existingAllType = new ArrayList<Element>(targetElement.getChildren());
        targetElement.removeContent();
        for (String singleType : type.getAlElements()) {
            List<Element> existingForThisType = this.filterOnQname(existingAllType, singleType);
            LOGGER_ADD_ELEMENT.debug("####   - child of type {}, list size = {}", (Object)singleType, (Object)existingForThisType.size());
            if (!qname.equals(singleType) || !removeExisting) {
                for (Element existingChild : existingForThisType) {
                    targetElement.addContent((Content)existingChild);
                    LOGGER_ADD_ELEMENT.debug("####\t\t- add child {}", (Object)existingChild.toString());
                }
            }
            if (!qname.equals(singleType)) continue;
            targetElement.addContent((Content)childToAdd);
        }
    }

    public void addXMLFragments(String schema, Element md, Map<String, String> xmlInputs) throws Exception {
        HashMap<String, Element> nodeRefToElem = new HashMap<String, Element>();
        for (Map.Entry<String, String> entry : xmlInputs.entrySet()) {
            String[] nodeConfig = entry.getKey().split("_");
            String nodeRef = nodeConfig[0];
            Element el = this.findElement(md, nodeConfig[0]);
            nodeRefToElem.put(nodeRef, el);
        }
        for (Map.Entry<String, String> entry : xmlInputs.entrySet()) {
            String[] fragments;
            Element el;
            String xmlSnippetAsString = entry.getValue();
            String nodeName = null;
            boolean replaceExisting = false;
            String[] nodeConfig = entry.getKey().split("_");
            String nodeRef = nodeConfig[0];
            if (nodeConfig[nodeConfig.length - 1].equals("replace")) {
                replaceExisting = true;
            }
            if (nodeConfig.length > 1 && !replaceExisting) {
                nodeName = nodeConfig[1].replace(COLON_SEPARATOR, ":");
            }
            if ((el = (Element)nodeRefToElem.get(nodeRef)) == null) {
                LOGGER.error(MSG_ELEMENT_NOT_FOUND_AT_REF + nodeRef);
                continue;
            }
            if (xmlSnippetAsString == null || xmlSnippetAsString.equals("")) continue;
            for (String fragment : fragments = xmlSnippetAsString.split(XML_FRAGMENT_SEPARATOR)) {
                if (nodeName != null) {
                    LOGGER.debug("Add XML fragment; {} to element with ref: {}", (Object)fragment, (Object)nodeRef);
                    this.addFragment(schema, el, nodeName, fragment, replaceExisting);
                    continue;
                }
                LOGGER.debug("Add XML fragment; {} to element with ref: {} replacing content.", (Object)fragment, (Object)nodeRef);
                el.removeContent();
                fragment = EditLib.addGmlNamespaceToFragment(fragment);
                Element node = Xml.loadString((String)fragment, (boolean)false);
                if (replaceExisting) {
                    List children = node.getChildren();
                    if (children.size() > 0) {
                        for (Element child : children) {
                            el.addContent((Content)((Element)child.clone()));
                        }
                    } else {
                        String textContent = node.getText();
                        el.addContent(textContent);
                    }
                    List attributes = node.getAttributes();
                    for (Attribute a : attributes) {
                        el.setAttribute((Attribute)a.clone());
                    }
                    continue;
                }
                el.addContent((Content)node);
            }
        }
    }

    public int addElementOrFragmentFromXpaths(Element metadataRecord, LinkedHashMap<String, AddElemValue> xmlAndXpathInputs, MetadataSchema metadataSchema, boolean createXpathNodeIfNotExist) throws JDOMException, IOException {
        int numUpdated = 0;
        for (Map.Entry<String, AddElemValue> entry : xmlAndXpathInputs.entrySet()) {
            boolean isReplaceAllMode;
            String xpathProperty = entry.getKey();
            AddElemValue propertyValue = entry.getValue();
            boolean bl = isReplaceAllMode = propertyValue.getNodeValue() != null && propertyValue.getNodeValue().getName().startsWith("gn_replace_all");
            if (isReplaceAllMode) {
                AddElemValue propertyValueToProcess = new AddElemValue(new Element("gn_delete"));
                this.addElementOrFragmentFromXpath(metadataRecord, metadataSchema, xpathProperty, propertyValueToProcess, createXpathNodeIfNotExist);
                Element fragments = propertyValue.getNodeValue();
                for (Element fragment : fragments.getChildren()) {
                    propertyValueToProcess = new AddElemValue("<gn_create>" + Xml.getString((Element)fragment) + "</gn_create>");
                    boolean updated = this.addElementOrFragmentFromXpath(metadataRecord, metadataSchema, xpathProperty, propertyValueToProcess, createXpathNodeIfNotExist);
                    if (!updated) continue;
                    ++numUpdated;
                }
                continue;
            }
            boolean updated = this.addElementOrFragmentFromXpath(metadataRecord, metadataSchema, xpathProperty, propertyValue, createXpathNodeIfNotExist);
            if (!updated) continue;
            ++numUpdated;
        }
        return numUpdated;
    }

    public boolean addElementOrFragmentFromXpath(Element metadataRecord, MetadataSchema metadataSchema, String xpathProperty, AddElemValue value, boolean createXpathNodeIfNotExist) {
        boolean isUpdated = false;
        try {
            boolean isValueXml = value.isXml();
            boolean isDeleteMode = value.getNodeValue() != null && value.getNodeValue().getName().startsWith("gn_delete");
            boolean isCreateMode = value.getNodeValue() != null && value.getNodeValue().getName().equals("gn_create");
            LOGGER_ADD_ELEMENT.debug("Inserting at location {} the snippet or value {}", (Object)xpathProperty, (Object)value);
            xpathProperty = this.cleanRootFromXPath(xpathProperty, metadataRecord);
            List<Object> nodeList = this.trySelectNode((Element)metadataRecord, (MetadataSchema)metadataSchema, (String)xpathProperty, (boolean)true).results;
            LOGGER_ADD_ELEMENT.debug("{} element matching XPath found.", (Object)nodeList.size());
            if ((nodeList.isEmpty() && createXpathNodeIfNotExist || isCreateMode) && !isDeleteMode) {
                int indexOfRequiredPortion = -1;
                boolean relativeXpath = xpathProperty.startsWith("(");
                for (int i = 0; i < xpathProperty.length(); ++i) {
                    char c = xpathProperty.charAt(i);
                    if ((!relativeXpath || c != ')' && c != ']') && (relativeXpath || c != '[')) continue;
                    indexOfRequiredPortion = i + (relativeXpath ? 1 : 0);
                }
                if (indexOfRequiredPortion > 0) {
                    String requiredXPath = xpathProperty.substring(0, indexOfRequiredPortion);
                    SelectResult selectResult = this.trySelectNode(metadataRecord, metadataSchema, requiredXPath, false);
                    if (selectResult != null) {
                        Object elem = selectResult.result;
                        if (elem == null) {
                            isUpdated = this.createAndAddFromXPath(metadataRecord, metadataSchema, requiredXPath, value);
                        } else if (elem instanceof Element) {
                            Element element = (Element)elem;
                            isUpdated = this.createAndAddFromXPath(element, metadataSchema, xpathProperty.substring(indexOfRequiredPortion), value);
                        } else {
                            isUpdated = false;
                        }
                    }
                } else {
                    isUpdated = this.createAndAddFromXPath(metadataRecord, metadataSchema, xpathProperty, value);
                }
            } else {
                for (Object propNode : nodeList) {
                    if (isCreateMode) continue;
                    if (isDeleteMode) {
                        Element parent;
                        if (propNode instanceof Element) {
                            parent = ((Element)propNode).getParentElement();
                            if (parent != null) {
                                Element matchingNode = (Element)propNode;
                                if (value.getNodeValue().getName().equals("gn_delete")) {
                                    parent.removeContent(parent.indexOf((Content)matchingNode));
                                }
                            }
                        } else if (propNode instanceof Attribute) {
                            parent = ((Attribute)propNode).getParent();
                            parent.removeAttribute(((Attribute)propNode).getName());
                        }
                    } else if (propNode instanceof Element && isValueXml) {
                        this.doAddFragmentFromXpath(metadataSchema, value.getNodeValue(), (Element)propNode);
                    } else if (propNode instanceof Element && !isValueXml) {
                        ((Element)propNode).setText(value.getStringValue());
                    } else if (propNode instanceof Attribute && !isValueXml) {
                        ((Attribute)propNode).setValue(value.getStringValue());
                    }
                    isUpdated = true;
                }
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return isUpdated;
    }

    private void doAddFragmentFromXpath(MetadataSchema metadataSchema, Element fragment, Element propEl) throws Exception {
        Element newValue = (Element)fragment.clone();
        if (newValue.getName().equals("gn_replace") || newValue.getName().equals("gn_add") || newValue.getName().equals("gn_create")) {
            boolean isReplace = newValue.getName().equals("gn_replace");
            if (isReplace) {
                propEl.removeContent();
            }
            ArrayList children = Lists.newArrayList((Iterable)newValue.getContent());
            for (Object o : children) {
                if (o instanceof Element) {
                    boolean childHasSameTypeAsTarget;
                    Element child = (Element)o;
                    if (LOGGER_ADD_ELEMENT.isDebugEnabled()) {
                        LOGGER_ADD_ELEMENT.debug(" > add " + Xml.getString((Element)child));
                    }
                    child.detach();
                    boolean bl = childHasSameTypeAsTarget = child.getName().equals(propEl.getName()) && child.getNamespace().equals((Object)propEl.getNamespace());
                    if (isReplace) {
                        propEl.addContent((Content)child);
                        continue;
                    }
                    if (childHasSameTypeAsTarget) {
                        Element parent = propEl.getParentElement();
                        if (parent == null) {
                            LOGGER_ADD_ELEMENT.error(String.format(" > adding fragment from XPath in element %s which has no parent. This usually means that the element is not allowed in the XSD. Check this element in the metadata record.", propEl.getName()));
                            continue;
                        }
                        int index = parent.indexOf((Content)propEl);
                        if (propEl.getChildren().size() == 0) {
                            parent.setContent(index, (Content)child);
                            continue;
                        }
                        parent.addContent(index, (Content)child);
                        continue;
                    }
                    Element newElement = this.addElement(metadataSchema, propEl, child.getQualifiedName());
                    if (newElement.getParent() != null) {
                        propEl.setContent(propEl.indexOf((Content)newElement), (Content)child);
                        continue;
                    }
                    if (child.getParentElement() != null) continue;
                    propEl.addContent((Content)child);
                    continue;
                }
                if (!(o instanceof Text)) continue;
                propEl.addContent((Content)new Text(((Text)o).getText()));
            }
        } else if (!newValue.getName().equals("gn_delete")) {
            if (newValue.getName().equals(propEl.getName()) && newValue.getNamespace().equals((Object)propEl.getNamespace())) {
                int idx = propEl.getParentElement().indexOf((Content)propEl);
                propEl.getParentElement().setContent(idx, (Content)newValue);
            } else {
                propEl.setContent((Content)newValue);
            }
        }
    }

    private boolean createAndAddFromXPath(Element metadataRecord, MetadataSchema metadataSchema, String xpathProperty, AddElemValue value) throws Exception {
        Token currentToken;
        xpathProperty = this.cleanRootFromXPath(xpathProperty, metadataRecord);
        List<String> xpathParts = Arrays.asList(xpathProperty.split("/"));
        SelectResult rootElem = this.trySelectNode(metadataRecord, metadataSchema, xpathParts.get(0), false);
        Pair result = rootElem.result instanceof Element ? this.findLongestMatch(metadataRecord, metadataSchema, xpathParts) : Pair.read((Object)metadataRecord, (Object)SLASH_STRING_JOINER.join(xpathParts));
        Element elementToAttachTo = (Element)result.one();
        Element cloneOfElementToAttachTo = (Element)elementToAttachTo.clone();
        XPathParser xpathParser = new XPathParser((Reader)new StringReader(cloneOfElementToAttachTo.getQualifiedName() + "/" + (String)result.two()));
        Token previousToken = currentToken = xpathParser.getNextToken();
        int depth = 0;
        Element currentNode = cloneOfElementToAttachTo;
        boolean existingElement = true;
        boolean isAttribute = false;
        String currentElementName = "";
        String currentElementNamespacePrefix = "";
        while (currentToken != null && currentToken.kind != 0 && currentToken.kind != 84) {
            if (XPathParserLocalConstants.ILLEGAL_KINDS.contains(currentToken.kind)) {
                return false;
            }
            if (currentToken.kind == 86) {
                isAttribute = true;
            }
            if (currentToken.kind == 78 && previousToken.kind == 6) {
                currentElementNamespacePrefix = currentToken.image;
            } else if (currentToken.kind == 78 && previousToken.kind == 79) {
                currentElementName = currentToken.image;
                if (depth > 0) {
                    String qualifiedName = currentElementNamespacePrefix + ":" + currentElementName;
                    LOGGER_ADD_ELEMENT.debug("Check if {} exists in {}", (Object)qualifiedName, (Object)currentNode.getName());
                    Element nodeToCheck = currentNode.getChild(currentElementName, Namespace.getNamespace((String)metadataSchema.getNS(currentElementNamespacePrefix)));
                    if (nodeToCheck != null) {
                        LOGGER_ADD_ELEMENT.debug(" > {} found", (Object)qualifiedName);
                        currentNode = nodeToCheck;
                        existingElement &= true;
                    } else {
                        LOGGER_ADD_ELEMENT.debug(" > add new node {} inserted in {}", (Object)qualifiedName, (Object)currentNode.getName());
                        if (metadataSchema.getElementValues(qualifiedName, currentNode.getQualifiedName()) != null) {
                            currentNode = this.addElement(metadataSchema, currentNode, qualifiedName);
                            existingElement = false;
                        } else {
                            return false;
                        }
                    }
                }
                ++depth;
                currentElementName = "";
                currentElementNamespacePrefix = "";
            }
            previousToken = currentToken;
            currentToken = xpathParser.getNextToken();
        }
        if (value.isXml() && isAttribute) {
            throw new AssertionError((Object)String.format("Cannot set Xml on an attribute. Xpath:'%s' value: '%s'.", xpathProperty, Xml.getString((Element)value.getNodeValue())));
        }
        if (value.isXml()) {
            if (existingElement) {
                currentNode = this.addElement(metadataSchema, currentNode.getParentElement(), currentNode.getQualifiedName());
            }
            currentNode.removeContent();
            this.doAddFragmentFromXpath(metadataSchema, value.getNodeValue(), currentNode);
        } else if (isAttribute) {
            currentNode.setAttribute(previousToken.image, value.getStringValue());
        } else {
            currentNode.setText(value.getStringValue());
        }
        elementToAttachTo.removeContent();
        ArrayList toAdd = Lists.newArrayList((Iterable)cloneOfElementToAttachTo.getContent());
        ArrayList attributeToAdd = Lists.newArrayList((Iterable)cloneOfElementToAttachTo.getAttributes());
        for (Attribute a : attributeToAdd) {
            elementToAttachTo.setAttribute(a.detach());
        }
        for (Content content : toAdd) {
            elementToAttachTo.addContent(content.detach());
        }
        return true;
    }

    @VisibleForTesting
    protected Pair<Element, String> findLongestMatch(Element metadataRecord, MetadataSchema metadataSchema, List<String> xpathPropertyParts) {
        BitSet bitSet = new BitSet(xpathPropertyParts.size());
        return this.findLongestMatch(metadataRecord, metadataRecord, 0, metadataSchema, xpathPropertyParts.size() / 2, xpathPropertyParts, bitSet);
    }

    private Pair<Element, String> findLongestMatch(Element metadataRecord, Element bestMatch, int indexOfBestMatch, MetadataSchema metadataSchema, int nextIndex, List<String> xpathPropertyParts, BitSet visited) {
        if (visited.get(nextIndex)) {
            return Pair.read((Object)bestMatch, (Object)SLASH_STRING_JOINER.join(xpathPropertyParts.subList(indexOfBestMatch, xpathPropertyParts.size())));
        }
        visited.set(nextIndex);
        if (xpathPropertyParts.size() - nextIndex < 3) {
            for (int i = xpathPropertyParts.size() - 1; i > -1; --i) {
                String xpath = SLASH_STRING_JOINER.join(xpathPropertyParts.subList(0, i));
                SelectResult result = this.trySelectNode(metadataRecord, metadataSchema, xpath, false);
                if (!(result.result instanceof Element)) continue;
                return Pair.read((Object)((Element)result.result), (Object)SLASH_STRING_JOINER.join(xpathPropertyParts.subList(i, xpathPropertyParts.size())));
            }
            return Pair.read((Object)bestMatch, (Object)SLASH_STRING_JOINER.join(xpathPropertyParts.subList(indexOfBestMatch, xpathPropertyParts.size())));
        }
        SelectResult found = this.trySelectNode(metadataRecord, metadataSchema, SLASH_STRING_JOINER.join(xpathPropertyParts.subList(0, nextIndex)), false);
        if (found.result instanceof Element) {
            Element newBest = (Element)found.result;
            int newIndex = nextIndex + (xpathPropertyParts.size() - nextIndex) / 2;
            return this.findLongestMatch(metadataRecord, newBest, nextIndex, metadataSchema, newIndex, xpathPropertyParts, visited);
        }
        if (!found.error) {
            int newNextIndex = indexOfBestMatch + (nextIndex - indexOfBestMatch) / 2;
            return this.findLongestMatch(metadataRecord, bestMatch, indexOfBestMatch, metadataSchema, newNextIndex, xpathPropertyParts, visited);
        }
        int newNextIndex = nextIndex + 1;
        return this.findLongestMatch(metadataRecord, bestMatch, indexOfBestMatch, metadataSchema, newNextIndex, xpathPropertyParts, visited);
    }

    private SelectResult trySelectNode(Element metadataRecord, MetadataSchema metadataSchema, String xpathProperty, boolean allNodes) {
        if (xpathProperty.trim().isEmpty()) {
            ArrayList<Element> list = new ArrayList<Element>();
            list.add(metadataRecord);
            return SelectResult.of(list);
        }
        Map<String, String> mapNs = metadataSchema.getSchemaNSWithPrefix();
        try {
            JDOMXPath xpath = new JDOMXPath(xpathProperty);
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(mapNs));
            if (allNodes) {
                return SelectResult.of(xpath.selectNodes((Object)metadataRecord));
            }
            return SelectResult.of(xpath.selectSingleNode((Object)metadataRecord));
        }
        catch (JaxenException e) {
            LOGGER_ADD_ELEMENT.warn("An illegal xpath was used to locate an element: {}", (Object)xpathProperty);
            return SelectResult.ERROR;
        }
    }

    public void clearVersion(String id) {
        htVersions.remove(id);
    }

    private List<Element> filterOnQname(List<Element> children, String qname) {
        Vector<Element> result = new Vector<Element>();
        for (Element child : children) {
            if (!child.getQualifiedName().equals(qname)) continue;
            result.add(child);
        }
        return result;
    }

    private synchronized String getVersion(String id, boolean increment) {
        Integer inVer = htVersions.get(id);
        if (inVer == null) {
            inVer = 1;
        }
        if (increment) {
            inVer = inVer + 1;
        }
        htVersions.put(id, inVer);
        return Integer.toString(inVer);
    }

    private void fillElement(MetadataSchema schema, SchemaSuggestions sugg, Element parent, Element element) throws Exception {
        String parentName = parent.getQualifiedName();
        this.fillElement(schema, sugg, parentName, element);
    }

    private void fillElement(MetadataSchema schema, SchemaSuggestions sugg, String parentName, Element element) throws Exception {
        String elemName = element.getQualifiedName();
        SchemaPlugin plugin = schema.getSchemaPlugin();
        boolean isISOPlugin = plugin instanceof ISOPlugin;
        ISOPlugin isoPlugin = isISOPlugin ? (ISOPlugin)plugin : null;
        boolean isSimpleElement = schema.isSimpleElement(elemName, parentName);
        LOGGER_FILL_ELEMENT.debug("#### Entering fillElement()");
        LOGGER_FILL_ELEMENT.debug("#### - elemName = {}", (Object)elemName);
        LOGGER_FILL_ELEMENT.debug("#### - parentName = {}", (Object)parentName);
        LOGGER_FILL_ELEMENT.debug("#### - isSimpleElement({}) = {}", (Object)elemName, (Object)isSimpleElement);
        if (isSimpleElement) {
            return;
        }
        MetadataType type = schema.getTypeInfo(schema.getElementType(elemName, parentName));
        boolean hasSuggestion = sugg.hasSuggestion(elemName, type.getElementList());
        LOGGER_FILL_ELEMENT.debug("#### - Type:");
        LOGGER_FILL_ELEMENT.debug("####   - name = {}", (Object)type.getName());
        LOGGER_FILL_ELEMENT.debug("####   - # attributes = {}", (Object)type.getAttributeCount());
        LOGGER_FILL_ELEMENT.debug("####   - # elements = {}", (Object)type.getElementCount());
        LOGGER_FILL_ELEMENT.debug("####   - # isOrType = {}", (Object)type.isOrType());
        LOGGER_FILL_ELEMENT.debug("####   - type = {}", (Object)type);
        LOGGER_FILL_ELEMENT.debug("#### - Has suggestion = {}", (Object)hasSuggestion);
        for (MetadataAttribute attr : type.getAlAttribs()) {
            LOGGER_FILL_ELEMENT.debug("####   - {} attribute = {}", (Object)attr.name);
            LOGGER_FILL_ELEMENT.debug("####     - required = {}", (Object)attr.required);
            LOGGER_FILL_ELEMENT.debug("####     - suggested = {}", (Object)sugg.isSuggested(elemName, attr.name));
            if (!attr.required && !sugg.isSuggested(elemName, attr.name)) continue;
            String value = "";
            if (attr.defValue != null) {
                value = attr.defValue;
                LOGGER_FILL_ELEMENT.debug("####     - value = {}", (Object)attr.defValue);
            }
            String uname = this.getUnqualifiedName(attr.name);
            String ns = this.getNamespace(attr.name, element, schema);
            String prefix = this.getPrefix(attr.name);
            if (!prefix.equals("")) {
                element.setAttribute(new Attribute(uname, value, Namespace.getNamespace((String)prefix, (String)ns)));
                continue;
            }
            element.setAttribute(new Attribute(uname, value));
        }
        if (!type.isOrType()) {
            for (int i = 0; i < type.getElementCount(); ++i) {
                String childName = type.getElementAt(i);
                boolean childIsMandatory = type.getMinCardinAt(i) > 0;
                boolean childIsSuggested = sugg.isSuggested(elemName, childName);
                boolean childIsFiltered = sugg.isFiltered(elemName, childName);
                LOGGER_FILL_ELEMENT.debug("####   - {} element = {}", (Object)i, (Object)childName);
                LOGGER_FILL_ELEMENT.debug("####     - suggested = {}", (Object)childIsSuggested);
                LOGGER_FILL_ELEMENT.debug("####     - is mandatory = {}", (Object)childIsMandatory);
                if (!childIsMandatory && !childIsSuggested || childIsFiltered) continue;
                MetadataType elemType = schema.getTypeInfo(schema.getElementType(childName, elemName));
                List<String> childSuggestion = sugg.getSuggestedElements(childName);
                boolean childHasOneSuggestion = sugg.hasSuggestion(childName, elemType.getElementList()) && CollectionUtils.intersection(elemType.getElementList(), childSuggestion).size() == 1;
                boolean childHasOnlyCharacterStringSuggestion = childSuggestion.size() == 1 && childSuggestion.contains("gco:CharacterString");
                LOGGER_FILL_ELEMENT.debug("####     - is or type = {}", (Object)elemType.isOrType());
                LOGGER_FILL_ELEMENT.debug("####     - has suggestion = {}", (Object)childHasOneSuggestion);
                LOGGER_FILL_ELEMENT.debug("####     - elem type list = {}", elemType.getElementList());
                LOGGER_FILL_ELEMENT.debug("####     - suggested types list = {}", childSuggestion);
                if (schema.isSimpleElement(elemName, childName) || !elemType.isOrType() || elemType.isOrType() && (childHasOneSuggestion || childSuggestion.isEmpty() && elemType.getElementList().contains("gco:CharacterString"))) {
                    String name = this.getUnqualifiedName(childName);
                    String ns = this.getNamespace(childName, element, schema);
                    String prefix = this.getPrefix(childName);
                    Element child = new Element(name, prefix, ns);
                    element.addContent((Content)child);
                    if (childHasOnlyCharacterStringSuggestion && isISOPlugin) {
                        child.addContent((Content)isoPlugin.createBasicTypeCharacterString());
                    }
                    this.fillElement(schema, sugg, element, child);
                    continue;
                }
                if (!LOGGER_FILL_ELEMENT.isDebugEnabled() || !elemType.isOrType() || !isISOPlugin) continue;
                if (elemType.getElementList().contains(isoPlugin.getBasicTypeCharacterStringName()) && !childHasOneSuggestion) {
                    LOGGER_FILL_ELEMENT.debug("####   - (INNER) Requested expansion of an OR element having gco:CharacterString substitute and no suggestion: {}", (Object)element.getName());
                    continue;
                }
                LOGGER_FILL_ELEMENT.debug("####   - WARNING (INNER): requested expansion of an OR element : {}", (Object)childName);
            }
        } else if (isISOPlugin && type.getElementList().contains(isoPlugin.getBasicTypeCharacterStringName()) && !hasSuggestion) {
            LOGGER_FILL_ELEMENT.debug("####   - Requested expansion of an OR element having gco:CharacterString substitute and no suggestion: {}", (Object)element.getName());
            Element child = isoPlugin.createBasicTypeCharacterString();
            element.addContent((Content)child);
        } else {
            LOGGER_FILL_ELEMENT.debug("####   - WARNING : requested expansion of an OR element : {}", (Object)element.getName());
        }
    }

    public List<Element> searchChildren(String chName, Element md, String schema) throws Exception {
        boolean hasContent = false;
        Vector<Element> holder = new Vector<Element>();
        MetadataSchema mdSchema = this.scm.getSchema(schema);
        String chUQname = this.getUnqualifiedName(chName);
        String chPrefix = this.getPrefix(chName);
        String chNS = this.getNamespace(chName, md, mdSchema);
        Element container = new Element(chUQname, chPrefix, chNS);
        MetadataType containerType = mdSchema.getTypeInfo(chName);
        for (String elemName : containerType.getAlElements()) {
            LOGGER.debug("\t\t-- Searching for child {}", (Object)elemName);
            List<Element> elems = this.edit_CHOICE_GROUP_SEQUENCE_in(elemName) ? this.searchChildren(elemName, md, schema) : this.filterOnQname(md.getChildren(), elemName);
            for (Element elem : elems) {
                container.addContent((Content)((Element)elem.clone()));
                hasContent = true;
            }
        }
        if (hasContent) {
            holder.add(container);
        } else if (!chName.contains("CHOICE_ELEMENT")) {
            this.fillElement(schema, md, container);
            holder.add(container);
        }
        return holder;
    }

    public void expandElements(String schema, Element md) throws Exception {
        if (md.getNamespace() == Edit.NAMESPACE) {
            return;
        }
        List childs = md.getChildren();
        for (Element child : childs) {
            this.expandElements(schema, child);
        }
        String name = md.getQualifiedName();
        String parentName = this.getParentNameFromChild(md);
        MetadataSchema mdSchema = this.scm.getSchema(schema);
        String typeName = mdSchema.getElementType(name, parentName);
        MetadataType thisType = mdSchema.getTypeInfo(typeName);
        if (thisType.hasContainers) {
            Vector<Object> holder = new Vector<Object>();
            for (String chName : thisType.getAlElements()) {
                if (this.edit_CHOICE_GROUP_SEQUENCE_in(chName)) {
                    List<Element> elems = this.searchChildren(chName, md, schema);
                    if (elems.size() <= 0) continue;
                    holder.addAll(elems);
                    continue;
                }
                List<Element> chElem = this.filterOnQname(md.getChildren(), chName);
                for (Element elem : chElem) {
                    holder.add(elem.detach());
                }
            }
            md.removeContent();
            md.addContent(holder);
        }
    }

    private Vector<Object> getContainerChildren(Element md) {
        Vector<Object> result = new Vector<Object>();
        List chChilds = md.getChildren();
        for (Element chChild : chChilds) {
            String chName = chChild.getName();
            if (this.edit_CHOICE_GROUP_SEQUENCE_in(chName)) {
                Vector<Object> moreChChilds = this.getContainerChildren(chChild);
                result.addAll(moreChChilds);
                continue;
            }
            result.add(chChild.clone());
        }
        return result;
    }

    public void contractElements(Element md) {
        Vector<Object> children = new Vector<Object>();
        List childs = md.getContent();
        for (Content content : childs) {
            if (content instanceof Element) {
                Element mdCh = (Element)content;
                String mdName = mdCh.getName();
                if (this.edit_CHOICE_GROUP_SEQUENCE_in(mdName)) {
                    Vector<Object> chChilds;
                    if (mdCh.getChildren().size() <= 0 || (chChilds = this.getContainerChildren(mdCh)).size() <= 0) continue;
                    children.addAll(chChilds);
                    continue;
                }
                children.add(mdCh.clone());
                continue;
            }
            children.add(content);
        }
        md.removeContent();
        md.addContent(children);
        for (Object e : children) {
            if (!(e instanceof Element)) continue;
            this.contractElements((Element)e);
        }
    }

    private int enumerateTree(Element md, int ref, int parent) throws Exception {
        int thisRef = ref;
        int thisParent = ref;
        List list = md.getChildren();
        for (Element child : list) {
            if (Edit.NAMESPACE.getPrefix().equals(child.getNamespacePrefix())) continue;
            ref = this.enumerateTree(child, ref + 1, thisParent);
        }
        Element elem = new Element("element", Edit.NAMESPACE);
        elem.setAttribute(new Attribute("ref", thisRef + ""));
        elem.setAttribute(new Attribute("parent", parent + ""));
        elem.setAttribute(new Attribute("uuid", md.getQualifiedName() + "_" + UUID.randomUUID().toString()));
        md.addContent((Content)elem);
        return ref;
    }

    public int findMaximumRef(Element md) {
        int iRef = 0;
        Iterator mdIt = md.getDescendants((Filter)new ElementFilter("element"));
        while (mdIt.hasNext()) {
            int i;
            Element elem = (Element)mdIt.next();
            String ref = elem.getAttributeValue("ref");
            if (ref == null || (i = Integer.parseInt(ref)) <= iRef) continue;
            iRef = i;
        }
        return iRef;
    }

    public void expandTree(MetadataSchema schema, Element md) throws Exception {
        this.expandElement(schema, md);
        List list = md.getChildren();
        for (Element child : list) {
            if (Edit.NAMESPACE.getPrefix().equals(child.getNamespacePrefix())) continue;
            this.expandTree(schema, child);
        }
    }

    private String getParentNameFromChild(Element child) {
        String parentName = "root";
        Element parent = child.getParentElement();
        if (parent != null) {
            parentName = parent.getQualifiedName();
        }
        return parentName;
    }

    public void expandElement(MetadataSchema schema, Element md) throws Exception {
        LOGGER_EXPAND_ELEMENT.debug("entering expandElement()");
        String elemName = md.getQualifiedName();
        String parentName = this.getParentNameFromChild(md);
        LOGGER_EXPAND_ELEMENT.debug("elemName = {}", (Object)elemName);
        LOGGER_EXPAND_ELEMENT.debug("parentName = {}", (Object)parentName);
        String elemType = schema.getElementType(elemName, parentName);
        LOGGER_EXPAND_ELEMENT.debug("elemType = {}", (Object)elemType);
        Element elem = md.getChild("element", Edit.NAMESPACE);
        this.addValues(schema, elem, elemName, parentName);
        if (schema.isSimpleElement(elemName, parentName)) {
            LOGGER_EXPAND_ELEMENT.debug("is simple element");
            return;
        }
        MetadataType type = schema.getTypeInfo(elemType);
        LOGGER_EXPAND_ELEMENT.debug("Type = {}", (Object)type);
        for (int i = 0; i < type.getElementCount(); ++i) {
            String childQName = type.getElementAt(i);
            LOGGER_EXPAND_ELEMENT.debug("- childName = {}", (Object)childQName);
            if (childQName == null) continue;
            String childName = this.getUnqualifiedName(childQName);
            String childPrefix = this.getPrefix(childQName);
            String childNS = this.getNamespace(childQName, md, schema);
            LOGGER_EXPAND_ELEMENT.debug("- name      = {}", (Object)childName);
            LOGGER_EXPAND_ELEMENT.debug("- prefix    = {}", (Object)childPrefix);
            LOGGER_EXPAND_ELEMENT.debug("- namespace = {}", (Object)childNS);
            List list = md.getChildren(childName, Namespace.getNamespace((String)childNS));
            if (list.isEmpty() && !type.isOrType()) {
                LOGGER_EXPAND_ELEMENT.debug("- no children of this type already present");
                Element newElem = this.createElement(schema, elemName, childQName, childNS, type.getMinCardinAt(i), type.getMaxCardinAt(i));
                if (i == 0) {
                    this.insertFirst(md, newElem);
                    continue;
                }
                String prevQName = type.getElementAt(i - 1);
                String prevName = this.getUnqualifiedName(prevQName);
                String prevNS = this.getNamespace(prevQName, md, schema);
                this.insertLast(md, prevName, prevNS, newElem);
                continue;
            }
            LOGGER_EXPAND_ELEMENT.debug("- {} children of this type already present", (Object)list.size());
            LOGGER_EXPAND_ELEMENT.debug("- min cardinality = {}", (Object)type.getMinCardinAt(i));
            LOGGER_EXPAND_ELEMENT.debug("- max cardinality = {}", (Object)type.getMaxCardinAt(i));
            for (int j = 0; j < list.size(); ++j) {
                Element listChild = (Element)list.get(j);
                Element listElem = listChild.getChild("element", Edit.NAMESPACE);
                listElem.setAttribute(new Attribute("uuid", listChild.getQualifiedName() + "_" + UUID.randomUUID().toString()));
                listElem.setAttribute(new Attribute("min", "" + type.getMinCardinAt(i)));
                listElem.setAttribute(new Attribute("max", "" + type.getMaxCardinAt(i)));
                if (j > 0) {
                    listElem.setAttribute(new Attribute("up", "true"));
                }
                if (j < list.size() - 1) {
                    listElem.setAttribute(new Attribute("down", "true"));
                }
                if (list.size() > type.getMinCardinAt(i)) {
                    listElem.setAttribute(new Attribute("del", "true"));
                }
                if (j >= type.getMaxCardinAt(i) - 1) continue;
                listElem.setAttribute(new Attribute("add", "true"));
            }
            if (list.size() >= type.getMaxCardinAt(i)) continue;
            this.insertLast(md, childName, childNS, this.createElement(schema, elemName, childQName, childNS, type.getMinCardinAt(i), type.getMaxCardinAt(i)));
        }
        this.addAttribs(type, md, schema);
    }

    public String getUnqualifiedName(String qname) {
        int pos = qname.indexOf(58);
        if (pos < 0) {
            return qname;
        }
        return qname.substring(pos + 1);
    }

    public String getPrefix(String qname) {
        int pos = qname.indexOf(58);
        if (pos < 0) {
            return "";
        }
        return qname.substring(0, pos);
    }

    public String getNamespace(String qname, Element md, MetadataSchema schema) {
        String result = this.checkNamespaces(qname, md);
        if (!result.equals("UNKNOWN")) {
            return result;
        }
        Element root = md;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        result = this.checkNamespaces(qname, root);
        if (!result.equals("UNKNOWN")) {
            return result;
        }
        return this.getNamespace(qname, schema);
    }

    private String getNamespace(String qname, MetadataSchema schema) {
        String result;
        String prefix = this.getPrefix(qname);
        if (!prefix.equals("") && (result = schema.getNS(prefix)) != null) {
            return result;
        }
        return "UNKNOWN";
    }

    private String checkNamespaces(String qname, Element md) {
        Namespace rns;
        String prefix = this.getPrefix(qname);
        if (prefix.equals((rns = md.getNamespace()).getPrefix())) {
            return rns.getURI();
        }
        for (Object o : md.getAdditionalNamespaces()) {
            Namespace ns = (Namespace)o;
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns.getURI();
        }
        return "UNKNOWN";
    }

    private void insertFirst(Element md, Element child) {
        ArrayList list = new ArrayList(md.getChildren());
        md.removeContent();
        md.addContent((Content)child);
        for (Element elem : list) {
            md.addContent((Content)elem);
        }
    }

    private void insertLast(Element md, String childName, String childNS, Element child) {
        boolean added = false;
        List list = md.getChildren();
        ArrayList<Element> v = new ArrayList<Element>();
        for (int i = 0; i < list.size(); ++i) {
            Element el = (Element)list.get(i);
            v.add(el);
            if (!this.equal(childName, childNS, el) || added || i != list.size() - 1 && this.equal(el, (Element)list.get(i + 1))) continue;
            v.add(child);
            added = true;
        }
        md.removeContent();
        md.addContent(v);
    }

    private boolean equal(String childName, String childNS, Element el) {
        if (Edit.NAMESPACE.getURI().equals(el.getNamespaceURI())) {
            return "child".equals(el.getName()) && childName.equals(el.getAttributeValue("name")) && childNS.equals(el.getAttributeValue("namespace"));
        }
        return childName.equals(el.getName()) && childNS.equals(el.getNamespaceURI());
    }

    private boolean equal(Element el1, Element el2) {
        String elemNS1 = el1.getNamespaceURI();
        String elemNS2 = el2.getNamespaceURI();
        String geonetNS = Edit.NAMESPACE.getURI();
        if (geonetNS.equals(elemNS1) && geonetNS.equals(elemNS2)) {
            if (!"child".equals(el1.getName())) {
                return false;
            }
            if (!"child".equals(el2.getName())) {
                return false;
            }
            String name1 = el1.getAttributeValue("name");
            String ns1 = el1.getAttributeValue("namespace");
            String name2 = el2.getAttributeValue("name");
            String ns2 = el2.getAttributeValue("namespace");
            return name1.equals(name2) && ns1.equals(ns2);
        }
        if (geonetNS.equals(elemNS1) && !geonetNS.equals(elemNS2)) {
            if (!"child".equals(el1.getName())) {
                return false;
            }
            String name1 = el1.getAttributeValue("name");
            String ns1 = el1.getAttributeValue("namespace");
            return el2.getName().equals(name1) && el2.getNamespaceURI().equals(ns1);
        }
        if (!geonetNS.equals(elemNS1) && geonetNS.equals(elemNS2)) {
            if (!"child".equals(el2.getName())) {
                return false;
            }
            String name2 = el2.getAttributeValue("name");
            String ns2 = el2.getAttributeValue("namespace");
            return el1.getName().equals(name2) && el1.getNamespaceURI().equals(ns2);
        }
        return el1.getName().equals(el2.getName()) && el1.getNamespaceURI().equals(el2.getNamespaceURI());
    }

    public MetadataType getType(MetadataSchema mds, Element elem) throws Exception {
        String elemName = elem.getQualifiedName();
        String parentName = this.getParentNameFromChild(elem);
        String elemType = mds.getElementType(elemName, parentName);
        return mds.getTypeInfo(elemType);
    }

    public Element createElement(String schema, Element child, Element parent) throws Exception {
        String childQName = child.getQualifiedName();
        MetadataSchema mds = this.scm.getSchema(schema);
        MetadataType mdt = this.getType(mds, parent);
        int min = -1;
        int max = -1;
        for (int i = 0; i < mdt.getElementCount(); ++i) {
            if (!childQName.equals(mdt.getElementAt(i))) continue;
            min = mdt.getMinCardinAt(i);
            max = mdt.getMaxCardinAt(i);
        }
        return this.createElement(mds, parent.getQualifiedName(), child.getQualifiedName(), child.getNamespaceURI(), min, max);
    }

    private Element createElement(MetadataSchema schema, String parent, String qname, String childNS, int min, int max) throws Exception {
        Element child = new Element("child", Edit.NAMESPACE);
        SchemaSuggestions mdSugg = this.scm.getSchemaSuggestions(schema.getName());
        child.setAttribute(new Attribute("name", this.getUnqualifiedName(qname)));
        child.setAttribute(new Attribute("prefix", this.getPrefix(qname)));
        child.setAttribute(new Attribute("namespace", childNS));
        child.setAttribute(new Attribute("uuid", "child_" + qname + "_" + UUID.randomUUID().toString()));
        child.setAttribute(new Attribute("min", "" + min));
        child.setAttribute(new Attribute("max", "" + max));
        String action = "replace";
        if (!schema.isSimpleElement(qname, parent)) {
            String elemType = schema.getElementType(qname, parent);
            MetadataType type = schema.getTypeInfo(elemType);
            boolean useSuggestion = mdSugg.hasSuggestion(qname, type.getElementList());
            if (type.isOrType()) {
                ISOPlugin isoPlugin;
                SchemaPlugin plugin = schema.getSchemaPlugin();
                boolean isISOPlugin = plugin instanceof ISOPlugin;
                ISOPlugin iSOPlugin = isoPlugin = isISOPlugin ? (ISOPlugin)plugin : null;
                if (isISOPlugin && type.getElementList().contains(isoPlugin.getBasicTypeCharacterStringName()) && !useSuggestion) {
                    LOGGER.debug("OR element having gco:CharacterString substitute and no suggestion: {}", (Object)qname);
                    Element basicTypeNode = isoPlugin.createBasicTypeCharacterString();
                    Element newElem = this.createElement(schema, qname, basicTypeNode.getQualifiedName(), basicTypeNode.getNamespaceURI(), 1, 1);
                    child.addContent((Content)newElem);
                } else {
                    action = "before";
                    for (String chElem : type.getAlElements()) {
                        if (chElem.contains("CHOICE_ELEMENT")) {
                            List<String> chElems = this.recurseOnNestedChoices(schema, chElem, parent);
                            Iterator<String> iterator = chElems.iterator();
                            while (iterator.hasNext()) {
                                String chElem1;
                                chElem = chElem1 = iterator.next();
                                if (useSuggestion && !mdSugg.isSuggested(qname, chElem)) continue;
                                this.createAndAddChoose(child, chElem);
                            }
                            continue;
                        }
                        if (useSuggestion && !mdSugg.isSuggested(qname, chElem)) continue;
                        this.createAndAddChoose(child, chElem);
                    }
                }
            }
        }
        if (max == 1) {
            action = "replace";
        }
        child.setAttribute(new Attribute("action", action));
        return child;
    }

    private List<String> recurseOnNestedChoices(MetadataSchema schema, String chElem, String parent) throws Exception {
        ArrayList<String> chElems = new ArrayList<String>();
        String elemType = schema.getElementType(chElem, parent);
        MetadataType type = schema.getTypeInfo(elemType);
        for (String subChElem : type.getAlElements()) {
            if (subChElem.contains("CHOICE_ELEMENT")) {
                List<String> subChElems = this.recurseOnNestedChoices(schema, subChElem, chElem);
                chElems.addAll(subChElems);
                continue;
            }
            chElems.add(subChElem);
        }
        return chElems;
    }

    private void createAndAddChoose(Element child, String chType) {
        Element choose = new Element("choose", Edit.NAMESPACE);
        choose.setAttribute(new Attribute("name", chType));
        child.addContent((Content)choose);
    }

    private void addValues(MetadataSchema schema, Element elem, String name, String parent) throws Exception {
        List<String> values = schema.getElementValues(name, parent);
        if (values != null) {
            for (String value : values) {
                Element text = new Element("text", Edit.NAMESPACE);
                text.setAttribute("value", value);
                elem.addContent((Content)text);
            }
        }
    }

    private void addAttribs(MetadataType type, Element md, MetadataSchema schema) {
        for (MetadataAttribute attr : type.getAlAttribs()) {
            boolean present;
            Element attribute = new Element("attribute", Edit.NAMESPACE);
            attribute.setAttribute(new Attribute("name", attr.name));
            if (attr.defValue != null) {
                Element def = new Element("default", Edit.NAMESPACE);
                def.setAttribute("value", attr.defValue);
                attribute.addContent((Content)def);
            }
            for (String value : attr.values) {
                Element text = new Element("text", Edit.NAMESPACE);
                text.setAttribute("value", value);
                attribute.addContent((Content)text);
            }
            String uname = this.getUnqualifiedName(attr.name);
            String ns = this.getNamespace(attr.name, md, schema);
            String prefix = this.getPrefix(attr.name);
            if (!prefix.equals("")) {
                boolean bl = present = md.getAttributeValue(uname, Namespace.getNamespace((String)prefix, (String)ns)) != null;
                if (!present && attr.required && attr.defValue != null) {
                    md.setAttribute(new Attribute(uname, attr.defValue, Namespace.getNamespace((String)prefix, (String)ns)));
                }
            } else {
                boolean bl = present = md.getAttributeValue(attr.name) != null;
                if (!present && attr.required && attr.defValue != null) {
                    md.setAttribute(new Attribute(attr.name, attr.defValue));
                }
            }
            if (!present) {
                attribute.setAttribute(new Attribute("add", "true"));
            } else if (!attr.required) {
                attribute.setAttribute(new Attribute("del", "true"));
            }
            md.addContent((Content)attribute);
        }
    }

    private String cleanRootFromXPath(String xpathProperty, Element metadataRecord) {
        if (xpathProperty.startsWith("/")) {
            xpathProperty = xpathProperty.substring(1);
        }
        if (xpathProperty.startsWith(metadataRecord.getQualifiedName() + "/")) {
            xpathProperty = xpathProperty.substring(metadataRecord.getQualifiedName().length() + 1);
        }
        return xpathProperty;
    }

    private void addEditingInfo(String schema, Element md, int id, int parent) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MD before editing infomation:\n{}", (Object)Xml.getString((Element)md));
        }
        this.enumerateTree(md, id, parent);
        this.expandTree(this.scm.getSchema(schema), md);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MD after editing infomation::\n{}", (Object)Xml.getString((Element)md));
        }
    }

    private boolean edit_CHOICE_GROUP_SEQUENCE_in(String name) {
        return name.contains("CHOICE_ELEMENT") || name.contains("GROUP_ELEMENT") || name.contains("SEQUENCE_ELEMENT");
    }

    private static class SelectResult {
        private static final SelectResult ERROR = new SelectResult(null, true);
        final List<Object> results;
        final Object result;
        final boolean error;

        private SelectResult(List<Object> results, boolean error) {
            this.result = null;
            this.results = results == null ? new ArrayList() : results;
            this.error = error;
        }

        private SelectResult(Object result, boolean error) {
            this.result = result;
            this.results = new ArrayList<Object>();
            this.error = error;
        }

        private static SelectResult of(Object result) {
            return new SelectResult(result, false);
        }

        private static SelectResult of(List<Object> results) {
            return new SelectResult(results, false);
        }
    }

    public static interface SpecialUpdateTags {
        public static final String REPLACE = "gn_replace";
        public static final String ADD = "gn_add";
        public static final String CREATE = "gn_create";
        public static final String DELETE = "gn_delete";
        public static final String REPLACE_ALL = "gn_replace_all";
    }

    private static interface XPathParserLocalConstants {
        public static final int SQBRACKET_OPEN = 84;
        public static final int TEXT = 78;
        public static final int NAMESPACE_SEP = 79;
        public static final int ATTRIBUTE = 86;
        public static final int PARENT = 83;
        public static final int DESCENDANT = 7;
        public static final Set<Integer> ILLEGAL_KINDS = Sets.newHashSet((Object[])new Integer[]{83, 7});
    }
}

