/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v4;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseSearch;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

class Search
extends BaseSearch {
    public String categories;
    public String schemes;
    public String groupOwners;

    public Search() {
    }

    public Search(Element search) throws BadParameterEx {
        super(search);
        this.categories = Util.getParam((Element)search, (String)"categories", (String)"");
        this.schemes = Util.getParam((Element)search, (String)"schemes", (String)"");
        this.groupOwners = Util.getParam((Element)search, (String)"groupOwners", (String)"");
    }

    public static Search createEmptySearch(int from, int to) throws BadParameterEx {
        Search s = new Search(new Element("search"));
        s.setRange(from, to);
        return s;
    }

    public Search copy() {
        Search s = new Search();
        s.freeText = this.freeText;
        s.title = this.title;
        s.abstractText = this.abstractText;
        s.keywords = this.keywords;
        s.sourceUuid = this.sourceUuid;
        s.from = this.from;
        s.to = this.to;
        s.categories = this.categories;
        s.groupOwners = this.groupOwners;
        s.schemes = this.schemes;
        return s;
    }

    public String createElasticsearchQuery() {
        String queryFilter;
        ArrayList<String> filters = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.sourceUuid)) {
            filters.add(String.format("{\"term\": {\"sourceCatalogue\": \"%s\"}}", this.sourceUuid));
        }
        if (StringUtils.isNotBlank((CharSequence)this.freeText)) {
            filters.add(String.format("{\"query_string\": {\"query\": \"(any.\\\\*:(%s) OR any.common:(%s))\", \"default_operator\": \"AND\"}}", this.freeText, this.freeText));
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            filters.add(String.format("{\"query_string\": {\"query\": \"(resourceTitleObject.\\\\*:(%s))\", \"default_operator\": \"AND\"}}", this.title));
        }
        if (StringUtils.isNotBlank((CharSequence)this.abstractText)) {
            filters.add(String.format("{\"query_string\": {\"query\": \"(resourceAbstractObject.\\\\*:(%s))\", \"default_operator\": \"AND\"}}", this.abstractText));
        }
        if (StringUtils.isNotBlank((CharSequence)this.keywords)) {
            filters.add(String.format("{\"term\": {\"tag.default\": \"%s\"}}", this.keywords));
        }
        if (StringUtils.isNotBlank((CharSequence)this.categories)) {
            filters.add(String.format("{\"query_string\": {\"query\": \"cat:(%s)\"}}", this.categories));
        }
        if (StringUtils.isNotBlank((CharSequence)this.schemes)) {
            filters.add(String.format("{\"query_string\": {\"query\": \"documentStandard:(%s)\", \"default_operator\": \"OR\"}}", this.schemes));
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupOwners)) {
            try {
                List groupOwners = Arrays.stream(this.groupOwners.split(",")).map(String::trim).collect(Collectors.toList());
                String groupOwnersJson = new ObjectMapper().writeValueAsString(groupOwners);
                filters.add(String.format("{\"terms\": {\"groupOwner\": %s}}", groupOwnersJson));
            }
            catch (JsonProcessingException e) {
                Log.debug((String)"geonetwork.harvest-man", (Object)"Error creating criteria for ownerGroup. Ignoring this filter.");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(queryFilter = String.join((CharSequence)",", filters)))) {
            queryFilter = "," + queryFilter;
        }
        String queryBody = String.format("{\n    \"from\": %d,\n    \"size\": %d,\n    \"sort\": [\"_score\"],\n    \"query\": {\"bool\": {\"must\": [{\"terms\": {\"isTemplate\": [\"n\"]}}%s]}},\n    \"_source\": {\"includes\": [\n        \"uuid\",\n        \"id\",\n        \"isTemplate\",\n        \"sourceCatalogue\",\n        \"dateStamp\",\n        \"documentStandard\"\n    ]},\n    \"track_total_hits\": true\n}", this.from, this.to, queryFilter);
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Search request is " + queryBody));
        }
        return queryBody;
    }

    public void setRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("from", this.from).append("to", this.to).append("freeText", (Object)this.freeText).append("title", (Object)this.title).append("abstrac", (Object)this.abstractText).append("keywords", (Object)this.keywords).append("categories", (Object)this.categories).append("schemes", (Object)this.schemes).append("groupOwners", (Object)this.groupOwners).append("sourceUuid", (Object)this.sourceUuid).toString();
    }
}

