/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.database;

import java.sql.Blob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterAligner;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseHarvesterParams;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseMetadataRetrieverException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.StringUtils;

class DatabaseMetadataRetriever {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    protected Logger log;

    public DatabaseMetadataRetriever(String driverName, String connectionString, String username, String password, Logger log) {
        try {
            log.debug("Getting database connection (via JDBC)");
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(driverName);
            dataSource.setUrl(connectionString);
            dataSource.setUsername(username);
            dataSource.setPassword(password);
            dataSource.getConnection().close();
            this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
            this.log = log;
        }
        catch (SQLException x) {
            log.error("Error getting database connection", (Throwable)x);
            throw new ExceptionInInitializerError(new DatabaseMetadataRetrieverException("Exception in getting database connection: can not connect to the database", x));
        }
    }

    protected NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void processMetadata(AtomicBoolean cancelMonitor, DatabaseHarvesterParams params, DatabaseHarvesterAligner aligner) throws Exception {
        String sqlQuery;
        String metadataTable = params.getTableName();
        String columnName = params.getMetadataField();
        String filterField = params.getFilterField();
        String filterValue = params.getFilterValue();
        String filterOperator = params.getFilterOperator();
        String sqlOperator = "LIKE";
        if (StringUtils.hasLength((String)filterOperator) && filterOperator.equalsIgnoreCase("NOTLIKE")) {
            sqlOperator = "NOT " + sqlOperator;
        }
        MapSqlParameterSource param = new MapSqlParameterSource();
        if (StringUtils.hasLength((String)filterField) && StringUtils.hasLength((String)filterValue)) {
            sqlQuery = String.format("SELECT %s FROM %s WHERE %s %s :filter", columnName, metadataTable, filterField, sqlOperator);
            param = new MapSqlParameterSource("filter", (Object)filterValue);
        } else {
            sqlQuery = String.format("SELECT %s FROM %s", columnName, metadataTable);
        }
        this.getJdbcTemplate().query(sqlQuery, (SqlParameterSource)param, rs -> {
            int colId;
            if (cancelMonitor.get()) {
                this.log.warning("Cancelling metadata retrieve using database connection");
                rs.getStatement().cancel();
            }
            if (rs.getObject(colId = rs.findColumn(columnName)) != null) {
                String document;
                if (rs.getMetaData().getColumnType(colId) == 2004) {
                    Blob blob = rs.getBlob(columnName);
                    byte[] bdata = blob.getBytes(1L, (int)blob.length());
                    document = new String(bdata);
                } else if (rs.getMetaData().getColumnType(colId) == -4) {
                    byte[] byteData = rs.getBytes(colId);
                    document = new String(byteData);
                } else if (rs.getMetaData().getColumnType(colId) == -16 || rs.getMetaData().getColumnType(colId) == -1 || rs.getMetaData().getColumnType(colId) == 12 || rs.getMetaData().getColumnType(colId) == 2009) {
                    document = rs.getString(colId);
                } else {
                    throw new SQLException("Trying to harvest from a column with an invalid datatype: " + rs.getMetaData().getColumnTypeName(colId));
                }
                aligner.align(document);
            }
        });
    }
}

