/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import com.google.common.collect.Maps;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.HarvestValidationEnum;
import org.fao.geonet.kernel.harvest.harvester.HarvesterJob;
import org.fao.geonet.kernel.harvest.harvester.Privileges;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.QuartzSchedulerUtils;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.locationtech.jts.util.Assert;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public abstract class AbstractParams
implements Cloneable {
    public static final String TRANSLATIONS = "translations";
    private static final long MAX_EVERY = Integer.MAX_VALUE;
    protected Logger log = Log.createLogger((String)"geonetwork.harvest-man");
    protected DataManager dm;
    private String name;
    private Map<String, String> translations = Maps.newHashMap();
    private String uuid;
    private boolean useAccount;
    private String username;
    private String password;
    private String apiKeyHeader;
    private String apiKey;
    private String every;
    private boolean oneRunOnly;
    private HarvestValidationEnum validate;
    private String importXslt;
    private Element node;
    private String ownerId;
    private String ownerIdGroup;
    private String ownerIdUser;
    private OverrideUuid overrideUuid;
    private boolean translateContent;
    private String translateContentLangs;
    private String translateContentFields;
    private boolean ifRecordExistAppendPrivileges;
    private String batchEdits;
    private List<Privileges> alPrivileges = new ArrayList<Privileges>();
    private List<String> alCategories = new ArrayList<String>();

    public abstract String getIcon();

    public abstract AbstractParams copy();

    public AbstractParams(DataManager dm) {
        this.dm = dm;
    }

    private static HarvestValidationEnum readValidateFromParams(Element content) {
        String validationString = Util.getParam((Element)content, (String)"validate", (String)HarvestValidationEnum.NOVALIDATION.toString());
        return HarvestValidationEnum.lookup(validationString);
    }

    public void create(Element node) throws BadInputEx {
        Element ownerIdGroupE;
        Element ownerIdUserE;
        Element site;
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("AbstractParams creating from:\n" + Xml.getString((Element)node)));
        }
        Assert.isTrue(((site = node.getChild("site")) != null ? 1 : 0) != 0, (String)"Site cannot be null");
        Element opt = node.getChild("options");
        Element content = node.getChild("content");
        Element account = site.getChild("account");
        this.name = Util.getParam((Element)site, (String)"name", (String)"");
        if (site.getChild(TRANSLATIONS) != null) {
            this.translations = Localized.translationXmlToLangMap((List)site.getChild(TRANSLATIONS).getChildren());
        }
        this.uuid = Util.getParam((Element)site, (String)"uuid", (String)UUID.randomUUID().toString());
        Element ownerIdE = node.getChild("owner");
        if (ownerIdE == null) {
            ownerIdE = node.getChild("ownerId");
        }
        if (ownerIdE != null) {
            this.setOwnerId(ownerIdE.getChildText("id"));
            if (this.getOwnerId() == null || this.getOwnerId().trim().isEmpty()) {
                this.setOwnerId(ownerIdE.getText());
                if (this.getOwnerId() == null || this.getOwnerId().trim().isEmpty()) {
                    this.setOwnerId(null);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.getOwnerId())) {
            Log.warning((String)"geonetwork.harvest-man", (Object)("No owner defined for harvester: " + this.getName() + " (" + this.getUuid() + ")"));
        }
        if ((ownerIdUserE = site.getChild("ownerUser")) == null) {
            ownerIdUserE = node.getChild("ownerUser");
        }
        if (ownerIdUserE != null) {
            Element idE = ownerIdUserE.getChild("id");
            if (idE != null) {
                this.setOwnerIdUser(idE.getText());
            } else if (!ownerIdUserE.getTextTrim().isEmpty()) {
                this.setOwnerIdUser(ownerIdUserE.getTextTrim());
            }
        }
        if ((ownerIdGroupE = site.getChild("ownerGroup")) == null) {
            ownerIdGroupE = node.getChild("ownerGroup");
        }
        if (ownerIdGroupE != null) {
            Element idE = ownerIdGroupE.getChild("id");
            if (idE != null) {
                this.setOwnerIdGroup(idE.getText());
            } else if (!ownerIdGroupE.getTextTrim().isEmpty()) {
                this.setOwnerIdGroup(ownerIdGroupE.getTextTrim());
            }
        }
        this.setUseAccount(Util.getParam((Element)account, (String)"use", (boolean)false));
        this.setUsername(Util.getParam((Element)account, (String)"username", (String)""));
        this.setPassword(Util.getParam((Element)account, (String)"password", (String)""));
        this.setApiKeyHeader(Util.getParam((Element)site, (String)"apiKeyHeader", (String)""));
        this.setApiKey(Util.getParam((Element)site, (String)"apiKey", (String)""));
        this.setEvery(Util.getParam((Element)opt, (String)"every", (String)"0 0 0 * * ?"));
        this.setOneRunOnly(Util.getParam((Element)opt, (String)"oneRunOnly", (boolean)false));
        this.setOverrideUuid(OverrideUuid.valueOf(Util.getParam((Element)opt, (String)"overrideUuid", (String)OverrideUuid.SKIP.name())));
        this.setIfRecordExistAppendPrivileges("true".equals(node.getChildTextTrim("ifRecordExistAppendPrivileges")));
        this.getTrigger();
        this.setImportXslt(Util.getParam((Element)content, (String)"importxslt", (String)"none"));
        this.setBatchEdits(Util.getParam((Element)content, (String)"batchEdits", (String)""));
        this.setTranslateContent(Util.getParam((Element)content, (String)"translateContent", (boolean)false));
        this.setTranslateContentLangs(Util.getParam((Element)content, (String)"translateContentLangs", (String)""));
        this.setTranslateContentFields(Util.getParam((Element)content, (String)"translateContentFields", (String)""));
        this.setValidate(AbstractParams.readValidateFromParams(content));
        this.addPrivileges(node.getChild("privileges"));
        this.addCategories(node.getChild("categories"));
        this.setNodeElement(node);
    }

    public void update(Element node) throws BadInputEx {
        Element ownerIdGroupE;
        Element ownerIdUserE;
        Element ownerIdE;
        Element account;
        Element site = node.getChild("site");
        Element opt = node.getChild("options");
        Element content = node.getChild("content");
        String ACCOUNT_EL_NAME = "account";
        Element element = account = site == null ? null : site.getChild("account");
        if (account == null) {
            account = node.getChild("account");
        }
        Element privil = node.getChild("privileges");
        Element categ = node.getChild("categories");
        this.setName(Util.getParam((Element)site, (String)"name", (String)this.getName()));
        if (site != null && site.getChild(TRANSLATIONS) != null) {
            this.setTranslations(Localized.translationXmlToLangMap((List)site.getChild(TRANSLATIONS).getChildren()));
        }
        if ((ownerIdE = node.getChild("owner")) == null) {
            ownerIdE = node.getChild("ownerId");
        }
        if (ownerIdE != null) {
            this.setOwnerId(ownerIdE.getChildText("id"));
            if (this.getOwnerId() == null || this.getOwnerId().isEmpty()) {
                this.setOwnerId(ownerIdE.getTextNormalize());
            }
        } else {
            Log.warning((String)"geonetwork.harvest-man", (Object)("No owner defined for harvester: " + this.getName() + " (" + this.getUuid() + ")"));
        }
        if ((ownerIdUserE = node.getChild("ownerUser")) != null) {
            Element idE = ownerIdUserE.getChild("id");
            if (idE != null) {
                this.setOwnerIdUser(idE.getText());
            } else {
                this.setOwnerIdUser(ownerIdUserE.getText());
            }
        }
        if ((ownerIdGroupE = node.getChild("ownerGroup")) != null) {
            Element idE = ownerIdGroupE.getChild("id");
            if (idE != null) {
                this.setOwnerIdGroup(idE.getText());
            } else {
                this.setOwnerIdGroup(ownerIdGroupE.getText());
            }
        }
        this.setUseAccount(Util.getParam((Element)account, (String)"use", (boolean)this.isUseAccount()));
        this.setUsername(Util.getParam((Element)account, (String)"username", (String)this.getUsername()));
        this.setPassword(Util.getParam((Element)account, (String)"password", (String)this.getPassword()));
        this.setApiKeyHeader(Util.getParam((Element)site, (String)"apiKeyHeader", (String)this.getApiKeyHeader()));
        this.setApiKey(Util.getParam((Element)site, (String)"apiKey", (String)this.getApiKey()));
        this.setEvery(Util.getParam((Element)opt, (String)"every", (String)this.getEvery()));
        this.setOneRunOnly(Util.getParam((Element)opt, (String)"oneRunOnly", (boolean)this.isOneRunOnly()));
        this.setOverrideUuid(OverrideUuid.valueOf(Util.getParam((Element)opt, (String)"overrideUuid", (String)this.getOverrideUuid().name())));
        this.setIfRecordExistAppendPrivileges("true".equals(node.getChildTextTrim("ifRecordExistAppendPrivileges")));
        this.getTrigger();
        this.setImportXslt(Util.getParam((Element)content, (String)"importxslt", (String)"none"));
        this.setBatchEdits(Util.getParam((Element)content, (String)"batchEdits", (String)this.getBatchEdits()));
        this.setTranslateContent(Util.getParam((Element)content, (String)"translateContent", (boolean)false));
        this.setTranslateContentLangs(Util.getParam((Element)content, (String)"translateContentLangs", (String)""));
        this.setTranslateContentFields(Util.getParam((Element)content, (String)"translateContentFields", (String)""));
        this.setValidate(AbstractParams.readValidateFromParams(content));
        if (privil != null) {
            this.addPrivileges(privil);
        }
        if (categ != null) {
            this.addCategories(categ);
        }
        this.setNodeElement(node);
    }

    public Iterable<Privileges> getPrivileges() {
        return this.alPrivileges;
    }

    public Iterable<String> getCategories() {
        return this.alCategories;
    }

    protected void copyTo(AbstractParams copy) {
        copy.setName(this.getName());
        copy.setUuid(this.getUuid());
        copy.setTranslations(this.getTranslations());
        copy.setOwnerId(this.getOwnerId());
        copy.setOwnerIdUser(this.getOwnerIdUser());
        copy.setOwnerIdGroup(this.getOwnerIdGroup());
        copy.setUseAccount(this.isUseAccount());
        copy.setUsername(this.getUsername());
        copy.setPassword(this.getPassword());
        copy.setApiKeyHeader(this.getApiKeyHeader());
        copy.setApiKey(this.getApiKey());
        copy.setEvery(this.getEvery());
        copy.setOneRunOnly(this.isOneRunOnly());
        copy.setOverrideUuid(this.getOverrideUuid());
        copy.setIfRecordExistAppendPrivileges(this.isIfRecordExistAppendPrivileges());
        copy.setImportXslt(this.getImportXslt());
        copy.setBatchEdits(this.getBatchEdits());
        copy.setTranslateContent(this.isTranslateContent());
        copy.setValidate(this.getValidate());
        copy.setTranslateContent(this.isTranslateContent());
        for (Privileges p : this.alPrivileges) {
            copy.addPrivilege(p.copy());
        }
        for (String s : this.alCategories) {
            copy.addCategory(s);
        }
        copy.setNodeElement(this.getNodeElement());
    }

    public JobDetail getJob() {
        return JobBuilder.newJob(HarvesterJob.class).withIdentity(this.getUuid(), "HARVESTER_GROUP_NAME").usingJobData("harvesterId", this.getUuid()).build();
    }

    public Trigger getTrigger() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String timeZoneSetting = settingManager.getValue("system/server/timeZone", true);
        TimeZone tz = TimeZone.getDefault();
        if (StringUtils.isNotBlank((String)timeZoneSetting)) {
            try {
                ZoneId zoneId = ZoneId.of(timeZoneSetting);
                tz = TimeZone.getTimeZone(zoneId);
                this.log.debug("Using timezone in settings to set the Trigger timezone: " + zoneId);
            }
            catch (DateTimeException e) {
                this.log.error((Throwable)e);
            }
        }
        return QuartzSchedulerUtils.getTrigger((String)this.getUuid(), (String)"HARVESTER_GROUP_NAME", (String)this.getEvery(), (long)Integer.MAX_VALUE, (TimeZone)tz);
    }

    protected void checkPort(int port) throws BadParameterEx {
        if (port < 1 || port > 65535) {
            throw new BadParameterEx("port", (Object)port);
        }
    }

    private void addPrivileges(Element privil) throws BadInputEx {
        this.alPrivileges.clear();
        if (privil == null) {
            return;
        }
        for (Object o : privil.getChildren("group")) {
            Element group = (Element)o;
            String groupID = group.getAttributeValue("id");
            if (groupID == null) {
                throw new MissingParameterEx("attribute:id", (Object)group);
            }
            Privileges p = new Privileges(groupID);
            for (Object o1 : group.getChildren("operation")) {
                Element oper = (Element)o1;
                int op = this.getOperationId(oper);
                p.add(op);
            }
            this.addPrivilege(p);
        }
    }

    public void addPrivilege(Privileges p) {
        this.alPrivileges.add(p);
    }

    private int getOperationId(Element oper) throws BadInputEx {
        String operName = oper.getAttributeValue("name");
        if (operName == null) {
            throw new MissingParameterEx("attribute:name", (Object)oper);
        }
        int operID = this.dm.getAccessManager().getPrivilegeId(operName);
        if (operID == -1) {
            throw new BadParameterEx("attribute:name", (Object)operName);
        }
        if (operID == 2 || operID == 4) {
            throw new BadParameterEx("attribute:name", (Object)operName);
        }
        return operID;
    }

    private void addCategories(Element categ) throws BadInputEx {
        this.alCategories.clear();
        if (categ == null) {
            return;
        }
        for (Object o : categ.getChildren("category")) {
            Element categElem = (Element)o;
            String categId = categElem.getAttributeValue("id");
            if (categId == null || categId.trim().isEmpty()) continue;
            if (!Lib.type.isInteger(categId)) {
                throw new BadParameterEx("attribute:id", (Object)categElem);
            }
            this.addCategory(categId);
        }
    }

    public void addCategory(String categId) {
        this.alCategories.add(categId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, String> translations) {
        this.translations = translations;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isUseAccount() {
        return this.useAccount;
    }

    public void setUseAccount(boolean useAccount) {
        this.useAccount = useAccount;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getApiKeyHeader() {
        return this.apiKeyHeader;
    }

    public void setApiKeyHeader(String apiKeyHeader) {
        this.apiKeyHeader = apiKeyHeader;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getEvery() {
        return this.every;
    }

    public void setEvery(String every) {
        this.every = every;
    }

    public boolean isOneRunOnly() {
        return this.oneRunOnly;
    }

    public void setOneRunOnly(boolean oneRunOnly) {
        this.oneRunOnly = oneRunOnly;
    }

    public HarvestValidationEnum getValidate() {
        return this.validate;
    }

    public void setValidate(HarvestValidationEnum validate) {
        this.validate = validate;
    }

    public String getImportXslt() {
        return this.importXslt;
    }

    public void setImportXslt(String importXslt) {
        this.importXslt = importXslt;
    }

    public Element getNodeElement() {
        return this.node;
    }

    public void setNodeElement(Element node) {
        this.node = node;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerIdGroup() {
        return this.ownerIdGroup;
    }

    public void setOwnerIdGroup(String ownerIdGroup) {
        this.ownerIdGroup = ownerIdGroup;
    }

    public String getOwnerIdUser() {
        return this.ownerIdUser;
    }

    public void setOwnerIdUser(String ownerIdUser) {
        this.ownerIdUser = ownerIdUser;
    }

    public OverrideUuid getOverrideUuid() {
        return this.overrideUuid;
    }

    public void setOverrideUuid(OverrideUuid overrideUuid) {
        this.overrideUuid = overrideUuid;
    }

    public boolean isIfRecordExistAppendPrivileges() {
        return this.ifRecordExistAppendPrivileges;
    }

    public void setIfRecordExistAppendPrivileges(boolean ifRecordExistAppendPrivileges) {
        this.ifRecordExistAppendPrivileges = ifRecordExistAppendPrivileges;
    }

    public String getBatchEdits() {
        return this.batchEdits;
    }

    public void setBatchEdits(String batchEdits) {
        this.batchEdits = batchEdits;
    }

    public boolean isTranslateContent() {
        return this.translateContent;
    }

    public void setTranslateContent(boolean translateContent) {
        this.translateContent = translateContent;
    }

    public String getTranslateContentLangs() {
        return this.translateContentLangs;
    }

    public void setTranslateContentLangs(String translateContentLangs) {
        this.translateContentLangs = translateContentLangs;
    }

    public String getTranslateContentFields() {
        return this.translateContentFields;
    }

    public void setTranslateContentFields(String translateContentFields) {
        this.translateContentFields = translateContentFields;
    }

    public static enum OverrideUuid {
        SKIP,
        OVERRIDE,
        RANDOM;

    }
}

