/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractFloatCollection;
import bak.pcj.FloatCollection;
import bak.pcj.FloatIterator;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.list.FloatList;
import bak.pcj.list.FloatListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractFloatList
extends AbstractFloatCollection
implements FloatList {
    protected AbstractFloatList() {
    }

    public boolean add(float v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, float v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, FloatCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        FloatIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(float c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, float c) {
        FloatListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public FloatIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(float c) {
        FloatListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, float c) {
        FloatListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    public FloatListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new FloatListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractFloatList.this.size();
            }

            public float next() {
                if (this.ptr == AbstractFloatList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractFloatList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractFloatList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(float v) {
                AbstractFloatList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public float previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractFloatList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(float v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractFloatList.this.set(this.lptr, v);
            }
        };
    }

    public float removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatList)) {
            return false;
        }
        FloatListIterator i1 = this.listIterator();
        FloatListIterator i2 = ((FloatList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        FloatIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultFloatHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract float set(int var1, float var2);

    public abstract float get(int var1);
}

