/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteIterator;
import bak.pcj.adapter.IteratorToByteIteratorAdapter;
import bak.pcj.set.AbstractByteSet;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToByteSetAdapter
extends AbstractByteSet
implements ByteSet {
    protected Set set;

    public SetToByteSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToByteSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(byte v) {
        return this.set.add(new Byte(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(byte v) {
        return this.set.contains(new Byte(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public ByteIterator iterator() {
        return new IteratorToByteIteratorAdapter(this.set.iterator());
    }

    public boolean remove(byte v) {
        return this.set.remove(new Byte(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isByteAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

