/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatCollection;
import bak.pcj.adapter.CollectionToFloatCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyFloatMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyFloatMap;
import bak.pcj.map.ShortKeyFloatMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyFloatMapAdapter
extends AbstractShortKeyFloatMap
implements ShortKeyFloatMap {
    protected Map map;
    protected Float lastValue;

    public MapToShortKeyFloatMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyFloatMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Float)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(new Float(value));
    }

    public ShortKeyFloatMapIterator entries() {
        return new ShortKeyFloatMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyFloatMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public float getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getValue()).floatValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public float get(short key) {
        Float value = (Float)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public float lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.floatValue();
    }

    public float put(short key, float value) {
        Float oldValue = this.map.put(new Short(key), new Float(value));
        return oldValue == null ? MapDefaults.defaultFloat() : oldValue.floatValue();
    }

    public float remove(short key) {
        Float value = (Float)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public int size() {
        return this.map.size();
    }

    public FloatCollection values() {
        return new CollectionToFloatCollectionAdapter(this.map.values());
    }

    public float tget(short key) {
        Float value = (Float)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.floatValue();
    }

    public boolean validate() {
        return Adapter.isShortKeyFloatAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

