/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNPathRevision {
    private final SVNURL url;
    private final long revision;
    private final SVNURL reposRootUrl;
    private final String reposUuid;

    public static SVNPathRevision createWithRepository(SVNRepository svnRepository, SVNURL url, long revision) throws SVNException {
        SVNURL repositoryRoot = svnRepository.getRepositoryRoot(false);
        String repositoryUUID = svnRepository.getRepositoryUUID(false);
        return new SVNPathRevision(url, revision, repositoryRoot, repositoryUUID);
    }

    public SVNPathRevision(SVNURL url, long revision, SVNURL reposRootUrl, String reposUuid) {
        this.url = url;
        this.revision = revision;
        this.reposRootUrl = reposRootUrl;
        this.reposUuid = reposUuid;
    }

    public SVNURL getUrl() {
        return this.url;
    }

    public long getRevision() {
        return this.revision;
    }

    public SVNURL getReposRootUrl() {
        return this.reposRootUrl;
    }

    public String getReposUuid() {
        return this.reposUuid;
    }
}

