/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintOpN;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ShXone
extends ConstraintOpN {
    public ShXone(List<Shape> others) {
        super(others);
    }

    @Override
    public Node getComponent() {
        return SHACL.XoneConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Graph data, Node node) {
        int c = 0;
        for (Shape sh : this.others) {
            ValidationContext vCxt2 = ValidationContext.create(vCxt);
            ValidationProc.execValidateShape(vCxt2, data, sh, node);
            boolean innerConforms = vCxt2.generateReport().conforms();
            if (!innerConforms) continue;
            ++c;
        }
        if (c == 1) {
            return null;
        }
        String msg = this.toString() + " has " + c + " conforming shapes at focusNode " + ShLib.displayStr(node);
        return new ReportItem(msg, node);
    }

    public String toString() {
        return "Xone";
    }
}

