/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeConst;

public class Imports {
    private Imports() {
    }

    public static Graph loadWithImports(String url) {
        url = IRIResolver.resolveString((String)url);
        Graph graph = RDFDataMgr.loadGraph((String)url);
        return Imports.withImportsWorker(url, graph);
    }

    public static Graph withImports(Graph graph) {
        return Imports.withImportsWorker(null, graph);
    }

    public static Graph withImports(String url, Graph graph) {
        url = IRIResolver.resolveString((String)url);
        return Imports.withImportsWorker(url, graph);
    }

    private static Graph withImportsWorker(String url, Graph graph) {
        boolean hasImports = G.contains((Graph)graph, null, (Node)NodeConst.nodeOwlImports, null);
        if (!hasImports) {
            return graph;
        }
        Graph acc = GraphFactory.createDefaultGraph();
        GraphUtil.addInto((Graph)acc, (Graph)graph);
        HashSet<String> visited = new HashSet<String>();
        if (url != null) {
            visited.add(url);
        }
        Imports.processImports(visited, graph, acc);
        return acc;
    }

    private static void processImports(Set<String> visited, Graph graph, Graph acc) {
        List<Node> imports = Imports.imports(graph);
        for (Node imported : imports) {
            String uri;
            if (!imported.isURI() || visited.contains(uri = imported.getURI())) continue;
            visited.add(uri);
            try {
                Graph g2 = RDFDataMgr.loadGraph((String)uri);
                GraphUtil.addInto((Graph)acc, (Graph)g2);
                Imports.processImports(visited, g2, acc);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public static List<Node> imports(Graph graph) {
        Pair<Node, List<Node>> pair = Imports.baseAndImports(graph);
        return (List)pair.getRight();
    }

    public static Pair<Node, List<Node>> baseAndImports(Graph graph) {
        Node base = G.getZeroOrOnePO((Graph)graph, (Node)NodeConst.nodeRDFType, (Node)NodeConst.nodeOwlOntology);
        if (base == null) {
            return Pair.create(null, Collections.emptyList());
        }
        List<Node> imports = Imports.allImports(base, graph);
        return Pair.create((Object)base, imports);
    }

    public static Node base(Graph graph) {
        return G.getZeroOrOnePO((Graph)graph, (Node)NodeConst.nodeRDFType, (Node)NodeConst.nodeOwlOntology);
    }

    public static List<Node> allImports(Node base, Graph graph) {
        List imports = (List)Iter.iter((Collection)G.listSP((Graph)graph, (Node)base, (Node)NodeConst.nodeOwlImports)).filter(Node::isURI).collect(Collectors.toList());
        return imports;
    }
}

